/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.util.Misc;

@Immutable
public class VertCoord {
    private String name;
    private final List<Level> coords;
    private final VertUnit unit;
    private final boolean isLayer;

    public static void assignVertNames(List<VertCoord> vertCoords, GribTables tables) {
        ArrayList<VertCoord> temp = new ArrayList<VertCoord>(vertCoords);
        for (VertCoord vc : temp) {
            String shortName = tables.getLevelNameShort(vc.getCode());
            if (vc.isLayer()) {
                shortName = shortName + "_layer";
            }
            vc.setName(shortName);
        }
        Collections.sort(temp, new Comparator<VertCoord>(){

            @Override
            public int compare(VertCoord o1, VertCoord o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        String lastName = null;
        int count = 0;
        for (VertCoord vc : temp) {
            String name = vc.getName();
            if (lastName == null || !lastName.equals(name)) {
                count = 0;
            } else {
                vc.setName(name + ++count);
            }
            lastName = name;
        }
    }

    public VertCoord(int code, List<Level> coords, boolean isLayer) {
        this.coords = coords;
        this.isLayer = isLayer;
        this.unit = Grib2Utils.getLevelUnit(code);
    }

    public VertCoord(List<Level> coords, VertUnit unit, boolean isLayer) {
        this.coords = coords;
        this.unit = unit;
        this.isLayer = isLayer;
    }

    public boolean isVertDimensionUsed() {
        return this.coords.size() == 1 ? this.unit.isVerticalCoordinate() : true;
    }

    public boolean isLayer() {
        return this.isLayer;
    }

    public boolean isPositiveUp() {
        return this.unit.isPositiveUp();
    }

    public List<Level> getCoords() {
        return this.coords;
    }

    public int getCode() {
        return this.unit.getCode();
    }

    public String getUnits() {
        return this.unit.getUnits();
    }

    public int getSize() {
        return this.coords.size();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public boolean equalsData(VertCoord other) {
        if (this.unit.getCode() != other.unit.getCode()) {
            return false;
        }
        if (this.isLayer != other.isLayer) {
            return false;
        }
        if (this.coords.size() != other.coords.size()) {
            return false;
        }
        for (int i = 0; i < this.coords.size(); ++i) {
            if (this.coords.get(i).equals(other.coords.get(i))) continue;
            return false;
        }
        return true;
    }

    public int findIdx(Level coord) {
        for (int i = 0; i < this.coords.size(); ++i) {
            if (!this.coords.get(i).equals(coord)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        Formatter out = new Formatter();
        out.format("(3D=%s) code=%d = ", this.isVertDimensionUsed(), this.getCode());
        for (Level lev : this.coords) {
            out.format("%s, ", lev.toString(this.isLayer));
        }
        out.format("units='%s' isLayer=%s", this.getUnits(), this.isLayer);
        return out.toString();
    }

    public String showCoords() {
        Formatter out = new Formatter();
        for (Level lev : this.coords) {
            out.format("%s, ", lev.toString(this.isLayer));
        }
        return out.toString();
    }

    public static int findCoord(List<VertCoord> vertCoords, VertCoord want) {
        if (want == null) {
            return -1;
        }
        for (int i = 0; i < vertCoords.size(); ++i) {
            if (!want.equalsData(vertCoords.get(i))) continue;
            return i;
        }
        vertCoords.add(want);
        return vertCoords.size() - 1;
    }

    @Immutable
    public static interface VertUnit {
        public int getCode();

        public String getUnits();

        public String getDatum();

        public boolean isLayer();

        public boolean isPositiveUp();

        public boolean isVerticalCoordinate();
    }

    @Immutable
    public static class Level
    implements Comparable<Level> {
        final double value1;
        final double value2;
        final double mid;

        public Level(double value1, double value2) {
            this.value1 = value1;
            this.value2 = value2;
            this.mid = value2 == 0.0 ? value1 : (value1 + value2) / 2.0;
        }

        public double getValue1() {
            return this.value1;
        }

        public double getValue2() {
            return this.value2;
        }

        @Override
        public int compareTo(Level o) {
            if (this.mid < o.mid) {
                return -1;
            }
            if (this.mid > o.mid) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object oo) {
            if (this == oo) {
                return true;
            }
            if (!(oo instanceof Level)) {
                return false;
            }
            Level other = (Level)oo;
            return Misc.closeEnough(this.value1, other.value1) && Misc.closeEnough(this.value2, other.value2);
        }

        public int hashCode() {
            long temp = this.value1 != 0.0 ? Double.doubleToLongBits(this.value1) : 0L;
            int result = (int)(temp ^ temp >>> 32);
            temp = this.value2 != 0.0 ? Double.doubleToLongBits(this.value2) : 0L;
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public String toString(boolean isLayer) {
            Formatter out = new Formatter();
            if (isLayer) {
                out.format("(%f,%f)", this.value1, this.value2);
            } else {
                out.format("%f", this.value1);
            }
            return out.toString();
        }
    }
}

