/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import thredds.inventory.CollectionManager;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.GribIosp;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.TimeCoordUnion;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.grib2.Grib2CollectionBuilder;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.Grib2TimePartition;
import ucar.nc2.grib.grib2.Grib2TimePartitionBuilder;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Misc;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.StringUtil2;

public class Grib2Iosp
extends GribIosp {
    private static final Logger logger = LoggerFactory.getLogger(Grib2Iosp.class);
    private static final boolean debugTime = false;
    private static final boolean debugRead = false;
    private static final boolean debugName = false;
    private static boolean useGenType = false;
    private Grib2TimePartition timePartition;
    private GribCollection gribCollection;
    private Grib2Customizer cust;
    private GribCollection.GroupHcs gHcs;
    private boolean isTimePartitioned;
    private boolean owned;

    public static String makeVariableName(Grib2Customizer tables, GribCollection gribCollection, GribCollection.VariableIndex vindex) {
        return Grib2Iosp.makeVariableNameFromTable(tables, gribCollection, vindex);
    }

    public static String makeVariableNameFromTable(Grib2Customizer tables, GribCollection gribCollection, GribCollection.VariableIndex vindex) {
        String statName;
        Formatter f = new Formatter();
        GribTables.Parameter param = tables.getParameter(vindex.discipline, vindex.category, vindex.parameter);
        if (param == null) {
            f.format("VAR%d-%d-%d_FROM_%d-%d-%d", vindex.discipline, vindex.category, vindex.parameter, gribCollection.getCenter(), gribCollection.getSubcenter(), vindex.tableVersion);
        } else {
            f.format("%s", GribUtils.makeNameFromDescription(param.getName()));
        }
        if (!(useGenType || vindex.genProcessType != 6 && vindex.genProcessType != 7)) {
            f.format("_error", new Object[0]);
        }
        if (vindex.levelType != -9999) {
            f.format("_%s", tables.getLevelNameShort(vindex.levelType));
            if (vindex.isLayer) {
                f.format("_layer", new Object[0]);
            }
        }
        if (vindex.intvName != null && !vindex.intvName.isEmpty()) {
            f.format("_%s", vindex.intvName);
        }
        if (vindex.intvType >= 0 && (statName = tables.getStatisticNameShort(vindex.intvType)) != null) {
            f.format("_%s", statName);
        }
        if (vindex.ensDerivedType >= 0) {
            f.format("_%s", tables.getProbabilityNameShort(vindex.ensDerivedType));
        } else if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
            String s = StringUtil2.substitute(vindex.probabilityName, ".", "p");
            f.format("_probability_%s", s);
        }
        if (vindex.genProcessType >= 0 && useGenType) {
            String genType = tables.getGeneratingProcessTypeName(vindex.genProcessType);
            String s = StringUtil2.substitute(genType, " ", "_");
            f.format("_%s", s);
        }
        return f.toString();
    }

    public static String makeVariableNameFromRecord(GribCollection.VariableIndex vindex) {
        Formatter f = new Formatter();
        f.format("VAR_%d-%d-%d", vindex.discipline, vindex.category, vindex.parameter);
        if (!(useGenType || vindex.genProcessType != 6 && vindex.genProcessType != 7)) {
            f.format("_error", new Object[0]);
        }
        if (vindex.levelType != -9999) {
            f.format("_L%d", vindex.levelType);
            if (vindex.isLayer) {
                f.format("_layer", new Object[0]);
            }
        }
        if (vindex.intvName != null && !vindex.intvName.isEmpty()) {
            if (vindex.intvName.equals("Mixed_intervals")) {
                f.format("_Imixed", new Object[0]);
            } else {
                f.format("_I%s", vindex.intvName);
            }
        }
        if (vindex.intvType >= 0) {
            f.format("_S%s", vindex.intvType);
        }
        if (vindex.ensDerivedType >= 0) {
            f.format("_D%d", vindex.ensDerivedType);
        } else if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
            String s = StringUtil2.substitute(vindex.probabilityName, ".", "p");
            f.format("_Prob_%s", s);
        }
        return f.toString();
    }

    public static String makeVariableLongName(Grib2Customizer cust, GribCollection.VariableIndex vindex) {
        GribTables.Parameter gp;
        boolean isProb;
        Formatter f = new Formatter();
        boolean bl = isProb = vindex.probabilityName != null && vindex.probabilityName.length() > 0;
        if (isProb) {
            f.format("Probability ", new Object[0]);
        }
        if ((gp = cust.getParameter(vindex.discipline, vindex.category, vindex.parameter)) == null) {
            f.format("Unknown Parameter %d-%d-%d", vindex.discipline, vindex.category, vindex.parameter);
        } else {
            f.format("%s", gp.getName());
        }
        if (vindex.intvType >= 0 && vindex.intvName != null && !vindex.intvName.isEmpty()) {
            String intvName = cust.getStatisticNameShort(vindex.intvType);
            if (intvName == null || intvName.equalsIgnoreCase("Missing")) {
                intvName = cust.getStatisticNameShort(vindex.intvType);
            }
            if (intvName == null) {
                f.format(" (%s)", vindex.intvName);
            } else {
                f.format(" (%s %s)", vindex.intvName, intvName);
            }
        } else if (vindex.intvType >= 0) {
            String intvName = cust.getStatisticNameShort(vindex.intvType);
            f.format(" (%s)", intvName);
        }
        if (vindex.ensDerivedType >= 0) {
            f.format(" (%s)", cust.getTableValue("4.7", vindex.ensDerivedType));
        } else if (isProb) {
            f.format(" %s %s", vindex.probabilityName, Grib2Iosp.getVindexUnits(cust, vindex));
        }
        if (!(useGenType || vindex.genProcessType != 6 && vindex.genProcessType != 7)) {
            f.format(" error", new Object[0]);
        } else if (useGenType && vindex.genProcessType >= 0) {
            f.format(" %s", cust.getGeneratingProcessTypeName(vindex.genProcessType));
        }
        if (vindex.levelType != -9999) {
            f.format(" @ %s", cust.getTableValue("4.5", vindex.levelType));
            if (vindex.isLayer) {
                f.format(" layer", new Object[0]);
            }
        }
        return f.toString();
    }

    public static String makeVariableUnits(Grib2Customizer tables, GribCollection.VariableIndex vindex) {
        if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
            return "%";
        }
        return Grib2Iosp.getVindexUnits(tables, vindex);
    }

    private static String getVindexUnits(Grib2Customizer tables, GribCollection.VariableIndex vindex) {
        GribTables.Parameter gp = tables.getParameter(vindex.discipline, vindex.category, vindex.parameter);
        String val = gp == null ? "" : gp.getUnit();
        return val == null ? "" : val;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        byte[] b = new byte["Grib2CollectionIndex".length()];
        raf.readFully(b);
        String magic = new String(b);
        if (magic.equals("Grib2CollectionIndex")) {
            return true;
        }
        if (magic.equals("Grib2Partition0Index")) {
            return true;
        }
        return Grib2RecordScanner.isValidFile(raf);
    }

    @Override
    public String getFileTypeId() {
        return DataFormatType.GRIB2.toString();
    }

    @Override
    public String getFileTypeDescription() {
        return "GRIB2 Collection";
    }

    public Grib2Iosp() {
    }

    public Grib2Iosp(GribCollection.GroupHcs gHcs) {
        this.gHcs = gHcs;
        this.owned = true;
    }

    public Grib2Iosp(GribCollection gc) {
        this.gribCollection = gc;
        this.owned = true;
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        boolean isGribFile;
        super.open(raf, ncfile, cancelTask);
        boolean bl = isGribFile = raf != null && Grib2RecordScanner.isValidFile(raf);
        if (isGribFile) {
            this.gribCollection = GribIndex.makeGribCollectionFromSingleFile(false, raf, this.gribConfig, CollectionManager.Force.test, logger);
            this.cust = Grib2Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getMaster(), this.gribCollection.getLocal());
        }
        if (this.gHcs != null) {
            this.gribCollection = this.gHcs.getGribCollection();
            if (this.gribCollection instanceof Grib2TimePartition) {
                this.isTimePartitioned = true;
                this.timePartition = (Grib2TimePartition)this.gribCollection;
            }
            this.cust = Grib2Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getMaster(), this.gribCollection.getLocal());
            this.addGroup(ncfile, this.gHcs, false);
        } else if (this.gribCollection != null) {
            if (this.gribCollection instanceof Grib2TimePartition) {
                this.isTimePartitioned = true;
                this.timePartition = (Grib2TimePartition)this.gribCollection;
            }
            this.cust = Grib2Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getMaster(), this.gribCollection.getLocal());
            ArrayList<GribCollection.GroupHcs> groups = new ArrayList<GribCollection.GroupHcs>(this.gribCollection.getGroups());
            Collections.sort(groups);
            boolean useGroups = groups.size() > 1;
            for (GribCollection.GroupHcs g : groups) {
                this.addGroup(ncfile, g, useGroups);
            }
        } else {
            String name;
            raf.seek(0L);
            byte[] b = new byte["Grib2Partition0Index".length()];
            raf.readFully(b);
            String magic = new String(b);
            this.isTimePartitioned = magic.equals("Grib2Partition0Index");
            String location = raf.getLocation();
            File f = new File(location);
            int pos = f.getName().lastIndexOf(".");
            String string = name = pos > 0 ? f.getName().substring(0, pos) : f.getName();
            if (this.isTimePartitioned) {
                this.timePartition = Grib2TimePartitionBuilder.createFromIndex(name, null, raf, logger);
                this.gribCollection = this.timePartition;
            } else {
                this.gribCollection = Grib2CollectionBuilder.createFromIndex(name, null, raf, this.gribConfig, logger);
            }
            this.cust = Grib2Customizer.factory(this.gribCollection.getCenter(), this.gribCollection.getSubcenter(), this.gribCollection.getMaster(), this.gribCollection.getLocal());
            ArrayList<GribCollection.GroupHcs> groups = new ArrayList<GribCollection.GroupHcs>(this.gribCollection.getGroups());
            Collections.sort(groups);
            boolean useGroups = groups.size() > 1;
            for (GribCollection.GroupHcs g : groups) {
                this.addGroup(ncfile, g, useGroups);
            }
        }
        String val = CommonCodeTable.getCenterName(this.gribCollection.getCenter(), 2);
        ncfile.addAttribute(null, new Attribute("Originating_or_generating_Center", val == null ? Integer.toString(this.gribCollection.getCenter()) : val));
        val = this.cust.getSubCenterName(this.gribCollection.getCenter(), this.gribCollection.getSubcenter());
        ncfile.addAttribute(null, new Attribute("Originating_or_generating_Subcenter", val == null ? Integer.toString(this.gribCollection.getSubcenter()) : val));
        ncfile.addAttribute(null, new Attribute("GRIB_table_version", this.gribCollection.getMaster() + "," + this.gribCollection.getLocal()));
        val = this.cust.getTableValue("4.3", this.gribCollection.getGenProcessType());
        if (val != null) {
            ncfile.addAttribute(null, new Attribute("Type_of_generating_process", val));
        }
        if ((val = this.cust.getGeneratingProcessName(this.gribCollection.getGenProcessId())) != null) {
            ncfile.addAttribute(null, new Attribute("Analysis_or_forecast_generating_process_identifier_defined_by_originating_centre", val));
        }
        if ((val = this.cust.getGeneratingProcessName(this.gribCollection.getBackProcessId())) != null) {
            ncfile.addAttribute(null, new Attribute("Background_generating_process_identifier_defined_by_originating_centre", val));
        }
        ncfile.addAttribute(null, new Attribute("Conventions", "CF-1.6"));
        ncfile.addAttribute(null, new Attribute("history", "Read using CDM IOSP Grib2Collection"));
        ncfile.addAttribute(null, new Attribute("featureType", FeatureType.GRID.name()));
        ncfile.addAttribute(null, new Attribute("file_format", this.getFileTypeId()));
        for (Parameter p : this.gribCollection.getParams()) {
            ncfile.addAttribute(null, new Attribute(p));
        }
    }

    private void addGroup(NetcdfFile ncfile, GribCollection.GroupHcs gHcs, boolean useGroups) {
        String horizDims;
        Group g;
        gHcs.assignVertNames(this.cust);
        GdsHorizCoordSys hcs = gHcs.hcs;
        String grid_mapping = hcs.getName() + "_Projection";
        if (useGroups) {
            g = new Group(ncfile, null, gHcs.getId());
            g.addAttribute(new Attribute("long_name", gHcs.getDescription()));
            try {
                ncfile.addGroup(null, g);
            }
            catch (Exception e) {
                logger.warn("Duplicate Group - skipping");
                return;
            }
        } else {
            g = ncfile.getRootGroup();
        }
        if (hcs == null) {
            logger.error("No GdsHorizCoordSys for gds template {} center {}", (Object)gHcs.hcs.template, (Object)this.gribCollection.getCenter());
            throw new IllegalStateException();
        }
        boolean is2D = Grib2Utils.isLatLon2D(gHcs.hcs.template, this.gribCollection.getCenter());
        if (is2D) {
            horizDims = "lat lon";
            ncfile.addDimension(g, new Dimension("lon", hcs.nx));
            ncfile.addDimension(g, new Dimension("lat", hcs.ny));
        } else if (Grib2Utils.isLatLon(gHcs.hcs.template, this.gribCollection.getCenter())) {
            horizDims = "lat lon";
            ncfile.addDimension(g, new Dimension("lon", hcs.nx));
            ncfile.addDimension(g, new Dimension("lat", hcs.ny));
            Variable cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "lat", DataType.FLOAT, "lat"));
            cv.addAttribute(new Attribute("units", "degrees_north"));
            if (hcs.gaussLats != null) {
                cv.setCachedData(hcs.gaussLats);
            } else {
                cv.setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy));
            }
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "lon", DataType.FLOAT, "lon"));
            cv.addAttribute(new Attribute("units", "degrees_east"));
            cv.setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx));
        } else {
            Variable hcsV = ncfile.addVariable(g, new Variable(ncfile, g, null, grid_mapping, DataType.INT, ""));
            hcsV.setCachedData(Array.factory(DataType.INT, new int[0], (Object)new int[]{0}));
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "y x";
            ncfile.addDimension(g, new Dimension("x", hcs.nx));
            ncfile.addDimension(g, new Dimension("y", hcs.ny));
            Variable cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "x", DataType.FLOAT, "x"));
            cv.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            cv.addAttribute(new Attribute("units", "km"));
            cv.setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx));
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "y", DataType.FLOAT, "y"));
            cv.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
            cv.addAttribute(new Attribute("units", "km"));
            cv.setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy));
        }
        for (VertCoord vc : gHcs.vertCoords) {
            this.addVerticalCoordinate(ncfile, g, vc);
        }
        for (TimeCoord tc : gHcs.timeCoords) {
            this.addTimeCoordinate(ncfile, g, tc);
        }
        int ccount = 0;
        for (EnsCoord ec : gHcs.ensCoords) {
            int n = ec.getSize();
            String ecName = "ens" + ccount;
            ncfile.addDimension(g, new Dimension(ecName, n));
            Variable v = new Variable(ncfile, g, null, ecName, DataType.INT, ecName);
            ncfile.addVariable(g, v);
            ++ccount;
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
            int[] data = new int[n];
            int count = 0;
            for (EnsCoord.Coord ecc : ec.getCoords()) {
                data[count++] = ecc.getEnsMember();
            }
            v.setCachedData(Array.factory(DataType.INT, new int[]{n}, (Object)data));
        }
        for (GribCollection.VariableIndex vindex : gHcs.varIndex) {
            GribTables.Parameter entry;
            String cat;
            TimeCoord tc = gHcs.timeCoords.get(vindex.timeIdx);
            VertCoord vc = vindex.vertIdx < 0 ? null : gHcs.vertCoords.get(vindex.vertIdx);
            EnsCoord ec = vindex.ensIdx < 0 ? null : gHcs.ensCoords.get(vindex.ensIdx);
            StringBuilder dims = new StringBuilder();
            String tcName = tc.getName();
            dims.append(tcName);
            if (ec != null) {
                dims.append(" ").append("ens").append(vindex.ensIdx);
            }
            if (vc != null) {
                dims.append(" ").append(vc.getName().toLowerCase());
            }
            dims.append(" ").append(horizDims);
            String vname = Grib2Iosp.makeVariableName(this.cust, this.gribCollection, vindex);
            Variable v = new Variable(ncfile, g, null, vname, DataType.FLOAT, dims.toString());
            ncfile.addVariable(g, v);
            String desc = Grib2Iosp.makeVariableLongName(this.cust, vindex);
            v.addAttribute(new Attribute("long_name", desc));
            v.addAttribute(new Attribute("units", Grib2Iosp.makeVariableUnits(this.cust, vindex)));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(Float.NaN)));
            GribTables.Parameter gp = this.cust.getParameter(vindex.discipline, vindex.category, vindex.parameter);
            if (gp != null) {
                if (gp.getDescription() != null) {
                    v.addAttribute(new Attribute("description", gp.getDescription()));
                }
                if (gp.getAbbrev() != null) {
                    v.addAttribute(new Attribute("abbreviation", gp.getAbbrev()));
                }
            }
            if (is2D) {
                String s = this.searchCoord(this.gribCollection, Grib2Utils.getLatLon2DcoordType(desc), gHcs.varIndex);
                if (s == null) {
                    v.setDimensions(horizDims);
                    String units = desc.contains("Latitude of") ? "degrees_north" : "degrees_east";
                    v.addAttribute(new Attribute("units", units));
                } else {
                    v.addAttribute(new Attribute("coordinates", s));
                }
            } else if (!hcs.isLatLon()) {
                v.addAttribute(new Attribute("grid_mapping", grid_mapping));
            }
            v.addAttribute(new Attribute("Grib_Variable_Id", Grib2Iosp.makeVariableNameFromRecord(vindex)));
            int[] param = new int[]{vindex.discipline, vindex.category, vindex.parameter};
            v.addAttribute(new Attribute("Grib2_Parameter", Array.factory(param)));
            String disc = this.cust.getTableValue("0.0", vindex.discipline);
            if (disc != null) {
                v.addAttribute(new Attribute("Grib2_Parameter_Discipline", disc));
            }
            if ((cat = this.cust.getCategory(vindex.discipline, vindex.category)) != null) {
                v.addAttribute(new Attribute("Grib2_Parameter_Category", cat));
            }
            if ((entry = this.cust.getParameter(vindex.discipline, vindex.category, vindex.parameter)) != null) {
                v.addAttribute(new Attribute("Grib2_Parameter_Name", entry.getName()));
            }
            if (vindex.levelType != 255) {
                v.addAttribute(new Attribute("Grib2_Level_Type", vindex.levelType));
            }
            if (vindex.intvName != null && vindex.intvName.length() != 0) {
                v.addAttribute(new Attribute("time_interval", vindex.intvName));
            }
            if (vindex.intvType >= 0) {
                CF.CellMethods cm;
                v.addAttribute(new Attribute("Grib2_Statistical_Interval_Type", vindex.intvType));
                GribStatType statType = this.cust.getStatType(vindex.intvType);
                if (statType != null && (cm = GribStatType.getCFCellMethod(statType)) != null) {
                    v.addAttribute(new Attribute("cell_methods", tcName + ": " + cm.toString()));
                }
            }
            if (vindex.ensDerivedType >= 0) {
                v.addAttribute(new Attribute("Grib2_Ensemble_Derived_Type", vindex.ensDerivedType));
            } else if (vindex.probabilityName != null && vindex.probabilityName.length() > 0) {
                v.addAttribute(new Attribute("Grib2_Probability_Type", vindex.probType));
                v.addAttribute(new Attribute("Grib2_Probability_Name", vindex.probabilityName));
            }
            if (vindex.genProcessType >= 0) {
                v.addAttribute(new Attribute("Grib2_Generating_Process_Type", this.cust.getGeneratingProcessTypeName(vindex.genProcessType)));
            }
            v.setSPobject(vindex);
        }
    }

    private void addTimeCoordinate(NetcdfFile ncfile, Group g, TimeCoord tc) {
        int n = tc.getSize();
        String tcName = tc.getName();
        ncfile.addDimension(g, new Dimension(tcName, n));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.INT, tcName));
        v.addAttribute(new Attribute("units", tc.getUnits()));
        v.addAttribute(new Attribute("standard_name", "time"));
        int[] data = new int[n];
        int count = 0;
        if (tc.isInterval()) {
            for (TimeCoord.Tinv tinv : tc.getIntervals()) {
                data[count++] = tinv.getBounds2();
            }
        } else {
            Iterator<Comparable<TimeCoord.Tinv>> i$ = tc.getCoords().iterator();
            while (i$.hasNext()) {
                int val = (Integer)i$.next();
                data[count++] = val;
            }
        }
        v.setCachedData(Array.factory(DataType.INT, new int[]{n}, (Object)data));
        if (tc.isInterval()) {
            String intvName = this.cust.getStatisticName(tc.getCode());
            if (intvName != null) {
                v.addAttribute(new Attribute("long_name", intvName));
            }
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName + "_bounds", DataType.INT, tcName + " 2"));
            v.addAttribute(new Attribute("bounds", tcName + "_bounds"));
            bounds.addAttribute(new Attribute("units", tc.getUnits()));
            bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
            data = new int[2 * n];
            count = 0;
            for (TimeCoord.Tinv tinv : tc.getIntervals()) {
                data[count++] = tinv.getBounds1();
                data[count++] = tinv.getBounds2();
            }
            bounds.setCachedData(Array.factory(DataType.INT, new int[]{n, 2}, (Object)data));
        }
    }

    private void addVerticalCoordinate(NetcdfFile ncfile, Group g, VertCoord vc) {
        int n = vc.getSize();
        String vcName = vc.getName().toLowerCase();
        ncfile.addDimension(g, new Dimension(vcName, n));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, vcName, DataType.FLOAT, vcName));
        if (vc.getUnits() != null) {
            v.addAttribute(new Attribute("units", vc.getUnits()));
            String desc = this.cust.getTableValue("4.5", vc.getCode());
            if (desc != null) {
                v.addAttribute(new Attribute("long_name", desc));
            }
            v.addAttribute(new Attribute("positive", vc.isPositiveUp() ? "up" : "down"));
        }
        v.addAttribute(new Attribute("Grib2_level_type", vc.getCode()));
        VertCoord.VertUnit vu = Grib2Utils.getLevelUnit(vc.getCode());
        if (vu != null && vu.getDatum() != null) {
            v.addAttribute(new Attribute("datum", vu.getDatum()));
        }
        if (vc.isLayer()) {
            float[] data = new float[n];
            int count = 0;
            for (VertCoord.Level val : vc.getCoords()) {
                data[count++] = (float)(val.getValue1() + val.getValue2()) / 2.0f;
            }
            v.setCachedData(Array.factory(DataType.FLOAT, new int[]{n}, (Object)data));
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, vcName + "_bounds", DataType.FLOAT, vcName + " 2"));
            v.addAttribute(new Attribute("bounds", vcName + "_bounds"));
            bounds.addAttribute(new Attribute("units", vc.getUnits()));
            bounds.addAttribute(new Attribute("long_name", "bounds for " + vcName));
            data = new float[2 * n];
            count = 0;
            for (VertCoord.Level level : vc.getCoords()) {
                data[count++] = (float)level.getValue1();
                data[count++] = (float)level.getValue2();
            }
            bounds.setCachedData(Array.factory(DataType.FLOAT, new int[]{n, 2}, (Object)data));
        } else {
            float[] data = new float[n];
            int count = 0;
            for (VertCoord.Level val : vc.getCoords()) {
                data[count++] = (float)val.getValue1();
            }
            v.setCachedData(Array.factory(DataType.FLOAT, new int[]{n}, (Object)data));
        }
    }

    private String searchCoord(GribCollection gc, Grib2Utils.LatLonCoordType type, List<GribCollection.VariableIndex> list) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case U: {
                GribCollection.VariableIndex lat = this.searchCoord(list, 198);
                GribCollection.VariableIndex lon = this.searchCoord(list, 199);
                return lat != null && lon != null ? Grib2Iosp.makeVariableName(this.cust, gc, lat) + " " + Grib2Iosp.makeVariableName(this.cust, gc, lon) : null;
            }
            case V: {
                GribCollection.VariableIndex lat = this.searchCoord(list, 200);
                GribCollection.VariableIndex lon = this.searchCoord(list, 201);
                return lat != null && lon != null ? Grib2Iosp.makeVariableName(this.cust, gc, lat) + " " + Grib2Iosp.makeVariableName(this.cust, gc, lon) : null;
            }
            case P: {
                GribCollection.VariableIndex lat = this.searchCoord(list, 202);
                GribCollection.VariableIndex lon = this.searchCoord(list, 203);
                return lat != null && lon != null ? Grib2Iosp.makeVariableName(this.cust, gc, lat) + "  " + Grib2Iosp.makeVariableName(this.cust, gc, lon) : null;
            }
        }
        return null;
    }

    private GribCollection.VariableIndex searchCoord(List<GribCollection.VariableIndex> list, int p) {
        for (GribCollection.VariableIndex vindex : list) {
            if (vindex.discipline != 0 || vindex.category != 2 || vindex.parameter != p) continue;
            return vindex;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (!this.owned && this.gribCollection != null) {
            this.gribCollection.close();
        }
        this.gribCollection = null;
        super.close();
    }

    @Override
    public String getDetailInfo() {
        Formatter f = new Formatter();
        f.format("%s", super.getDetailInfo());
        if (this.gribCollection != null) {
            this.gribCollection.showIndex(f);
        }
        return f.toString();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        Array result = this.isTimePartitioned ? this.readDataFromPartition(v2, section) : this.readDataFromCollection(v2, section);
        long took = System.currentTimeMillis() - start;
        return result;
    }

    @Override
    public long streamToByteChannel(Variable v2, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        long result = this.streamDataFromCollection(v2, section, channel);
        long took = System.currentTimeMillis() - start;
        return result;
    }

    private Array readDataFromPartition(Variable v2, Section section) throws IOException, InvalidRangeException {
        TimePartition.VariableIndexPartitioned vindexP = (TimePartition.VariableIndexPartitioned)v2.getSPobject();
        int rangeIdx = 0;
        Range timeRange = section.getRank() > 2 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range ensRange = vindexP.ensIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range levRange = vindexP.vertIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range yRange = section.getRange(rangeIdx++);
        Range xRange = section.getRange(rangeIdx);
        DataReceiver dataReceiver = new DataReceiver(section, yRange, xRange);
        DataReaderPartitioned dataReader = new DataReaderPartitioned();
        TimeCoordUnion timeCoordP = (TimeCoordUnion)vindexP.getTimeCoord();
        for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
            TimeCoordUnion.Val val = timeCoordP.getVal(timeIdx);
            int partno = val.getPartition();
            GribCollection.VariableIndex vindex = vindexP.getVindex(partno);
            for (int ensIdx = ensRange.first(); ensIdx <= ensRange.last(); ensIdx += ensRange.stride()) {
                for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                    int resultIndex = GribCollection.calcIndex(timeRange.index(timeIdx), ensRange.index(ensIdx), levRange.index(levelIdx), ensRange.length(), levRange.length());
                    int recordIndex = -1;
                    int flag = vindexP.flag[partno];
                    recordIndex = flag == 0 ? GribCollection.calcIndex(val.getIndex(), ensIdx, levelIdx, vindex.nens, vindex.nverts) : GribCollection.calcIndex(val.getIndex(), ensIdx, levelIdx, flag, vindex.getEnsCoord(), vindex.getVertCoord(), vindexP.getEnsCoord(), vindexP.getVertCoord());
                    if (recordIndex < 0) continue;
                    if (recordIndex < vindex.records.length) {
                        GribCollection.Record record = vindex.records[recordIndex];
                        dataReader.addRecord(vindex, partno, record.fileno, record.pos, record.bmsPos, resultIndex);
                        continue;
                    }
                    Formatter f = new Formatter();
                    f.format("recordIndex=%d size=%d%n", recordIndex, vindex.records.length);
                    if (flag == 0) {
                        f.format("time=%d, ens=%d, level=%d, nens=%d, nverts=%d", val.getIndex(), ensIdx, levelIdx, vindex.nens, vindex.nverts);
                    } else {
                        f.format("time=%d, ens=%d, level=%d, flag=%d, nens=%s, vert=%s ensp=%s, vertp=%s", val.getIndex(), ensIdx, levelIdx, flag, vindex.getEnsCoord(), vindex.getVertCoord(), vindexP.getEnsCoord(), vindexP.getVertCoord());
                    }
                    logger.error("recordIndex out of bounds: " + f.toString());
                }
            }
        }
        dataReader.read(dataReceiver);
        vindexP.cleanup();
        return dataReceiver.getArray();
    }

    private Array readDataFromCollection(Variable v, Section section) throws IOException, InvalidRangeException {
        GribCollection.VariableIndex vindex = (GribCollection.VariableIndex)v.getSPobject();
        if (vindex.records == null) {
            vindex.readRecords();
        }
        int rangeIdx = 0;
        Range timeRange = section.getRank() > 2 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range ensRange = vindex.ensIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range levRange = vindex.vertIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range yRange = section.getRange(rangeIdx++);
        Range xRange = section.getRange(rangeIdx);
        DataReceiver dataReceiver = new DataReceiver(section, yRange, xRange);
        DataReader dataReader = new DataReader(vindex);
        for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
            for (int ensIdx = ensRange.first(); ensIdx <= ensRange.last(); ensIdx += ensRange.stride()) {
                for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                    int resultIndex = GribCollection.calcIndex(timeRange.index(timeIdx), ensRange.index(ensIdx), levRange.index(levelIdx), ensRange.length(), levRange.length());
                    dataReader.addRecord(ensIdx, timeIdx, levelIdx, resultIndex);
                }
            }
        }
        dataReader.read(dataReceiver);
        return dataReceiver.getArray();
    }

    private long streamDataFromCollection(Variable v, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        GribCollection.VariableIndex vindex = (GribCollection.VariableIndex)v.getSPobject();
        if (vindex.records == null) {
            vindex.readRecords();
        }
        int rangeIdx = 0;
        Range timeRange = section.getRank() > 2 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range ensRange = vindex.ensIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range levRange = vindex.vertIdx >= 0 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range yRange = section.getRange(rangeIdx++);
        Range xRange = section.getRange(rangeIdx);
        ChannelReceiver dataReceiver = new ChannelReceiver(channel, yRange, xRange);
        DataReader dataReader = new DataReader(vindex);
        for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
            for (int ensIdx = ensRange.first(); ensIdx <= ensRange.last(); ensIdx += ensRange.stride()) {
                for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                    int resultIndex = GribCollection.calcIndex(timeRange.index(timeIdx), ensRange.index(ensIdx), levRange.index(levelIdx), ensRange.length(), levRange.length());
                    dataReader.addRecord(ensIdx, timeIdx, levelIdx, resultIndex);
                }
            }
        }
        dataReader.read(dataReceiver);
        return 0L;
    }

    private void show(Grib2Record gr, long pos) {
        if (gr != null) {
            Formatter f = new Formatter();
            f.format("File=%s%n", this.raf.getLocation());
            f.format("  Parameter=%s%n", this.cust.getVariableName(gr));
            f.format("  ReferenceDate=%s%n", gr.getReferenceDate());
            f.format("  ForecastDate=%s%n", this.cust.getForecastDate(gr));
            TimeCoord.TinvDate tinv = this.cust.getForecastTimeInterval(gr);
            if (tinv != null) {
                f.format("  TimeInterval=%s%n", tinv);
            }
            f.format("  ", new Object[0]);
            gr.getPDS().show(f);
            System.out.printf("%nGrib2Record.readData at drsPos %d = %s%n", pos, f.toString());
        }
    }

    private class ChannelReceiver
    implements DataReceiverIF {
        private WritableByteChannel channel;
        private DataOutputStream outStream;
        private Range yRange;
        private Range xRange;

        ChannelReceiver(WritableByteChannel channel, Range yRange, Range xRange) {
            this.channel = channel;
            this.outStream = new DataOutputStream(Channels.newOutputStream(channel));
            this.yRange = yRange;
            this.xRange = xRange;
        }

        @Override
        public void addData(float[] data, int resultIndex, int nx) throws IOException {
            for (int y = this.yRange.first(); y <= this.yRange.last(); y += this.yRange.stride()) {
                for (int x = this.xRange.first(); x <= this.xRange.last(); x += this.xRange.stride()) {
                    int dataIdx = y * nx + x;
                    this.outStream.writeFloat(data[dataIdx]);
                }
            }
        }
    }

    private class DataReceiver
    implements DataReceiverIF {
        private Array dataArray;
        private Range yRange;
        private Range xRange;
        private int horizSize;

        DataReceiver(Section section, Range yRange, Range xRange) {
            this.dataArray = Array.factory(DataType.FLOAT, section.getShape());
            this.yRange = yRange;
            this.xRange = xRange;
            this.horizSize = yRange.length() * xRange.length();
            IndexIterator iter = this.dataArray.getIndexIterator();
            while (iter.hasNext()) {
                iter.setFloatNext(Float.NaN);
            }
        }

        @Override
        public void addData(float[] data, int resultIndex, int nx) throws IOException {
            int start = resultIndex * this.horizSize;
            int count = 0;
            for (int y = this.yRange.first(); y <= this.yRange.last(); y += this.yRange.stride()) {
                for (int x = this.xRange.first(); x <= this.xRange.last(); x += this.xRange.stride()) {
                    int dataIdx = y * nx + x;
                    if (dataIdx >= data.length) {
                        System.out.println("HEY");
                    }
                    this.dataArray.setFloat(start + count, data[dataIdx]);
                    ++count;
                }
            }
        }

        Array getArray() {
            return this.dataArray;
        }
    }

    private static interface DataReceiverIF {
        public void addData(float[] var1, int var2, int var3) throws IOException;
    }

    private class DataReader {
        GribCollection.VariableIndex vindex;
        List<DataRecord> records = new ArrayList<DataRecord>();

        private DataReader(GribCollection.VariableIndex vindex) {
            this.vindex = vindex;
        }

        void addRecord(int ensIdx, int timeIdx, int levIdx, int resultIndex) {
            int recordIndex = GribCollection.calcIndex(timeIdx, ensIdx, levIdx, this.vindex.nens, this.vindex.nverts);
            GribCollection.Record record = this.vindex.records[recordIndex];
            this.records.add(new DataRecord(timeIdx, ensIdx, levIdx, resultIndex, record.fileno, record.pos, record.bmsPos));
        }

        void read(DataReceiverIF dataReceiver) throws IOException {
            Collections.sort(this.records);
            int currFile = -1;
            RandomAccessFile rafData = null;
            for (DataRecord dr : this.records) {
                if (dr.fileno != currFile) {
                    if (rafData != null) {
                        rafData.close();
                    }
                    rafData = Grib2Iosp.this.gribCollection.getDataRaf(dr.fileno);
                    currFile = dr.fileno;
                }
                if (dr.drsPos == -1L) continue;
                float[] data = Grib2Record.readData(rafData, dr.drsPos, dr.bmsPos, this.vindex.group.hcs.gdsNumberPoints, this.vindex.group.hcs.scanMode, this.vindex.group.hcs.nxRaw, this.vindex.group.hcs.nyRaw, this.vindex.group.hcs.nptsInLine);
                dataReceiver.addData(data, dr.resultIndex, this.vindex.group.hcs.nx);
            }
            if (rafData != null) {
                rafData.close();
            }
        }

        private class DataRecord
        implements Comparable<DataRecord> {
            int ensIdx;
            int timeIdx;
            int levIdx;
            int resultIndex;
            int fileno;
            long drsPos;
            long bmsPos;

            DataRecord(int timeIdx, int ensIdx, int levIdx, int resultIndex, int fileno, long drsPos, long bmsPos) {
                this.ensIdx = ensIdx;
                this.timeIdx = timeIdx;
                this.levIdx = levIdx;
                this.resultIndex = resultIndex;
                this.fileno = fileno;
                this.drsPos = drsPos;
                this.bmsPos = bmsPos;
            }

            @Override
            public int compareTo(DataRecord o) {
                int r = Misc.compare(this.fileno, o.fileno);
                if (r != 0) {
                    return r;
                }
                return Misc.compare(this.drsPos, o.drsPos);
            }
        }
    }

    private class DataReaderPartitioned {
        List<DataRecord> records = new ArrayList<DataRecord>();

        private DataReaderPartitioned() {
        }

        void addRecord(GribCollection.VariableIndex vindex, int partno, int fileno, long drsPos, long bmsPos, int resultIndex) {
            this.records.add(new DataRecord(partno, vindex, resultIndex, fileno, drsPos, bmsPos));
        }

        void read(DataReceiver dataReceiver) throws IOException {
            Collections.sort(this.records);
            int currPartno = -1;
            int currFile = -1;
            RandomAccessFile rafData = null;
            for (DataRecord dr : this.records) {
                if (dr.partno != currPartno || dr.fileno != currFile) {
                    if (rafData != null) {
                        rafData.close();
                    }
                    rafData = Grib2Iosp.this.timePartition.getRaf(dr.partno, dr.fileno);
                    currFile = dr.fileno;
                    currPartno = dr.partno;
                }
                if (dr.drsPos == -1L) continue;
                float[] data = Grib2Record.readData(rafData, dr.drsPos, dr.bmsPos, dr.vindex.group.hcs.gdsNumberPoints, dr.vindex.group.hcs.scanMode, dr.vindex.group.hcs.nxRaw, dr.vindex.group.hcs.nyRaw, dr.vindex.group.hcs.nptsInLine);
                dataReceiver.addData(data, dr.resultIndex, dr.vindex.group.hcs.nx);
            }
            if (rafData != null) {
                rafData.close();
            }
        }

        private class DataRecord
        implements Comparable<DataRecord> {
            int partno;
            GribCollection.VariableIndex vindex;
            int resultIndex;
            int fileno;
            long drsPos;
            long bmsPos;

            DataRecord(int partno, GribCollection.VariableIndex vindex, int resultIndex, int fileno, long drsPos, long bmsPos) {
                this.partno = partno;
                this.vindex = vindex;
                this.resultIndex = resultIndex;
                this.fileno = fileno;
                this.drsPos = drsPos == 0L ? -1L : drsPos;
                this.bmsPos = bmsPos;
            }

            @Override
            public int compareTo(DataRecord o) {
                int r = Misc.compare(this.partno, o.partno);
                if (r != 0) {
                    return r;
                }
                r = Misc.compare(this.fileno, o.fileno);
                if (r != 0) {
                    return r;
                }
                return Misc.compare(this.drsPos, o.drsPos);
            }
        }
    }
}

