/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.GribCollection;
import ucar.nc2.grib.TimePartition;
import ucar.nc2.grib.grib2.Grib2Iosp;

public class Grib2TimePartition
extends TimePartition {
    Grib2TimePartition(String name, File directory, FeatureCollectionConfig.GribConfig dcm, Logger logger) {
        super(name, directory, dcm, false, logger);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(String groupName, String filename, FeatureCollectionConfig.GribConfig gribConfig, Logger logger) throws IOException {
        GribCollection.GroupHcs want = this.findGroupById(groupName);
        if (want == null) {
            return null;
        }
        Grib2Iosp iosp = new Grib2Iosp(want);
        GribCollection.GcNetcdfFile ncfile = new GribCollection.GcNetcdfFile(iosp, null, this.getIndexFile().getPath(), null);
        return new NetcdfDataset(ncfile);
    }

    @Override
    public GridDataset getGridDataset(String groupName, String filename, FeatureCollectionConfig.GribConfig gribConfig, Logger logger) throws IOException {
        GribCollection.GroupHcs want = this.findGroupById(groupName);
        if (want == null) {
            return null;
        }
        Grib2Iosp iosp = new Grib2Iosp(want);
        GribCollection.GcNetcdfFile ncfile = new GribCollection.GcNetcdfFile(iosp, null, this.getIndexFile().getPath(), null);
        NetcdfDataset ncd = new NetcdfDataset(ncfile);
        return new GridDataset(ncd);
    }
}

