/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.time;

import java.util.StringTokenizer;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public final class TimeUtils {
    private TimeUtils() {
        throw new AssertionError();
    }

    public static long getUnitLengthMillis(String unit) {
        if ((unit = unit.trim()).equals("seconds") || unit.equals("second") || unit.equals("secs") || unit.equals("sec") || unit.equals("s")) {
            return 1000L;
        }
        if (unit.equals("minutes") || unit.equals("minute") || unit.equals("mins") || unit.equals("min")) {
            return 60000L;
        }
        if (unit.equals("hours") || unit.equals("hour") || unit.equals("hrs") || unit.equals("hr") || unit.equals("h")) {
            return 3600000L;
        }
        if (unit.equals("days") || unit.equals("day") || unit.equals("d")) {
            return 86400000L;
        }
        throw new IllegalArgumentException("Unrecognized unit for time axis: " + unit);
    }

    public static DateTime parseUdunitsTimeString(String baseDateTimeString) {
        return TimeUtils.parseUdunitsTimeString(baseDateTimeString, null);
    }

    public static DateTime parseUdunitsTimeString(String baseDateTimeString, Chronology chronology) {
        if (chronology == null) {
            chronology = ISOChronology.getInstanceUTC();
        }
        if (!chronology.getZone().equals(DateTimeZone.UTC)) {
            throw new IllegalArgumentException("The time zone of the Chronology must be UTC");
        }
        int year = 0;
        int month = 1;
        int day = 1;
        int hour = 0;
        int minute = 0;
        double second = 0.0;
        StringTokenizer tokenizer = new StringTokenizer(baseDateTimeString, " ");
        try {
            if (tokenizer.hasMoreTokens()) {
                StringTokenizer dateTokenizer = new StringTokenizer(tokenizer.nextToken(), "-");
                if (dateTokenizer.hasMoreTokens()) {
                    year = Integer.parseInt(dateTokenizer.nextToken());
                }
                if (dateTokenizer.hasMoreTokens()) {
                    month = Integer.parseInt(dateTokenizer.nextToken());
                }
                if (dateTokenizer.hasMoreTokens()) {
                    day = Integer.parseInt(dateTokenizer.nextToken());
                }
            }
            if (tokenizer.hasMoreTokens()) {
                StringTokenizer timeTokenizer = new StringTokenizer(tokenizer.nextToken(), ":");
                if (timeTokenizer.hasMoreTokens()) {
                    hour = Integer.parseInt(timeTokenizer.nextToken());
                }
                if (timeTokenizer.hasMoreTokens()) {
                    minute = Integer.parseInt(timeTokenizer.nextToken());
                }
                if (timeTokenizer.hasMoreTokens()) {
                    second = Double.parseDouble(timeTokenizer.nextToken());
                }
            }
            DateTime dt = new DateTime(year, month, day, hour, minute, 0, 0, chronology);
            dt = dt.plus((long)(1000.0 * second));
            if (tokenizer.hasMoreTokens()) {
                StringTokenizer zoneTokenizer = new StringTokenizer(tokenizer.nextToken(), ":");
                int hourOffset = zoneTokenizer.hasMoreTokens() ? Integer.parseInt(zoneTokenizer.nextToken()) : 0;
                int minuteOffset = zoneTokenizer.hasMoreTokens() ? Integer.parseInt(zoneTokenizer.nextToken()) : 0;
                DateTimeZone dtz = DateTimeZone.forOffsetHoursMinutes(hourOffset, minuteOffset);
                dt = dt.withZoneRetainFields(dtz);
                dt = dt.withZone(DateTimeZone.UTC);
            }
            return dt;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Illegal base time specification " + baseDateTimeString);
        }
    }
}

