/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.util.Formatter;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class RafNimbus
extends TableConfigurerImpl {
    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String center = ds.findAttValueIgnoreCase(null, "Convention", null);
        return "NCAR-RAF/nimbus".equals(center);
    }

    @Override
    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) {
        TableConfig topTable = new TableConfig(Table.Type.Top, "singleTrajectory");
        CoordinateAxis coordAxis = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (coordAxis == null) {
            errlog.format("Cant find a time coordinate", new Object[0]);
            return null;
        }
        Dimension innerDim = coordAxis.getDimension(0);
        boolean obsIsStruct = Evaluator.hasNetcdf3RecordStructure(ds) && innerDim.isUnlimited();
        TableConfig obsTable = new TableConfig(Table.Type.Structure, innerDim.getShortName());
        obsTable.dimName = innerDim.getShortName();
        obsTable.time = coordAxis.getFullName();
        obsTable.structName = obsIsStruct ? "record" : innerDim.getShortName();
        obsTable.structureType = obsIsStruct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
        CoordSysEvaluator.findCoords(obsTable, ds, axis -> innerDim.equals(axis.getDimension(0)));
        topTable.addChild(obsTable);
        return topTable;
    }
}

