/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.adapter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.RangeComposite;
import ucar.ma2.RangeIterator;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerHelper;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.ft2.coverage.CoordAxisReader;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageReader;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.LatLonAxis2D;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.TimeAxis2DFmrc;
import ucar.nc2.ft2.coverage.TimeAxis2DSwath;
import ucar.nc2.ft2.coverage.TimeOffsetAxis;
import ucar.nc2.ft2.coverage.adapter.DtCoverage;
import ucar.nc2.ft2.coverage.adapter.DtCoverageCS;
import ucar.nc2.ft2.coverage.adapter.DtCoverageDataset;
import ucar.nc2.util.Misc;
import ucar.nc2.util.Optional;
import ucar.unidata.util.Parameter;

public class DtCoverageAdapter
implements CoverageReader,
CoordAxisReader {
    private static boolean debug;
    private final DtCoverageDataset proxy;

    public static FeatureDatasetCoverage factory(DtCoverageDataset proxy, Formatter errlog) {
        DtCoverageAdapter reader = new DtCoverageAdapter(proxy);
        AttributeContainerHelper atts = new AttributeContainerHelper(proxy.getName());
        atts.addAll(proxy.getGlobalAttributes());
        ArrayList<Coverage> pgrids = new ArrayList<Coverage>();
        for (DtCoverage dtGrid : proxy.getGrids()) {
            pgrids.add(DtCoverageAdapter.makeCoverage(dtGrid, reader));
        }
        HashSet<String> transformNames = new HashSet<String>();
        ArrayList<CoverageTransform> transforms = new ArrayList<CoverageTransform>();
        for (DtCoverageDataset.Gridset gset : proxy.getGridsets()) {
            DtCoverageCS gcs = gset.getGeoCoordSystem();
            for (CoordinateTransform ct : gcs.getCoordTransforms()) {
                if (transformNames.contains(ct.getName())) continue;
                transforms.add(DtCoverageAdapter.makeTransform(ct));
                transformNames.add(ct.getName());
            }
        }
        ArrayList<CoverageCoordAxis> covAxes = new ArrayList<CoverageCoordAxis>();
        HashMap<String, CoverageCoordAxis> covAxesMap = new HashMap<String, CoverageCoordAxis>();
        for (DtCoverageDataset.Gridset gridset : proxy.getGridsets()) {
            DtCoverageCS gcs = gridset.getGeoCoordSystem();
            for (CoordinateAxis axis : gcs.getCoordAxes()) {
                if (null != covAxesMap.get(axis.getFullName())) continue;
                Optional<CoverageCoordAxis> opt = DtCoverageAdapter.makeCoordAxis(proxy.getCoverageType(), axis, reader);
                if (!opt.isPresent()) {
                    errlog.format("%s%n", opt.getErrorMessage());
                    continue;
                }
                CoverageCoordAxis covAxis = opt.get();
                covAxes.add(covAxis);
                covAxesMap.put(covAxis.getName(), covAxis);
            }
        }
        ArrayList tmpList = new ArrayList(covAxes);
        for (Object covAxis : tmpList) {
            if (((CoverageCoordAxis)covAxis).getDependsOn() == null) continue;
            for (String dep : ((CoverageCoordAxis)covAxis).getDependsOnList()) {
                if (covAxesMap.get(dep) != null) continue;
                Dimension dim = proxy.findDimension(dep);
                CoverageCoordAxis dimAxis = DtCoverageAdapter.makeCoordAxisFromDimension(dim);
                covAxes.add(dimAxis);
                covAxesMap.put(dimAxis.getName(), dimAxis);
            }
        }
        ArrayList<CoverageCoordSys> arrayList = new ArrayList<CoverageCoordSys>();
        for (DtCoverageDataset.Gridset gset : proxy.getGridsets()) {
            arrayList.add(DtCoverageAdapter.makeCoordSys(gset.getGeoCoordSystem(), covAxesMap));
        }
        CoverageCollection cd2 = new CoverageCollection(proxy.getName(), proxy.getCoverageType(), atts, null, null, proxy.getCalendarDateRange(), arrayList, transforms, covAxes, pgrids, reader);
        return new FeatureDatasetCoverage(reader.getLocation(), reader, cd2);
    }

    private static Coverage makeCoverage(DtCoverage dt, DtCoverageAdapter reader) {
        return new Coverage(dt.getName(), dt.getDataType(), dt.getAttributes(), dt.getCoordinateSystem().getName(), dt.getUnitsString(), dt.getDescription(), reader, dt);
    }

    private static CoverageCoordSys makeCoordSys(DtCoverageCS dt, Map<String, CoverageCoordAxis> covAxesMap) {
        ArrayList<String> transformNames = new ArrayList<String>();
        for (CoordinateTransform coordinateTransform : dt.getCoordTransforms()) {
            transformNames.add(coordinateTransform.getName());
        }
        HashSet<CoverageCoordAxis> covAxes = new HashSet<CoverageCoordAxis>();
        for (CoordinateAxis axis : dt.getCoordAxes()) {
            CoverageCoordAxis covAxis = covAxesMap.get(axis.getFullName());
            if (covAxis == null) continue;
            covAxes.add(covAxis);
            for (String dep : covAxis.getDependsOnList()) {
                CoverageCoordAxis depAxis = covAxesMap.get(dep);
                if (depAxis == null) continue;
                covAxes.add(depAxis);
            }
        }
        ArrayList arrayList = new ArrayList(covAxes);
        Collections.sort(arrayList);
        ArrayList<String> covAxesNames = new ArrayList<String>();
        for (CoverageCoordAxis axis : arrayList) {
            covAxesNames.add(axis.getName());
        }
        return new CoverageCoordSys(dt.getName(), covAxesNames, transformNames, dt.getCoverageType());
    }

    private static CoverageTransform makeTransform(CoordinateTransform dt) {
        AttributeContainerHelper atts = new AttributeContainerHelper(dt.getName());
        for (Parameter p : dt.getParameters()) {
            atts.addAttribute(new Attribute(p));
        }
        return new CoverageTransform(dt.getName(), atts, dt.getTransformType() == TransformType.Projection);
    }

    private static CoverageCoordAxis makeCoordAxisFromDimension(Dimension dim) {
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder();
        builder.name = dim.getFullName();
        builder.dataType = DataType.INT;
        builder.axisType = AxisType.Dimension;
        builder.dependenceType = CoverageCoordAxis.DependenceType.dimension;
        builder.spacing = CoverageCoordAxis.Spacing.regularPoint;
        builder.ncoords = dim.getLength();
        builder.startValue = 0.0;
        builder.endValue = dim.getLength() - 1;
        builder.resolution = 1.0;
        return new CoverageCoordAxis1D(builder);
    }

    private static Optional<CoverageCoordAxis> makeCoordAxis(FeatureType ftype, CoordinateAxis dtCoordAxis, DtCoverageAdapter reader) {
        ArrayDouble.D3 bounds;
        double[] values;
        CoverageCoordAxis.Spacing spacing;
        Formatter f;
        CoverageCoordAxis.DependenceType dependenceType;
        String name = dtCoordAxis.getFullName();
        DataType dataType = dtCoordAxis.getDataType();
        AxisType axisType = dtCoordAxis.getAxisType();
        String units = dtCoordAxis.getUnitsString();
        String description = dtCoordAxis.getDescription();
        AttributeContainer atts = dtCoordAxis.getAttributeContainer();
        if (axisType == null) {
            return Optional.empty("Coordinate " + name + " has no axisType");
        }
        String dependsOn = null;
        if (dtCoordAxis.isIndependentCoordinate()) {
            dependenceType = CoverageCoordAxis.DependenceType.independent;
        } else if (dtCoordAxis.isScalar()) {
            dependenceType = CoverageCoordAxis.DependenceType.scalar;
        } else if (dtCoordAxis instanceof CoordinateAxis2D) {
            dependenceType = CoverageCoordAxis.DependenceType.twoD;
            f = new Formatter();
            for (Dimension d : dtCoordAxis.getDimensions()) {
                f.format("%s ", d.getFullName());
            }
            dependsOn = f.toString().trim();
        } else {
            dependenceType = CoverageCoordAxis.DependenceType.dependent;
            f = new Formatter();
            for (Dimension d : dtCoordAxis.getDimensions()) {
                f.format("%s ", d.getFullName());
            }
            dependsOn = f.toString().trim();
        }
        int ncoords = (int)dtCoordAxis.getSize();
        double startValue = 0.0;
        double endValue = 0.0;
        double resolution = 0.0;
        if (dtCoordAxis instanceof CoordinateAxis1D) {
            double[] values2;
            CoordinateAxis1D axis1D = (CoordinateAxis1D)dtCoordAxis;
            axis1D.correctLongitudeWrap();
            startValue = axis1D.getCoordValue(0);
            endValue = axis1D.getCoordValue((int)dtCoordAxis.getSize() - 1);
            if (axis1D.isRegular() || axis1D.isScalar()) {
                spacing = CoverageCoordAxis.Spacing.regularPoint;
                values2 = null;
                resolution = ncoords == 1 ? 0.0 : (endValue - startValue) / (double)(ncoords - 1);
            } else if (!dtCoordAxis.isInterval()) {
                spacing = CoverageCoordAxis.Spacing.irregularPoint;
                values2 = axis1D.getCoordValues();
                resolution = ncoords == 1 ? 0.0 : (endValue - startValue) / (double)(ncoords - 1);
            } else if (dtCoordAxis.isContiguous()) {
                spacing = CoverageCoordAxis.Spacing.contiguousInterval;
                values2 = axis1D.getCoordEdges();
                resolution = (endValue - startValue) / (double)ncoords;
            } else {
                spacing = CoverageCoordAxis.Spacing.discontiguousInterval;
                values2 = new double[2 * ncoords];
                double[] bounds1 = axis1D.getBound1();
                double[] bounds2 = axis1D.getBound2();
                int count = 0;
                for (int i = 0; i < ncoords; ++i) {
                    values2[count++] = bounds1[i];
                    values2[count++] = bounds2[i];
                }
                resolution = (endValue - startValue) / (double)ncoords;
            }
            CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder();
            builder.name = name;
            builder.units = units;
            builder.description = description;
            builder.dataType = dataType;
            builder.axisType = axisType;
            builder.attributes = atts;
            builder.dependenceType = dependenceType;
            builder.setDependsOn(dependsOn);
            builder.spacing = spacing;
            builder.ncoords = ncoords;
            builder.startValue = startValue;
            builder.endValue = endValue;
            builder.resolution = resolution;
            builder.values = values2;
            builder.reader = reader;
            builder.isSubset = false;
            if (axisType == AxisType.TimeOffset) {
                return Optional.of(new TimeOffsetAxis(builder));
            }
            return Optional.of(new CoverageCoordAxis1D(builder));
        }
        if (!(dtCoordAxis instanceof CoordinateAxis2D)) {
            throw new IllegalStateException("Dont know what to do with axis " + dtCoordAxis);
        }
        CoordinateAxis2D axis2D = (CoordinateAxis2D)dtCoordAxis;
        if (!dtCoordAxis.isInterval()) {
            spacing = CoverageCoordAxis.Spacing.irregularPoint;
            values = axis2D.getCoordValues();
        } else if (dtCoordAxis.isContiguous()) {
            spacing = CoverageCoordAxis.Spacing.contiguousInterval;
            bounds = axis2D.getCoordBoundsArray();
            if (bounds == null) {
                throw new IllegalStateException("No bounds array");
            }
            int[] shape = bounds.getShape();
            int count = 0;
            values = new double[ncoords + 1];
            for (int i = 0; i < shape[0]; ++i) {
                for (int j = 0; j < shape[1]; ++j) {
                    values[count++] = bounds.get(i, j, 0);
                }
            }
            values[count] = bounds.get(shape[0] - 1, shape[1] - 1, 1);
        } else {
            spacing = CoverageCoordAxis.Spacing.discontiguousInterval;
            bounds = axis2D.getCoordBoundsArray();
            if (bounds == null) {
                throw new IllegalStateException("No bounds array");
            }
            int[] shape = bounds.getShape();
            int count = 0;
            values = new double[2 * ncoords];
            for (int i = 0; i < shape[0]; ++i) {
                for (int j = 0; j < shape[1]; ++j) {
                    values[count++] = bounds.get(i, j, 0);
                    values[count++] = bounds.get(i, j, 1);
                }
            }
        }
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder();
        builder.name = name;
        builder.units = units;
        builder.description = description;
        builder.dataType = dataType;
        builder.axisType = axisType;
        builder.attributes = dtCoordAxis.getAttributeContainer();
        builder.dependenceType = dependenceType;
        builder.setDependsOn(dependsOn);
        builder.spacing = spacing;
        builder.ncoords = ncoords;
        builder.startValue = startValue;
        builder.endValue = endValue;
        builder.resolution = resolution;
        builder.values = values;
        builder.reader = reader;
        builder.isSubset = false;
        builder.shape = dtCoordAxis.getShape();
        if (axisType == AxisType.Time) {
            if (ftype == FeatureType.FMRC) {
                builder.setDependsOn(dtCoordAxis.getDimension(0).getFullName());
                return Optional.of(new TimeAxis2DFmrc(builder));
            }
            if (ftype == FeatureType.SWATH) {
                return Optional.of(new TimeAxis2DSwath(builder));
            }
        }
        if (axisType == AxisType.Lat || axisType == AxisType.Lon) {
            return Optional.of(new LatLonAxis2D(builder));
        }
        return Optional.empty("Dont know what to do with axis " + dtCoordAxis);
    }

    private DtCoverageAdapter(DtCoverageDataset proxy) {
        this.proxy = proxy;
    }

    @Override
    public void close() throws IOException {
        this.proxy.close();
    }

    @Override
    public String getLocation() {
        return this.proxy.getLocation();
    }

    @Override
    public GeoReferencedArray readData(Coverage coverage, SubsetParams params, boolean canonicalOrder) throws IOException, InvalidRangeException {
        DtCoverage grid = (DtCoverage)coverage.getUserObject();
        CoverageCoordSys orgCoordSys = coverage.getCoordSys();
        Optional<CoverageCoordSys> opt = orgCoordSys.subset(params);
        if (!opt.isPresent()) {
            throw new InvalidRangeException(opt.getErrorMessage());
        }
        CoverageCoordSys subsetCoordSys = opt.get();
        List<RangeIterator> rangeIters = subsetCoordSys.getRanges();
        ArrayList<Range> ranges = new ArrayList<Range>();
        boolean hasComposite = false;
        for (RangeIterator ri : rangeIters) {
            if (ri instanceof RangeComposite) {
                hasComposite = true;
                continue;
            }
            ranges.add((Range)ri);
        }
        if (!hasComposite) {
            Array data = grid.readDataSection(new Section(ranges), canonicalOrder);
            return new GeoReferencedArray(coverage.getName(), coverage.getDataType(), data, subsetCoordSys);
        }
        Array result = Array.factory(coverage.getDataType(), subsetCoordSys.getShape());
        if (debug) {
            System.out.printf(" read %s result shape=%s%n", coverage.getName(), Misc.showInts(result.getShape()));
        }
        int[] origin = new int[result.getRank()];
        ranges.add(null);
        int n = rangeIters.size();
        RangeComposite comp = (RangeComposite)rangeIters.get(n - 1);
        for (RangeIterator ri : comp.getRanges()) {
            ranges.set(n - 1, (Range)ri.setName(comp.getName()));
            Section want = new Section(ranges);
            if (debug) {
                System.out.printf("  composite read section=%s%n", want);
            }
            Array data = grid.readDataSection(want, canonicalOrder);
            Section dataSection = new Section(data.getShape());
            Section sectionInResult = dataSection.shiftOrigin(origin);
            if (debug) {
                System.out.printf("  sectionInResult=%s%n", sectionInResult);
            }
            IndexIterator resultIter = result.getRangeIterator(sectionInResult.getRanges());
            IndexIterator dataIter = data.getIndexIterator();
            while (dataIter.hasNext()) {
                resultIter.setDoubleNext(dataIter.getDoubleNext());
            }
            int n2 = n - 1;
            origin[n2] = origin[n2] + data.getShape()[n - 1];
        }
        return new GeoReferencedArray(coverage.getName(), coverage.getDataType(), result, subsetCoordSys);
    }

    @Override
    public double[] readCoordValues(CoverageCoordAxis coordAxis) throws IOException {
        CoordinateAxis dtCoordAxis = this.proxy.getNetcdfDataset().findCoordinateAxis(coordAxis.getName());
        if (dtCoordAxis == null) {
            throw new IllegalStateException("Cants find Coordinate Axis " + coordAxis.getName());
        }
        if (dtCoordAxis instanceof CoordinateAxis1D) {
            CoordinateAxis1D axis1D = (CoordinateAxis1D)dtCoordAxis;
            switch (coordAxis.getSpacing()) {
                case irregularPoint: {
                    return axis1D.getCoordValues();
                }
                case contiguousInterval: {
                    return axis1D.getCoordEdges();
                }
                case discontiguousInterval: {
                    int n = (int)dtCoordAxis.getSize();
                    double[] result = new double[2 * n];
                    double[] bounds1 = axis1D.getBound1();
                    double[] bounds2 = axis1D.getBound2();
                    int count = 0;
                    for (int i = 0; i < n; ++i) {
                        result[count++] = bounds1[i];
                        result[count++] = bounds2[i];
                    }
                    return result;
                }
            }
        }
        Array data = dtCoordAxis.read();
        double[] result = new double[(int)data.getSize()];
        int count = 0;
        while (data.hasNext()) {
            result[count++] = data.nextDouble();
        }
        return result;
    }
}

