/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import java.util.Formatter;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.util.Misc;

@Immutable
public class EnsCoordValue
implements Comparable<EnsCoordValue> {
    private final int code;
    private final int ensMember;

    public EnsCoordValue(int code, int ensMember) {
        this.code = code;
        this.ensMember = ensMember;
    }

    public int getCode() {
        return this.code;
    }

    public int getEnsMember() {
        return this.ensMember;
    }

    @Override
    public int compareTo(@Nonnull EnsCoordValue o) {
        int r = Misc.compare(this.code, o.code);
        if (r != 0) {
            return r;
        }
        return Misc.compare(this.ensMember, o.ensMember);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnsCoordValue that = (EnsCoordValue)o;
        return this.code == that.code && this.ensMember == that.ensMember;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.ensMember;
        return result += 31 * this.code;
    }

    public String toString() {
        try (Formatter out = new Formatter();){
            out.format("(%d %d)", this.code, this.ensMember);
            String string = out.toString();
            return string;
        }
    }
}

