/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.ClientIO;
import dods.dap.Float32PrimitiveVector;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class DFloat32
extends BaseType
implements ClientIO {
    private float val;

    public DFloat32() {
    }

    public DFloat32(String n) {
        super(n);
    }

    public final float getValue() {
        return this.val;
    }

    public final void setValue(float newVal) {
        this.val = newVal;
    }

    public PrimitiveVector newPrimitiveVector() {
        return new Float32PrimitiveVector(this);
    }

    public String getTypeName() {
        return "Float32";
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.println(" = " + this.val + ";");
        } else {
            os.print(this.val);
        }
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException {
        this.val = source.readFloat();
        if (statusUI != null) {
            statusUI.incrementByteCount(4);
        }
    }

    public void externalize(DataOutputStream sink) throws IOException {
        sink.writeFloat(this.val);
    }
}

