/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.util.CancelTask;

@Immutable
class ReduceReader
implements ProxyReader {
    private final Variable orgClient;
    private final List<Integer> dims;

    ReduceReader(Variable orgClient, List<Integer> dims) {
        this.orgClient = orgClient;
        this.dims = new ArrayList<Integer>(dims);
        Collections.sort(this.dims);
    }

    @Override
    public Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
        Array data = this.orgClient._read();
        for (int i = this.dims.size() - 1; i >= 0; --i) {
            data = data.reduce(this.dims.get(i));
        }
        return data;
    }

    @Override
    public Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        Section orgSection = new Section(section.getRanges());
        for (int dim : this.dims) {
            orgSection.insertRange(dim, Range.ONE);
        }
        Array data = this.orgClient._read(orgSection);
        for (int i = this.dims.size() - 1; i >= 0; --i) {
            data = data.reduce(this.dims.get(i));
        }
        return data;
    }
}

