/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.netcdf3;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.netcdf3.N3iospNew;
import ucar.nc2.internal.iosp.netcdf3.NetcdfFileFormat;
import ucar.unidata.io.RandomAccessFile;

public class N3headerNew {
    private static Logger log = LoggerFactory.getLogger(N3headerNew.class);
    private static final byte[] MAGIC = new byte[]{67, 68, 70, 1};
    private static final int MAGIC_DIM = 10;
    private static final int MAGIC_VAR = 11;
    private static final int MAGIC_ATT = 12;
    public static boolean disallowFileTruncation;
    public static boolean debugHeaderSize;
    RandomAccessFile raf;
    private boolean isStreaming;
    int numrecs;
    long recsize;
    long recStart = Integer.MAX_VALUE;
    private boolean useLongOffset;
    private long nonRecordDataSize;
    private Dimension udim;
    private List<Vinfo> vars = new ArrayList<Vinfo>();
    private long dataStart = Long.MAX_VALUE;
    private final Charset valueCharset;

    public static boolean isValidFile(RandomAccessFile raf) throws IOException {
        switch (NetcdfFileFormat.findNetcdfFormatType(raf)) {
            case CLASSIC: 
            case OFFSET_64BIT: {
                return true;
            }
        }
        return false;
    }

    public N3headerNew() {
        this.valueCharset = StandardCharsets.UTF_8;
    }

    protected N3headerNew(N3iospNew n3iospNew) {
        this.valueCharset = n3iospNew.getValueCharset().orElse(StandardCharsets.UTF_8);
    }

    protected Charset getValueCharset() {
        return this.valueCharset;
    }

    void read(RandomAccessFile raf, Group.Builder root, Formatter debugOut) throws IOException {
        long calcSize;
        this.raf = raf;
        long actualSize = raf.length();
        this.nonRecordDataSize = 0L;
        this.recsize = 0L;
        this.recStart = Integer.MAX_VALUE;
        long pos = 0L;
        raf.order(this.getByteOrder());
        raf.seek(pos);
        byte[] b = new byte[4];
        raf.readFully(b);
        if (!this.isMagicBytes(b)) {
            throw new IOException("Not a netCDF file " + raf.getLocation());
        }
        if (b[3] != 1 && b[3] != 2) {
            throw new IOException("Not a netCDF file " + raf.getLocation());
        }
        this.useLongOffset = b[3] == 2;
        this.numrecs = raf.readInt();
        if (debugOut != null) {
            debugOut.format("numrecs= %d%n", this.numrecs);
        }
        if (this.numrecs == -1) {
            this.isStreaming = true;
            this.numrecs = 0;
        }
        int numdims = 0;
        int magic = raf.readInt();
        if (magic == 0) {
            raf.readInt();
        } else {
            if (magic != 10) {
                throw new IOException("Misformed netCDF file - dim magic number wrong " + raf.getLocation());
            }
            numdims = raf.readInt();
            if (debugOut != null) {
                debugOut.format("numdims= %d%n", numdims);
            }
        }
        ArrayList uvars = new ArrayList();
        ArrayList<Dimension> fileDimensions = new ArrayList<Dimension>();
        for (int i = 0; i < numdims; ++i) {
            Dimension dim;
            if (debugOut != null) {
                debugOut.format("  dim %d pos= %d%n", i, raf.getFilePointer());
            }
            String name = this.readString();
            int len = raf.readInt();
            if (len == 0) {
                this.udim = dim = Dimension.builder().setName(name).setIsUnlimited(true).setLength(this.numrecs).build();
            } else {
                dim = new Dimension(name, len);
            }
            fileDimensions.add(dim);
            root.addDimension(dim);
            if (debugOut == null) continue;
            debugOut.format(" added dimension %s%n", dim);
        }
        this.readAtts(root.getAttributeContainer(), debugOut);
        int nvars = 0;
        magic = raf.readInt();
        if (magic == 0) {
            raf.readInt();
        } else {
            if (magic != 11) {
                throw new IOException("Misformed netCDF file  - var magic number wrong " + raf.getLocation());
            }
            nvars = raf.readInt();
            if (debugOut != null) {
                debugOut.format("numdims= %d%n", numdims);
            }
        }
        if (debugOut != null) {
            debugOut.format("num variables= %d%n", nvars);
        }
        for (int i = 0; i < nvars; ++i) {
            long begin;
            String name = this.readString();
            Object var = Variable.builder().setName(name);
            long velems = 1L;
            boolean isRecord = false;
            int rank = raf.readInt();
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            for (int j = 0; j < rank; ++j) {
                int dimIndex = raf.readInt();
                Dimension dim = (Dimension)fileDimensions.get(dimIndex);
                if (dim.isUnlimited()) {
                    isRecord = true;
                    uvars.add(var);
                } else {
                    velems *= (long)dim.getLength();
                }
                dims.add(dim);
            }
            ((Variable.Builder)var).addDimensions(dims);
            if (debugOut != null) {
                debugOut.format("---name=<%s> dims = [", name);
                for (Dimension dim : dims) {
                    debugOut.format("%s ", dim.getShortName());
                }
                debugOut.format("]%n", new Object[0]);
            }
            long varAttsPos = raf.getFilePointer();
            this.readAtts(((Variable.Builder)var).getAttributeContainer(), debugOut);
            int type = raf.readInt();
            DataType dataType = N3headerNew.getDataType(type);
            ((Variable.Builder)var).setDataType(dataType);
            long vsize = raf.readInt();
            long l = begin = this.useLongOffset ? raf.readLong() : (long)raf.readInt();
            if (debugOut != null) {
                debugOut.format(" name= %s type=%d vsize=%s velems=%d begin= %d isRecord=%s attsPos=%d%n", name, type, vsize, velems, begin, isRecord, varAttsPos);
                long calcVsize = (velems + (long)N3headerNew.padding(velems)) * (long)dataType.getSize();
                if (vsize != calcVsize) {
                    debugOut.format(" *** readVsize %d != calcVsize %d%n", vsize, calcVsize);
                }
            }
            if (vsize < 0L) {
                vsize = (velems + (long)N3headerNew.padding(velems)) * (long)dataType.getSize();
            }
            Vinfo vinfo = new Vinfo(name, vsize, begin, isRecord, varAttsPos);
            this.vars.add(vinfo);
            ((Variable.Builder)var).setSPobject(vinfo);
            if (isRecord) {
                this.recsize += vsize;
                this.recStart = Math.min(this.recStart, begin);
            } else {
                this.nonRecordDataSize = Math.max(this.nonRecordDataSize, begin + vsize);
            }
            this.dataStart = Math.min(this.dataStart, begin);
            root.addVariable((Variable.Builder<?>)var);
        }
        pos = raf.getFilePointer();
        if (this.dataStart == Long.MAX_VALUE) {
            this.dataStart = pos;
        }
        if (this.nonRecordDataSize > 0L) {
            this.nonRecordDataSize -= this.dataStart;
        }
        if (uvars.isEmpty()) {
            this.recStart = 0L;
        }
        if (this.isStreaming) {
            long recordSpace = actualSize - this.recStart;
            int n = this.numrecs = this.recsize == 0L ? 0 : (int)(recordSpace / this.recsize);
            if (this.udim != null) {
                this.udim = this.udim.toBuilder().setLength(this.numrecs).build();
                root.replaceDimension(this.udim);
                uvars.forEach(v -> v.replaceDimension(this.udim));
            }
        }
        if (uvars.size() == 1) {
            Variable.Builder uvar = (Variable.Builder)uvars.get(0);
            DataType dtype = uvar.dataType;
            if (dtype == DataType.CHAR || dtype == DataType.BYTE || dtype == DataType.SHORT) {
                long vsize = dtype.getSize();
                List<Dimension> dims = uvar.copyDimensions();
                for (Dimension curDim : dims) {
                    if (curDim.isUnlimited()) continue;
                    vsize *= (long)curDim.getLength();
                }
                Vinfo vinfo = (Vinfo)uvar.spiObject;
                if (vsize != vinfo.vsize) {
                    log.info("Misformed netCDF file - file written with incorrect padding for record variable (CDM-52): fvsize=" + vinfo.vsize + "!= calc size =" + vsize);
                    this.recsize = vsize;
                    vinfo.vsize = vsize;
                }
            }
        }
        if (debugHeaderSize) {
            System.out.println("  filePointer = " + pos + " dataStart=" + this.dataStart);
            System.out.println("  recStart = " + this.recStart + " dataStart+nonRecordDataSize =" + (this.dataStart + this.nonRecordDataSize));
            System.out.println("  nonRecordDataSize size= " + this.nonRecordDataSize);
            System.out.println("  recsize= " + this.recsize);
            System.out.println("  numrecs= " + this.numrecs);
            System.out.println("  actualSize= " + actualSize);
        }
        if ((calcSize = this.dataStart + this.nonRecordDataSize + this.recsize * (long)this.numrecs) > actualSize + 3L) {
            if (disallowFileTruncation) {
                throw new IOException("File is truncated calculated size= " + calcSize + " actual = " + actualSize);
            }
            raf.setExtendMode();
        }
    }

    protected int getByteOrder() {
        return 0;
    }

    protected boolean isMagicBytes(byte[] bytes) {
        for (int i = 0; i < 3; ++i) {
            if (bytes[i] == MAGIC[i]) continue;
            return false;
        }
        return true;
    }

    long calcFileSize() {
        if (this.udim != null) {
            return this.recStart + this.recsize * (long)this.numrecs;
        }
        return this.dataStart + this.nonRecordDataSize;
    }

    void showDetail(Formatter out) throws IOException {
        long actual = this.raf.length();
        out.format("  raf length= %s %n", actual);
        out.format("  isStreaming= %s %n", this.isStreaming);
        out.format("  useLongOffset= %s %n", this.useLongOffset);
        out.format("  dataStart= %d%n", this.dataStart);
        out.format("  nonRecordData size= %d %n", this.nonRecordDataSize);
        out.format("  unlimited dimension = %s %n", this.udim);
        if (this.udim != null) {
            out.format("  record Data starts = %d %n", this.recStart);
            out.format("  recsize = %d %n", this.recsize);
            out.format("  numrecs = %d %n", this.numrecs);
        }
        long calcSize = this.calcFileSize();
        out.format("  computedSize = %d %n", calcSize);
        if (actual < calcSize) {
            out.format("  TRUNCATED!! actual size = %d (%d bytes) %n", actual, calcSize - actual);
        } else if (actual != calcSize) {
            out.format(" actual size larger = %d (%d byte extra) %n", actual, actual - calcSize);
        }
        out.format("%n  %20s____start_____size__unlim%n", "name");
        for (Vinfo vinfo : this.vars) {
            out.format("  %20s %8d %8d  %s %n", vinfo.name, vinfo.begin, vinfo.vsize, vinfo.isRecord);
        }
    }

    private int readAtts(AttributeContainer atts, Formatter fout) throws IOException {
        int natts = 0;
        int magic = this.raf.readInt();
        if (magic == 0) {
            this.raf.readInt();
        } else {
            if (magic != 12) {
                throw new IOException("Misformed netCDF file  - att magic number wrong");
            }
            natts = this.raf.readInt();
        }
        if (fout != null) {
            fout.format(" num atts= %d%n", natts);
        }
        for (int i = 0; i < natts; ++i) {
            Attribute att;
            if (fout != null) {
                fout.format("***att %d pos= %d%n", i, this.raf.getFilePointer());
            }
            String name = this.readString();
            int type = this.raf.readInt();
            if (type == 2) {
                String val;
                if (fout != null) {
                    fout.format(" begin read String val pos= %d%n", this.raf.getFilePointer());
                }
                if ((val = this.readString(this.getValueCharset())) == null) {
                    val = "";
                }
                if (fout != null) {
                    fout.format(" end read String val pos= %d%n", this.raf.getFilePointer());
                }
                att = new Attribute(name, val);
            } else {
                if (fout != null) {
                    fout.format(" begin read val pos= %d%n", this.raf.getFilePointer());
                }
                int nelems = this.raf.readInt();
                DataType dtype = N3headerNew.getDataType(type);
                Attribute.Builder builder = Attribute.builder(name).setDataType(dtype);
                if (nelems > 0) {
                    int[] shape = new int[]{nelems};
                    Array arr = Array.factory(dtype, shape);
                    IndexIterator ii = arr.getIndexIterator();
                    int nbytes = 0;
                    for (int j = 0; j < nelems; ++j) {
                        nbytes += this.readAttributeValue(dtype, ii);
                    }
                    builder.setValues(arr);
                    this.skip(nbytes);
                }
                att = builder.build();
                if (fout != null) {
                    fout.format(" end read val pos= %d%n", this.raf.getFilePointer());
                }
            }
            atts.addAttribute(att);
            if (fout == null) continue;
            fout.format("  %s%n", att);
        }
        return natts;
    }

    private int readAttributeValue(DataType type, IndexIterator ii) throws IOException {
        if (type == DataType.BYTE) {
            byte b = (byte)this.raf.read();
            ii.setByteNext(b);
            return 1;
        }
        if (type == DataType.CHAR) {
            char c = (char)this.raf.read();
            ii.setCharNext(c);
            return 1;
        }
        if (type == DataType.SHORT) {
            short s2 = this.raf.readShort();
            ii.setShortNext(s2);
            return 2;
        }
        if (type == DataType.INT) {
            int i = this.raf.readInt();
            ii.setIntNext(i);
            return 4;
        }
        if (type == DataType.FLOAT) {
            float f = this.raf.readFloat();
            ii.setFloatNext(f);
            return 4;
        }
        if (type == DataType.DOUBLE) {
            double d = this.raf.readDouble();
            ii.setDoubleNext(d);
            return 8;
        }
        return 0;
    }

    private String readString() throws IOException {
        return this.readString(StandardCharsets.UTF_8);
    }

    private String readString(Charset charset) throws IOException {
        int count;
        int nelems = this.raf.readInt();
        byte[] b = new byte[nelems];
        this.raf.readFully(b);
        this.skip(nelems);
        if (nelems == 0) {
            return null;
        }
        for (count = 0; count < nelems && b[count] != 0; ++count) {
        }
        return new String(b, 0, count, charset);
    }

    private void skip(int nbytes) throws IOException {
        int pad = N3headerNew.padding(nbytes);
        if (pad > 0) {
            this.raf.seek(this.raf.getFilePointer() + (long)pad);
        }
    }

    static int padding(int nbytes) {
        int pad = nbytes % 4;
        if (pad != 0) {
            pad = 4 - pad;
        }
        return pad;
    }

    static int padding(long nbytes) {
        int pad = (int)(nbytes % 4L);
        if (pad != 0) {
            pad = 4 - pad;
        }
        return pad;
    }

    static DataType getDataType(int type) {
        switch (type) {
            case 1: {
                return DataType.BYTE;
            }
            case 2: {
                return DataType.CHAR;
            }
            case 3: {
                return DataType.SHORT;
            }
            case 4: {
                return DataType.INT;
            }
            case 5: {
                return DataType.FLOAT;
            }
            case 6: {
                return DataType.DOUBLE;
            }
        }
        throw new IllegalArgumentException("unknown type == " + type);
    }

    static int getType(DataType dt) {
        if (dt == DataType.BYTE) {
            return 1;
        }
        if (dt == DataType.CHAR || dt == DataType.STRING) {
            return 2;
        }
        if (dt == DataType.SHORT) {
            return 3;
        }
        if (dt == DataType.INT) {
            return 4;
        }
        if (dt == DataType.FLOAT) {
            return 5;
        }
        if (dt == DataType.DOUBLE) {
            return 6;
        }
        throw new IllegalArgumentException("unknown DataType == " + (Object)((Object)dt));
    }

    static class Vinfo {
        String name;
        long vsize;
        long begin;
        boolean isRecord;
        long attsPos;

        Vinfo(String name, long vsize, long begin, boolean isRecord, long attsPos) {
            this.name = name;
            this.vsize = vsize;
            this.begin = begin;
            this.isRecord = isRecord;
            this.attsPos = attsPos;
        }
    }
}

