/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.io.DataInputStream;
import java.io.IOException;
import ucar.mcidas.AncillaryData;
import ucar.mcidas.CalibratorGvar;

public class CalibratorGvarG12
extends CalibratorGvar {
    protected static float[] imager12FK1 = new float[]{0.0f, 200960.0f, 43702.0f, 9685.9f, 5047.1f};
    protected static float[] sounder12FK1 = new float[]{3777.8f, 4008.6f, 4308.5f, 4704.1f, 5013.4f, 5864.5f, 6907.1f, 9038.8f, 12972.0f, 28931.0f, 34531.0f, 43340.0f, 124920.0f, 128220.0f, 135350.0f, 169810.0f, 189540.0f, 225380.0f};
    protected static float[] imager12FK2 = new float[]{0.0f, 3690.2f, 2219.1f, 1343.0f, 1080.7f};
    protected static float[] sounder12FK2 = new float[]{981.21f, 1000.8f, 1025.2f, 1055.6f, 1078.3f, 1136.1f, 1199.8f, 1312.4f, 1480.3f, 1934.0f, 2051.6f, 2213.0f, 3149.4f, 3176.9f, 3234.7f, 3488.8f, 3618.9f, 3834.0f};
    protected static float[] imager12TC1 = new float[]{0.0f, 0.69703f, 5.08315f, 0.37554f, 0.09537f};
    protected static float[] sounder12TC1 = new float[]{0.0101f, 0.01252f, 0.01229f, 0.01189f, 0.01264f, 0.04189f, 0.13474f, 0.12341f, 0.03844f, 0.15764f, 0.2742f, 0.13683f, 0.02124f, 0.0178f, 0.02037f, 0.04933f, 0.05386f, 0.28872f};
    protected static float[] imager12TC2 = new float[]{0.0f, 0.99902f, 0.98872f, 0.99872f, 0.9996f};
    protected static float[] sounder12TC2 = new float[]{0.99995f, 0.99994f, 0.99994f, 0.99995f, 0.99995f, 0.99983f, 0.99949f, 0.99957f, 0.99988f, 0.9996f, 0.99934f, 0.99969f, 0.99996f, 0.99997f, 0.99997f, 0.99993f, 0.99992f, 0.99961f};

    public CalibratorGvarG12(DataInputStream dis, AncillaryData ad, int[] cb) throws IOException {
        super(dis, ad, cb);
    }

    public CalibratorGvarG12(int sensorId, int[] cb) {
        super(sensorId, cb);
    }

    @Override
    public float radToTemp(float inVal, int band, int sId) {
        float outVal;
        if (sId % 2 == 0) {
            double expn = (double)(imager12FK1[band - 1] / inVal) + 1.0;
            double temp = (double)imager12FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)imager12TC1[band - 1]) / (double)imager12TC2[band - 1]);
        } else {
            double expn = (double)(sounder12FK1[band - 1] / inVal) + 1.0;
            double temp = (double)sounder12FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)sounder12TC1[band - 1]) / (double)sounder12TC2[band - 1]);
        }
        return outVal;
    }
}

