/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.io.DataInputStream;
import java.io.IOException;
import ucar.mcidas.AncillaryData;
import ucar.mcidas.CalibratorGvar;

public class CalibratorGvarG14
extends CalibratorGvar {
    protected static float[] imager14FK1 = new float[]{0.0f, 204320.0f, 42187.0f, 9721.1f, 5070.1f};
    protected static float[] sounder14FK1 = new float[]{3748.9f, 4008.3f, 4269.6f, 4695.2f, 4978.0f, 5807.4f, 6839.8f, 8972.5f, 13085.0f, 28920.0f, 34362.0f, 42901.0f, 125040.0f, 128340.0f, 135210.0f, 168900.0f, 189000.0f, 227200.0f};
    protected static float[] imager14FK2 = new float[]{0.0f, 3710.7f, 2192.9f, 1344.6f, 1082.3f};
    protected static float[] sounder14FK2 = new float[]{978.71f, 1000.8f, 1022.1f, 1055.0f, 1075.7f, 1132.4f, 1195.9f, 1309.2f, 1484.6f, 1933.8f, 2048.2f, 2205.5f, 3150.4f, 3177.9f, 3233.6f, 3482.5f, 3615.5f, 3844.3f};
    protected static float[] imager14TC1 = new float[]{0.0f, 1.56149f, 3.75637f, 0.3797f, 0.08482f};
    protected static float[] sounder14TC1 = new float[]{0.00949f, 0.01039f, 0.01018f, 0.01299f, 0.01335f, 0.04179f, 0.12271f, 0.11528f, 0.0387f, 0.14343f, 0.27532f, 0.18229f, 0.01783f, 0.01744f, 0.01906f, 0.05207f, 0.05324f, 0.2968f};
    protected static float[] imager14TC2 = new float[]{0.0f, 0.99783f, 0.99154f, 0.99869f, 0.99964f};
    protected static float[] sounder14TC2 = new float[]{0.99996f, 0.99995f, 0.99995f, 0.99994f, 0.99994f, 0.99983f, 0.99953f, 0.9996f, 0.99988f, 0.99964f, 0.99933f, 0.99958f, 0.99997f, 0.99997f, 0.99997f, 0.99992f, 0.99992f, 0.9996f};

    public CalibratorGvarG14(DataInputStream dis, AncillaryData ad, int[] cb) throws IOException {
        super(dis, ad, cb);
    }

    public CalibratorGvarG14(int sensorId, int[] cb) {
        super(sensorId, cb);
    }

    @Override
    public float radToTemp(float inVal, int band, int sId) {
        float outVal;
        if (sId % 2 == 0) {
            double expn = (double)(imager14FK1[band - 1] / inVal) + 1.0;
            double temp = (double)imager14FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)imager14TC1[band - 1]) / (double)imager14TC2[band - 1]);
        } else {
            double expn = (double)(sounder14FK1[band - 1] / inVal) + 1.0;
            double temp = (double)sounder14FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)sounder14TC1[band - 1]) / (double)sounder14TC2[band - 1]);
        }
        return outVal;
    }
}

