/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import ucar.mcidas.AREAnav;

public final class MSGTnav
extends AREAnav {
    private boolean isEastPositive = true;
    final double NOMORB = 42164.0;
    final double EARTH_RADIUS = 6378.155;
    int itype;
    double h;
    double a;
    double rp;
    double cdr;
    double crd;
    double rs;
    double yk;
    double deltax;
    double deltay;
    int LOFF;
    int COFF;
    int LFAC;
    int CFAC;
    int[] ioff = new int[3];
    boolean first = true;
    int count = 0;
    double sublon = 0.0;

    public MSGTnav(int[] iparms) throws IllegalArgumentException {
        if (iparms[0] != 1297303380) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.itype = 2;
        this.LOFF = iparms[1];
        this.COFF = iparms[2];
        this.LFAC = iparms[3];
        this.CFAC = iparms[4];
        this.sublon = (double)iparms[5] / 10000.0;
        if (this.isEastPositive) {
            this.sublon = -this.sublon;
        }
        this.h = 35785.845;
        this.rs = 6378.155 + this.h;
        this.yk = this.rs / 6378.155;
        this.a = 0.003367003367003367;
        this.rp = 6378.155 / (1.0 + this.a);
        this.crd = 57.29577951308232;
        this.cdr = Math.PI / 180;
        this.deltax = 1.0 / ((double)this.CFAC / 1000000.0);
        this.deltay = 1.0 / ((double)this.LFAC / 1000000.0);
    }

    @Override
    public double[][] toLatLon(double[][] linele) {
        double[][] imglinele;
        int number = linele[0].length;
        double[][] latlon = imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xlon;
            double xlat;
            double tany;
            double v2;
            if (Double.isNaN(imglinele[1][point]) || Double.isNaN(imglinele[0][point])) continue;
            double xlin = 11136.0 - imglinele[1][point] + 1.0;
            double xele = 11136.0 - imglinele[0][point] + 1.0;
            xlin = (xlin + 2.0) / 3.0;
            xele = (xele + 2.0) / 3.0;
            double xr = xele - (double)this.COFF / 10.0;
            double yr = xlin - (double)this.LOFF / 10.0;
            xr = xr * this.deltax * this.cdr;
            yr = yr * this.deltay * this.cdr;
            double tanx = Math.tan(xr);
            double v1 = 1.0 + tanx * tanx;
            if (v1 * (v2 = 1.0 + (tany = Math.tan(yr)) * tany * ((1.0 + this.a) * (1.0 + this.a))) > this.yk * this.yk / (this.yk * this.yk - 1.0)) {
                xlat = Double.NaN;
                xlon = Double.NaN;
            } else {
                double vmu = (this.rs - 6378.155 * Math.sqrt(this.yk * this.yk - (this.yk * this.yk - 1.0) * v1 * v2)) / (v1 * v2);
                double xt = this.rs - vmu;
                double yt = -vmu * tanx;
                double zt = vmu * tany / Math.cos(xr);
                double teta = Math.asin(zt / this.rp);
                xlat = Math.atan(Math.tan(teta) * 6378.155 / this.rp) * this.crd;
                xlon = Math.atan(yt / xt) * this.crd;
            }
            xlon += this.sublon;
            if (!this.isEastPositive) {
                xlon = -xlon;
            }
            latlon[0][point] = xlat;
            latlon[1][point] = xlon;
        }
        return latlon;
    }

    @Override
    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        if (this.first) {
            this.first = false;
        }
        for (int point = 0; point < number; ++point) {
            double xele;
            double xlin;
            double r2;
            if (Double.isNaN(latlon[0][point]) || Double.isNaN(latlon[1][point])) {
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            double xlat = latlon[0][point];
            double xlon = this.isEastPositive ? latlon[1][point] : -latlon[1][point];
            double xfi = xlat * this.cdr;
            double xla = (xlon -= this.sublon) * this.cdr;
            double rom = 6378.155 * this.rp / Math.sqrt(this.rp * this.rp * Math.cos(xfi) * Math.cos(xfi) + 4.0680861204025E7 * Math.sin(xfi) * Math.sin(xfi));
            double y = Math.sqrt(this.h * this.h + rom * rom - 2.0 * this.h * rom * Math.cos(xfi) * Math.cos(xla));
            double r1 = y * y + rom * rom;
            if (r1 > (r2 = this.h * this.h)) {
                xlin = Double.NaN;
                xele = Double.NaN;
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            double teta = Math.atan(this.rp / 6378.155 * Math.tan(xfi));
            double xt = 6378.155 * Math.cos(teta) * Math.cos(xla);
            double yt = 6378.155 * Math.cos(teta) * Math.sin(xla);
            double zt = this.rp * Math.sin(teta);
            double px = Math.atan(yt / (xt - this.rs));
            double py = Math.atan(-zt / (xt - this.rs) * Math.cos(px));
            double xr = (px *= this.crd) / this.deltax;
            double yr = (py *= this.crd) / this.deltay;
            xele = (double)this.COFF / 10.0 + xr;
            xlin = (double)this.LOFF / 10.0 + yr;
            xlin = xlin * 3.0 - 2.0;
            xele = xele * 3.0 - 2.0;
            linele[1][point] = 11136.0 - xlin + 1.0;
            linele[0][point] = 11136.0 - xele + 1.0;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public float[][] toLatLon(float[][] linele) {
        float[][] imglinele;
        int number = linele[0].length;
        float[][] latlon = imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xlon;
            double xlat;
            double tany;
            double v2;
            if (Float.isNaN(imglinele[1][point]) || Float.isNaN(imglinele[0][point])) continue;
            double xlin = 11136.0 - (double)imglinele[1][point] + 1.0;
            double xele = 11136.0 - (double)imglinele[0][point] + 1.0;
            xlin = (xlin + 2.0) / 3.0;
            xele = (xele + 2.0) / 3.0;
            double xr = xele - (double)this.COFF / 10.0;
            double yr = xlin - (double)this.LOFF / 10.0;
            xr = xr * this.deltax * this.cdr;
            yr = yr * this.deltay * this.cdr;
            double tanx = Math.tan(xr);
            double v1 = 1.0 + tanx * tanx;
            if (v1 * (v2 = 1.0 + (tany = Math.tan(yr)) * tany * ((1.0 + this.a) * (1.0 + this.a))) > this.yk * this.yk / (this.yk * this.yk - 1.0)) {
                xlat = Double.NaN;
                xlon = Double.NaN;
            } else {
                double vmu = (this.rs - 6378.155 * Math.sqrt(this.yk * this.yk - (this.yk * this.yk - 1.0) * v1 * v2)) / (v1 * v2);
                double xt = this.rs - vmu;
                double yt = -vmu * tanx;
                double zt = vmu * tany / Math.cos(xr);
                double teta = Math.asin(zt / this.rp);
                xlat = Math.atan(Math.tan(teta) * 6378.155 / this.rp) * this.crd;
                xlon = Math.atan(yt / xt) * this.crd;
            }
            xlon += this.sublon;
            if (!this.isEastPositive) {
                xlon = -xlon;
            }
            latlon[0][point] = (float)xlat;
            latlon[1][point] = (float)xlon;
        }
        return latlon;
    }

    @Override
    public float[][] toLinEle(float[][] latlon) {
        int number = latlon[0].length;
        float[][] linele = new float[2][number];
        if (this.first) {
            this.first = false;
        }
        for (int point = 0; point < number; ++point) {
            double xele;
            double xlin;
            double r2;
            if (Float.isNaN(latlon[0][point]) || Float.isNaN(latlon[1][point])) {
                linele[1][point] = Float.NaN;
                linele[0][point] = Float.NaN;
                continue;
            }
            double xlat = latlon[0][point];
            double xlon = this.isEastPositive ? (double)latlon[1][point] : (double)(-latlon[1][point]);
            double xfi = xlat * this.cdr;
            double xla = (xlon -= this.sublon) * this.cdr;
            double rom = 6378.155 * this.rp / Math.sqrt(this.rp * this.rp * Math.cos(xfi) * Math.cos(xfi) + 4.0680861204025E7 * Math.sin(xfi) * Math.sin(xfi));
            double y = Math.sqrt(this.h * this.h + rom * rom - 2.0 * this.h * rom * Math.cos(xfi) * Math.cos(xla));
            double r1 = y * y + rom * rom;
            if (r1 > (r2 = this.h * this.h)) {
                xlin = Double.NaN;
                xele = Double.NaN;
                linele[1][point] = Float.NaN;
                linele[0][point] = Float.NaN;
                continue;
            }
            double teta = Math.atan(this.rp / 6378.155 * Math.tan(xfi));
            double xt = 6378.155 * Math.cos(teta) * Math.cos(xla);
            double yt = 6378.155 * Math.cos(teta) * Math.sin(xla);
            double zt = this.rp * Math.sin(teta);
            double px = Math.atan(yt / (xt - this.rs));
            double py = Math.atan(-zt / (xt - this.rs) * Math.cos(px));
            double xr = (px *= this.crd) / this.deltax;
            double yr = (py *= this.crd) / this.deltay;
            xele = (double)this.COFF / 10.0 + xr;
            xlin = (double)this.LOFF / 10.0 + yr;
            xlin = xlin * 3.0 - 2.0;
            xele = xele * 3.0 - 2.0;
            linele[1][point] = (float)(11136.0 - xlin + 1.0);
            linele[0][point] = (float)(11136.0 - xele + 1.0);
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }
}

