/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.remote.CdmrFeatureDataset;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.ft2.coverage.adapter.DtCoverageAdapter;
import ucar.nc2.ft2.coverage.adapter.DtCoverageDataset;
import ucar.nc2.util.Optional;

public class CoverageDatasetFactory {
    public static final String NOT_GRIB_FILE = "Not a GRIB file";
    public static final String NO_GRIB_CLASS = "GRIB module not loaded";

    public static Optional<FeatureDatasetCoverage> openCoverageDataset(String endpoint) throws IOException {
        DtCoverageDataset gds;
        if (endpoint.startsWith("cdmrFeature:")) {
            Optional<FeatureDataset> opt = CdmrFeatureDataset.factory(FeatureType.COVERAGE, endpoint);
            return opt.isPresent() ? Optional.of((FeatureDatasetCoverage)opt.get()) : Optional.empty(opt.getErrorMessage());
        }
        DatasetUrl durl = DatasetUrl.findDatasetUrl(endpoint);
        if (durl.serviceType == null) {
            Optional<FeatureDatasetCoverage> opt = CoverageDatasetFactory.openGrib(endpoint);
            if (opt.isPresent()) {
                return opt;
            }
            if (opt.getErrorMessage() == null) {
                return Optional.empty("Unknown error opening grib coverage dataset");
            }
            if (!opt.getErrorMessage().startsWith(NOT_GRIB_FILE) && !opt.getErrorMessage().startsWith(NO_GRIB_CLASS)) {
                return opt;
            }
        }
        if (!(gds = DtCoverageDataset.open(durl)).getGrids().isEmpty()) {
            Formatter errlog = new Formatter();
            FeatureDatasetCoverage result = DtCoverageAdapter.factory(gds, errlog);
            if (result != null) {
                return Optional.of(result);
            }
            return Optional.empty(errlog.toString());
        }
        return Optional.empty("Could not open as Coverage: " + endpoint);
    }

    public static FeatureDatasetCoverage open(String endpoint) throws IOException {
        Optional<FeatureDatasetCoverage> opt = CoverageDatasetFactory.openCoverageDataset(endpoint);
        return opt.isPresent() ? opt.get() : null;
    }

    public static Optional<FeatureDatasetCoverage> openGrib(String endpoint) {
        List<Object> notGribThrowables = Arrays.asList(IllegalAccessException.class, IllegalArgumentException.class, ClassNotFoundException.class, NoSuchMethodException.class, NoSuchMethodError.class);
        try {
            Class<?> c = CoverageDatasetFactory.class.getClassLoader().loadClass("ucar.nc2.grib.coverage.GribCoverageDataset");
            Method method = c.getMethod("open", String.class);
            return (Optional)method.invoke(null, endpoint);
        }
        catch (Exception e) {
            for (Object noGrib : notGribThrowables) {
                boolean notGribBuried;
                boolean notGribTopLevel = e.getClass().equals(noGrib);
                boolean bl = notGribBuried = e.getClass().equals(InvocationTargetException.class) && e.getCause() != null && e.getCause().getClass().equals(noGrib);
                if (!notGribTopLevel && !notGribBuried) continue;
                return Optional.empty(NO_GRIB_CLASS);
            }
            return Optional.empty(e.getCause().getMessage());
        }
    }

    public static Optional<FeatureDatasetCoverage> openNcmlString(String ncml) throws IOException {
        NetcdfDataset ncd = NetcdfDatasets.openNcmlDataset(new StringReader(ncml), null, null);
        DtCoverageDataset gds = new DtCoverageDataset(ncd);
        if (!gds.getGrids().isEmpty()) {
            Formatter errlog = new Formatter();
            FeatureDatasetCoverage cc = DtCoverageAdapter.factory(gds, errlog);
            return Optional.of(cc);
        }
        return Optional.empty("Could not open NcML as Coverage");
    }
}

