/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import ucar.nc2.grib.grib2.table.Grib2CodeTableInterface;
import ucar.nc2.grib.grib2.table.Grib2TableConfig;

public class EccodesCodeTable
implements Grib2CodeTableInterface {
    public static final int LATEST_VERSION = 21;
    private static final boolean debugOpen = false;
    private static final boolean debug = false;
    private static final String PATH = "resources/grib2/ecmwf/tables";
    private String title;
    private String source;
    private String tableName;
    private final int version;
    private final int discipline;
    private final int category;
    private final ImmutableMap<Integer, Grib2CodeTableInterface.Entry> paramMap;

    public static EccodesCodeTable factory(int version, int discipline, int category) throws IOException {
        return new EccodesCodeTable(version, discipline, category);
    }

    private EccodesCodeTable(int version, int discipline, int category) throws IOException {
        this.version = version;
        this.discipline = discipline;
        this.category = category;
        this.paramMap = this.readTable(this.getTablePath());
    }

    @Override
    public String getName() {
        return String.format("Ecmwf version %d discipline %d category %d (%s)", this.version, this.discipline, this.category, this.getTablePath());
    }

    @Override
    public String getShortName() {
        return String.format("Ecmwf version %d (%d-%d)", this.version, this.discipline, this.category);
    }

    @Override
    public ImmutableList<Grib2CodeTableInterface.Entry> getEntries() {
        return this.paramMap.values().stream().sorted().collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nullable
    public Grib2CodeTableInterface.Entry getEntry(int code) {
        return this.paramMap.get(code);
    }

    private String getTablePath() {
        return String.format("%s/%d/%d.%d.table", PATH, this.version, this.discipline, this.category);
    }

    private ImmutableMap<Integer, Grib2CodeTableInterface.Entry> readTable(String path) throws IOException {
        ImmutableMap.Builder<Integer, EcmwfEntry> builder = ImmutableMap.builder();
        ClassLoader cl = Grib2TableConfig.class.getClassLoader();
        try (InputStream is = cl.getResourceAsStream(path);){
            if (is == null) {
                throw new IllegalStateException("Cant find " + path);
            }
            try (BufferedReader dataIS = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                int count = 0;
                while ((line = dataIS.readLine()) != null) {
                    String desc;
                    if (line.startsWith("#") || line.trim().isEmpty()) continue;
                    ++count;
                    int posBlank1 = line.indexOf(32);
                    int posBlank2 = line.indexOf(32, posBlank1 + 1);
                    int lastParen = line.lastIndexOf(40);
                    String num1 = line.substring(0, posBlank1).trim();
                    String num2 = line.substring(posBlank1 + 1, posBlank2);
                    String string = desc = lastParen > 0 ? line.substring(posBlank2 + 1, lastParen).trim() : line.substring(posBlank2 + 1).trim();
                    if (!num1.equals(num2)) continue;
                    int code = Integer.parseInt(num1);
                    EcmwfEntry entry = new EcmwfEntry(code, desc);
                    builder.put(entry.getCode(), entry);
                }
            }
        }
        return builder.build();
    }

    private static class EcmwfEntry
    implements Grib2CodeTableInterface.Entry,
    Comparable<Grib2CodeTableInterface.Entry> {
        private final int codeValue;
        private final String name;

        public EcmwfEntry(int codeValue, String name) {
            this.codeValue = codeValue;
            this.name = name;
        }

        @Override
        public int getCode() {
            return this.codeValue;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(Grib2CodeTableInterface.Entry o) {
            return this.codeValue - o.getCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("codeValue", this.codeValue).add("name", this.name).toString();
        }
    }
}

