/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.NetcdfRemoteProxy;
import ucar.netcdf.NetcdfRemoteProxyImpl;
import ucar.netcdf.NetcdfService;
import ucar.util.RMILogger;

public class NetcdfServer
extends UnicastRemoteObject
implements NetcdfService {
    private Hashtable byName_ = new Hashtable();
    private Registry registry_;
    static final RMILogger logger_ = new RMILogger();

    public static void setLog(OutputStream out) {
        if (out != null) {
            logger_.logUpTo(7);
            logger_.setLog(out);
        } else {
            logger_.logUpTo(5);
            logger_.setLog(System.err);
            UnicastRemoteObject.setLog(out);
        }
    }

    public NetcdfServer(String[] exports, Registry registry) throws RemoteException, AlreadyBoundException {
        for (int ii = 0; ii < exports.length; ++ii) {
            this.export(exports[ii]);
        }
        if (this.byName_.size() == 0) {
            throw new IllegalArgumentException("No exports");
        }
        if (registry != null) {
            this.registry_ = registry;
            registry.bind("NetcdfService", this);
            logger_.logNotice("NetcdfService bound in registry");
        }
    }

    public int ping() throws RemoteException {
        return 0;
    }

    public NetcdfRemoteProxy lookup(String dataSetName) throws RemoteException {
        Entry entry = this.get(dataSetName);
        if (entry == null) {
            throw new AccessException(dataSetName + " not available");
        }
        NetcdfFile nc = null;
        try {
            nc = entry.getNetcdfFile();
        }
        catch (IOException ioe) {
            throw new ServerException("lookup", ioe);
        }
        return (NetcdfRemoteProxy)((Object)NetcdfServer.exportObject(new NetcdfRemoteProxyImpl(this, dataSetName, nc)));
    }

    public String[] list() throws RemoteException {
        String[] ret = new String[this.byName_.size()];
        Enumeration ee = this.byName_.keys();
        int ii = 0;
        while (ee.hasMoreElements()) {
            ret[ii] = (String)ee.nextElement();
            ++ii;
        }
        return ret;
    }

    public void export(File ff) {
        if (!ff.isFile()) {
            throw new IllegalArgumentException(ff.getPath() + " not a File");
        }
        Entry entry = new Entry(ff);
        String keyval = entry.keyValue();
        logger_.logDebug("Exporting " + ff + " as " + keyval);
        this.put(keyval, entry);
    }

    public void export(String path) {
        this.export(new File(path));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.registry_ != null) {
            try {
                this.registry_.unbind("NetcdfService");
            }
            catch (Exception ee) {
                logger_.logError("unbind: " + ee.getMessage());
            }
        }
        this.registry_ = null;
    }

    public static Registry startRegistry() throws RemoteException {
        logger_.logNotice("No registry, starting one");
        return LocateRegistry.createRegistry(1099);
    }

    public static Registry checkRegistry(Registry regis, int tryagain) throws RemoteException {
        if (regis == null) {
            regis = NetcdfServer.startRegistry();
        }
        NetcdfService existing = null;
        try {
            existing = (NetcdfService)regis.lookup("NetcdfService");
        }
        catch (ConnectException ce) {
            if (--tryagain > 0) {
                return NetcdfServer.checkRegistry(NetcdfServer.startRegistry(), tryagain);
            }
            throw ce;
        }
        catch (NotBoundException nbe) {
            return regis;
        }
        try {
            existing.ping();
        }
        catch (ConnectException ce) {
            try {
                logger_.logNotice("unbinding dead registry entry");
                regis.unbind("NetcdfService");
            }
            catch (NotBoundException nbe) {
                // empty catch block
            }
        }
        return regis;
    }

    public static void main(String[] args) {
        PrintStream ps;
        System.setSecurityManager(new RMISecurityManager());
        Registry regis = null;
        try {
            regis = NetcdfServer.checkRegistry(LocateRegistry.getRegistry(), 2);
        }
        catch (Exception ee) {
            ps = NetcdfServer.getLog();
            if (ps == null) {
                ps = System.err;
            }
            ps.println("NetcdfServer: error getting registry: " + ee.getMessage());
            ee.printStackTrace(ps);
            System.exit(1);
        }
        try {
            NetcdfServer svc = new NetcdfServer(args, regis);
        }
        catch (Throwable ee) {
            ps = NetcdfServer.getLog();
            if (ps == null) {
                ps = System.err;
            }
            ps.println("NetcdfServer err: " + ee.getMessage());
            ee.printStackTrace(ps);
            System.exit(1);
        }
    }

    synchronized void _release(String keyval) {
        Entry entry = (Entry)this.byName_.get(keyval);
        if (entry != null) {
            entry.releaseNetcdfFile();
        }
    }

    private Entry get(String dataSetName) {
        return (Entry)this.byName_.get(dataSetName);
    }

    private synchronized void put(String keyval, Entry entry) {
        this.byName_.put(keyval, entry);
    }

    class Entry {
        final File dirent;
        NetcdfFile nc;
        int refcount;

        Entry(File ff) {
            this.dirent = ff;
            this.nc = null;
            this.refcount = 0;
        }

        String keyValue() {
            String name = this.dirent.getName();
            int index = name.indexOf(46);
            return name.substring(0, index).intern();
        }

        private synchronized void open(boolean readonly) throws IOException {
            if (this.nc != null) {
                throw new IllegalArgumentException("dataSet " + this.keyValue() + " already open");
            }
            this.nc = new NetcdfFile(this.dirent, readonly);
        }

        synchronized NetcdfFile getNetcdfFile() throws IOException {
            if (this.nc == null) {
                this.open(true);
            }
            ++this.refcount;
            logger_.logDebug("refcount: " + this.refcount);
            return this.nc;
        }

        private synchronized void close() {
            if (this.nc != null) {
                logger_.logDebug("closing: " + this.nc.getFile());
                try {
                    this.nc.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.nc = null;
                this.refcount = 0;
            }
        }

        synchronized void releaseNetcdfFile() {
            if (this.refcount > 0) {
                --this.refcount;
            }
            if (this.refcount == 0) {
                this.close();
            }
        }
    }
}

