/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import loci.formats.FormatException;
import loci.formats.ImageTools;
import loci.formats.LogTools;
import loci.formats.RandomAccessStream;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.Codec;

public class JPEGCodec
extends BaseCodec
implements Codec {
    public byte[] compress(byte[] data, int x, int y, int[] dims, Object options) throws FormatException {
        throw new FormatException("JPEG Compression not currently supported");
    }

    public byte[] decompress(byte[] input, Object options) throws FormatException {
        BufferedImage b;
        try {
            RandomAccessStream s2 = new RandomAccessStream(input);
            while (s2.read() != -1 || s2.read() != -40) {
            }
            int offset = (int)s2.getFilePointer() - 2;
            b = ImageIO.read(new BufferedInputStream(new ByteArrayInputStream(input, offset, input.length - offset)));
        }
        catch (IOException exc) {
            LogTools.println("An I/O error occurred decompressing image. Stack dump follows:");
            LogTools.trace(exc);
            return null;
        }
        byte[][] buf = ImageTools.getBytes(b);
        byte[] rtn = new byte[buf.length * buf[0].length];
        if (buf.length == 1) {
            rtn = buf[0];
        } else {
            for (int i = 0; i < buf.length; ++i) {
                System.arraycopy(buf[i], 0, rtn, i * buf[0].length, buf[i].length);
            }
        }
        return rtn;
    }
}

