/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionManager;
import ucar.unidata.util.StringUtil2;

public class FeatureCollectionConfig {
    private static boolean regularizeDefault = false;
    private static Logger log = LoggerFactory.getLogger(FeatureCollectionConfig.class);
    public String name;
    public String spec;
    public String dateFormatMark;
    public String olderThan;
    public String recheckAfter;
    public String timePartition;
    public UpdateConfig tdmConfig = new UpdateConfig();
    public UpdateConfig updateConfig = new UpdateConfig();
    public ProtoConfig protoConfig = new ProtoConfig();
    public FmrcConfig fmrcConfig = new FmrcConfig();
    public PointConfig pointConfig = new PointConfig();
    public GribConfig gribConfig = new GribConfig();
    public Element innerNcml = null;
    public boolean useIndexOnly = false;
    private static Set<FmrcDatasetType> defaultFmrcDatasetTypes = Collections.unmodifiableSet(EnumSet.of(FmrcDatasetType.TwoD, FmrcDatasetType.Best, FmrcDatasetType.Files, FmrcDatasetType.Runs));
    private static Set<PointDatasetType> defaultPointDatasetTypes = Collections.unmodifiableSet(EnumSet.of(PointDatasetType.cdmrFeature, PointDatasetType.Files));
    private static Set<GribDatasetType> defaultGribDatasetTypes = Collections.unmodifiableSet(EnumSet.of(GribDatasetType.collection, GribDatasetType.Files));

    public static void setRegularizeDefault(boolean t) {
        regularizeDefault = t;
    }

    public static boolean getRegularizeDefault() {
        return regularizeDefault;
    }

    public FeatureCollectionConfig() {
    }

    public FeatureCollectionConfig(String name, String spec, String dateFormatMark, String olderThan, String recheckAfter, String timePartition, String useIndexOnlyS, Element innerNcml) {
        this.name = name;
        this.spec = spec;
        this.dateFormatMark = dateFormatMark;
        this.olderThan = olderThan;
        this.recheckAfter = recheckAfter;
        this.timePartition = timePartition;
        this.useIndexOnly = useIndexOnlyS != null && useIndexOnlyS.equalsIgnoreCase("true");
        this.innerNcml = innerNcml;
    }

    public String toString() {
        return "FeatureCollectionConfig{name='" + this.name + '\'' + ", spec='" + this.spec + '\'' + ", dateFormatMark='" + this.dateFormatMark + '\'' + ", olderThan='" + this.olderThan + '\'' + ", recheckAfter='" + this.recheckAfter + '\'' + ", timePartition=" + this.timePartition + ", updateConfig=" + this.updateConfig + ", tdmConfig=" + this.tdmConfig + ", protoConfig=" + this.protoConfig + ", fmrcConfig=" + this.fmrcConfig + ", pointConfig=" + this.pointConfig + ", hasInnerNcml=" + (this.innerNcml != null) + '}';
    }

    static /* synthetic */ boolean access$100() {
        return regularizeDefault;
    }

    static /* synthetic */ Set access$200() {
        return defaultFmrcDatasetTypes;
    }

    static /* synthetic */ Set access$300() {
        return defaultPointDatasetTypes;
    }

    static /* synthetic */ Set access$400() {
        return defaultGribDatasetTypes;
    }

    public static class GribConfig {
        public Set<GribDatasetType> datasets = FeatureCollectionConfig.access$400();
        public Map<Integer, Integer> gdsHash;
        protected boolean explicit = false;

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicit) {
                this.datasets = EnumSet.noneOf(GribDatasetType.class);
            }
            this.explicit = true;
            for (String type : types = StringUtil2.splitString(datasetTypes)) {
                try {
                    GribDatasetType fdt = GribDatasetType.valueOf(type);
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize GribDatasetType {}", (Object)type);
                }
            }
        }

        public void addGdsHash(String fromS, String toS) {
            if (this.gdsHash == null) {
                this.gdsHash = new HashMap<Integer, Integer>(5);
            }
            try {
                int from = Integer.parseInt(fromS);
                int to = Integer.parseInt(toS);
                this.gdsHash.put(from, to);
            }
            catch (Exception e) {
                log.warn("Failed  to parse as Integer = {} {}", (Object)fromS, (Object)toS);
            }
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("GribConfig: datasetTypes=%s", this.datasets);
            return f.toString();
        }
    }

    public static class PointConfig {
        public Set<PointDatasetType> datasets = FeatureCollectionConfig.access$300();
        protected boolean explicit = false;

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicit) {
                this.datasets = EnumSet.noneOf(PointDatasetType.class);
            }
            this.explicit = true;
            for (String type : types = StringUtil2.splitString(datasetTypes)) {
                try {
                    PointDatasetType fdt = PointDatasetType.valueOf(type);
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize PointDatasetType " + type);
                }
            }
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("PointConfig: datasetTypes=%s", this.datasets);
            return f.toString();
        }
    }

    public static class BestDataset {
        public String name;
        public double greaterThan;

        public BestDataset(String name, double greaterThan) {
            this.name = name;
            this.greaterThan = greaterThan;
        }
    }

    public static class FmrcConfig {
        public boolean regularize = FeatureCollectionConfig.access$100();
        public Set<FmrcDatasetType> datasets = FeatureCollectionConfig.access$200();
        private boolean explicit = false;
        private List<BestDataset> bestDatasets = null;

        public FmrcConfig() {
        }

        public FmrcConfig(String regularize) {
            this.regularize = regularize != null && regularize.equalsIgnoreCase("true");
        }

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicit) {
                this.datasets = EnumSet.noneOf(FmrcDatasetType.class);
            }
            this.explicit = true;
            for (String type : types = StringUtil2.splitString(datasetTypes)) {
                try {
                    FmrcDatasetType fdt = FmrcDatasetType.valueOf(type);
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize FmrcDatasetType " + type);
                }
            }
        }

        public void addBestDataset(String name, double greaterEqual) {
            if (this.bestDatasets == null) {
                this.bestDatasets = new ArrayList<BestDataset>(2);
            }
            this.bestDatasets.add(new BestDataset(name, greaterEqual));
        }

        public List<BestDataset> getBestDatasets() {
            return this.bestDatasets;
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("FmrcConfig: regularize=%s datasetTypes=%s", this.regularize, this.datasets);
            if (this.bestDatasets != null) {
                for (BestDataset bd : this.bestDatasets) {
                    f.format("best = (%s, %f) ", bd.name, bd.greaterThan);
                }
            }
            return f.toString();
        }
    }

    public static class ProtoConfig {
        public ProtoChoice choice = ProtoChoice.Penultimate;
        public String param = null;
        public String change = null;
        public Element outerNcml = null;
        public boolean cacheAll = true;

        public ProtoConfig() {
        }

        public ProtoConfig(String choice, String change, String param, Element ncml) {
            if (choice != null) {
                try {
                    this.choice = ProtoChoice.valueOf(choice);
                }
                catch (Exception e) {
                    log.warn("Dont recognize ProtoChoice " + choice);
                }
            }
            this.change = change;
            this.param = param;
            this.outerNcml = ncml;
        }

        public String toString() {
            return "ProtoConfig{choice=" + (Object)((Object)this.choice) + ", change='" + this.change + '\'' + ", param='" + this.param + '\'' + ", outerNcml='" + this.outerNcml + '\'' + ", cacheAll=" + this.cacheAll + '}';
        }
    }

    public static class UpdateConfig {
        public boolean startup;
        public String rescan = null;
        public boolean triggerOk;
        public CollectionManager.Force force = CollectionManager.Force.test;
        public String deleteAfter = null;

        public UpdateConfig() {
        }

        public UpdateConfig(String startup, String rescan, String trigger, String forceS, String deleteAfter) {
            this.rescan = rescan;
            this.deleteAfter = deleteAfter;
            if (startup != null) {
                this.startup = startup.equalsIgnoreCase("true");
            }
            if (forceS != null) {
                this.force = CollectionManager.Force.valueOf(forceS);
            }
            if (trigger != null) {
                this.triggerOk = trigger.equalsIgnoreCase("allow");
            }
        }

        public String toString() {
            return "UpdateConfig{startup=" + this.startup + ", force=" + (Object)((Object)this.force) + ", rescan='" + this.rescan + '\'' + ", triggerOk=" + this.triggerOk + ", deleteAfter=" + this.deleteAfter + '}';
        }
    }

    public static enum GribDatasetType {
        collection,
        Files;

    }

    public static enum PointDatasetType {
        cdmrFeature,
        Files;

    }

    public static enum FmrcDatasetType {
        TwoD,
        Best,
        Files,
        Runs,
        ConstantForecasts,
        ConstantOffsets;

    }

    public static enum ProtoChoice {
        First,
        Random,
        Latest,
        Penultimate,
        Run;

    }
}

