/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.Earth;

public class FlatEarth
extends AbstractCoordTransBuilder {
    @Override
    public String getTransformName() {
        return "flat_earth";
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    @Override
    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double lon0 = this.readAttributeDouble(ctv, "longitude_of_projection_origin", Double.NaN);
        double lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin", Double.NaN);
        double rot = this.readAttributeDouble(ctv, "rotationAngle", 0.0);
        double earth_radius = this.readAttributeDouble(ctv, "earth_radius", Earth.getRadius()) * 0.001;
        ucar.unidata.geoloc.projection.FlatEarth proj = new ucar.unidata.geoloc.projection.FlatEarth(lat0, lon0, rot, earth_radius);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

