/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.util.List;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.TableConfig;

public class CoordSysEvaluator {
    public static void findCoords(TableConfig nt, NetcdfDataset ds) {
        CoordinateSystem use = CoordSysEvaluator.findBestCoordinateSystem(ds);
        if (use == null) {
            CoordSysEvaluator.findCoords(nt, ds.getCoordinateAxes());
        } else {
            CoordSysEvaluator.findCoords(nt, use.getCoordinateAxes());
        }
    }

    public static void findCoords(TableConfig nt, List<CoordinateAxis> axes) {
        for (CoordinateAxis axis : axes) {
            if (axis.getAxisType() == AxisType.Lat) {
                nt.lat = axis.getShortName();
                continue;
            }
            if (axis.getAxisType() == AxisType.Lon) {
                nt.lon = axis.getShortName();
                continue;
            }
            if (axis.getAxisType() == AxisType.Time) {
                nt.time = axis.getShortName();
                continue;
            }
            if (axis.getAxisType() != AxisType.Height) continue;
            nt.elev = axis.getShortName();
        }
    }

    public static void findCoordWithDimension(TableConfig nt, NetcdfDataset ds, Dimension outer) {
        CoordinateSystem use = CoordSysEvaluator.findBestCoordinateSystem(ds);
        if (use == null) {
            return;
        }
        for (CoordinateAxis axis : use.getCoordinateAxes()) {
            if (!outer.equals(axis.getDimension(0))) continue;
            if (axis.getAxisType() == AxisType.Lat) {
                nt.lat = axis.getShortName();
                continue;
            }
            if (axis.getAxisType() == AxisType.Lon) {
                nt.lon = axis.getShortName();
                continue;
            }
            if (axis.getAxisType() == AxisType.Time) {
                nt.time = axis.getShortName();
                continue;
            }
            if (axis.getAxisType() != AxisType.Height) continue;
            nt.elev = axis.getShortName();
        }
    }

    public static String findCoordNameByType(NetcdfDataset ds, AxisType atype) {
        CoordinateAxis coordAxis = CoordSysEvaluator.findCoordByType(ds, atype);
        return coordAxis == null ? null : coordAxis.getFullName();
    }

    public static String findCoordShortNameByType(NetcdfDataset ds, AxisType atype) {
        CoordinateAxis coordAxis = CoordSysEvaluator.findCoordByType(ds, atype);
        return coordAxis == null ? null : coordAxis.getShortName();
    }

    public static CoordinateAxis findCoordByType(NetcdfDataset ds, AxisType atype) {
        CoordinateSystem use = CoordSysEvaluator.findBestCoordinateSystem(ds);
        if (use != null) {
            for (CoordinateAxis axis : use.getCoordinateAxes()) {
                if (axis.getAxisType() != atype) continue;
                return axis;
            }
        }
        for (CoordinateAxis axis : ds.getCoordinateAxes()) {
            if (axis.getAxisType() != atype) continue;
            return axis;
        }
        return null;
    }

    public static CoordinateAxis findCoordByType(NetcdfDataset ds, AxisType atype, Predicate p) {
        CoordinateSystem use = CoordSysEvaluator.findBestCoordinateSystem(ds);
        if (use == null) {
            return null;
        }
        for (CoordinateAxis axis : use.getCoordinateAxes()) {
            if (axis.getAxisType() != atype || !p.match(axis)) continue;
            return axis;
        }
        for (CoordinateAxis axis : ds.getCoordinateAxes()) {
            if (axis.getAxisType() != atype || !p.match(axis)) continue;
            return axis;
        }
        return null;
    }

    public static Dimension findDimensionByType(NetcdfDataset ds, AxisType atype) {
        CoordinateAxis axis = CoordSysEvaluator.findCoordByType(ds, atype);
        if (axis == null) {
            return null;
        }
        if (axis.isScalar()) {
            return null;
        }
        return axis.getDimension(0);
    }

    private static CoordinateSystem findBestCoordinateSystem(NetcdfDataset ds) {
        CoordinateSystem use = null;
        for (CoordinateSystem cs : ds.getCoordinateSystems()) {
            if (use == null) {
                use = cs;
                continue;
            }
            if (cs.getCoordinateAxes().size() <= use.getCoordinateAxes().size()) continue;
            use = cs;
        }
        return use;
    }

    public static interface Predicate {
        public boolean match(CoordinateAxis var1);
    }
}

