/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonRect;

public class WriterCFPointCollection {
    private static final String recordDimName = "record";
    private static final String latName = "latitude";
    private static final String lonName = "longitude";
    private static final String altName = "altitude";
    private static final String timeName = "time";
    private static final boolean debug = false;
    private NetcdfFileWriteable ncfile;
    private String title;
    private String altUnits;
    private Set<Dimension> dimSet = new HashSet<Dimension>(20);
    private Date minDate = null;
    private Date maxDate = null;
    private int recno = 0;
    private ArrayDouble.D1 timeArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 latArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 lonArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 altArray = new ArrayDouble.D1(1);
    private int[] origin = new int[1];
    private LatLonRect llbb = null;

    public WriterCFPointCollection(String fileOut, String title) throws IOException {
        this.ncfile = NetcdfFileWriteable.createNew(fileOut, false);
        this.ncfile.setFill(false);
        this.title = title;
    }

    public void setLength(long size) {
        this.ncfile.setLength(size);
    }

    public void writeHeader(List<VariableSimpleIF> vars, DateUnit timeUnit, String altUnits) throws IOException {
        this.altUnits = altUnits;
        this.ncfile.addGlobalAttribute("Conventions", "CF-1.6");
        this.ncfile.addGlobalAttribute("featureType", "point");
        this.ncfile.addGlobalAttribute("title", this.title);
        this.ncfile.addGlobalAttribute("desc", "Written by TDS/CDM Remote Feature subset service");
        this.ncfile.addGlobalAttribute("time_coverage_start", CalendarDateFormatter.toDateStringPresent());
        this.ncfile.addGlobalAttribute("time_coverage_end", CalendarDateFormatter.toDateStringPresent());
        this.ncfile.addGlobalAttribute("geospatial_lat_min", 0.0);
        this.ncfile.addGlobalAttribute("geospatial_lat_max", 0.0);
        this.ncfile.addGlobalAttribute("geospatial_lon_min", 0.0);
        this.ncfile.addGlobalAttribute("geospatial_lon_max", 0.0);
        this.createCoordinates(timeUnit);
        this.createDataVariables(vars);
        this.ncfile.create();
        if (!((Boolean)this.ncfile.sendIospMessage("AddRecordStructure")).booleanValue()) {
            throw new IllegalStateException("can't add record variable");
        }
    }

    private void createCoordinates(DateUnit timeUnit) throws IOException {
        this.ncfile.addUnlimitedDimension(recordDimName);
        Variable timeVar = this.ncfile.addVariable(timeName, DataType.DOUBLE, recordDimName);
        this.ncfile.addVariableAttribute(timeVar, new Attribute("units", timeUnit.getUnitsString()));
        this.ncfile.addVariableAttribute(timeVar, new Attribute("long_name", "time of measurement"));
        Variable v = this.ncfile.addVariable(latName, DataType.DOUBLE, recordDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("units", "degrees_north"));
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station latitude"));
        v = this.ncfile.addVariable(lonName, DataType.DOUBLE, recordDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("units", "degrees_east"));
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station longitude"));
        if (this.altUnits != null) {
            v = this.ncfile.addVariable(altName, DataType.DOUBLE, recordDimName);
            this.ncfile.addVariableAttribute(v, new Attribute("units", this.altUnits));
            this.ncfile.addVariableAttribute(v, new Attribute("long_name", altName));
        }
    }

    private void createDataVariables(List<VariableSimpleIF> dataVars) throws IOException {
        List<Dimension> dims;
        String coordNames = "time latitude longitude";
        if (this.altUnits != null) {
            coordNames = coordNames + " " + altName;
        }
        for (VariableSimpleIF var : dataVars) {
            dims = var.getDimensions();
            this.dimSet.addAll(dims);
        }
        for (Dimension d : this.dimSet) {
            if (d.isUnlimited()) continue;
            this.ncfile.addDimension(d.getName(), d.getLength(), d.isShared(), false, d.isVariableLength());
        }
        for (VariableSimpleIF oldVar : dataVars) {
            dims = oldVar.getDimensions();
            StringBuilder dimNames = new StringBuilder(recordDimName);
            for (Dimension d : dims) {
                if (d.isUnlimited()) continue;
                dimNames.append(" ").append(d.getName());
            }
            Variable newVar = this.ncfile.addVariable(oldVar.getShortName(), oldVar.getDataType(), dimNames.toString());
            List<Attribute> atts = oldVar.getAttributes();
            for (Attribute att : atts) {
                newVar.addAttribute(att);
            }
            newVar.addAttribute(new Attribute("coordinates", coordNames));
        }
    }

    public void writeRecord(PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(sobs.getObservationTime(), sobs.getObservationTimeAsDate(), sobs.getLocation(), sdata);
    }

    public void writeRecord(double timeCoordValue, Date obsDate, EarthLocation loc, StructureData sdata) throws IOException {
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        if (this.minDate == null || this.minDate.after(obsDate)) {
            this.minDate = obsDate;
        }
        if (this.maxDate == null || this.maxDate.before(obsDate)) {
            this.maxDate = obsDate;
        }
        this.timeArray.set(0, timeCoordValue);
        this.latArray.set(0, loc.getLatitude());
        this.lonArray.set(0, loc.getLongitude());
        if (this.altUnits != null) {
            this.altArray.set(0, loc.getAltitude());
        }
        this.trackBB(loc);
        this.origin[0] = this.recno;
        try {
            this.ncfile.write(recordDimName, this.origin, sArray);
            this.ncfile.write(timeName, this.origin, this.timeArray);
            this.ncfile.write(latName, this.origin, this.latArray);
            this.ncfile.write(lonName, this.origin, this.lonArray);
            if (this.altUnits != null) {
                this.ncfile.write(altName, this.origin, this.altArray);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        ++this.recno;
    }

    public void finish() throws IOException {
        this.ncfile.updateAttribute(null, new Attribute("geospatial_lat_min", this.llbb.getLowerLeftPoint().getLatitude()));
        this.ncfile.updateAttribute(null, new Attribute("geospatial_lat_max", this.llbb.getUpperRightPoint().getLatitude()));
        this.ncfile.updateAttribute(null, new Attribute("geospatial_lon_min", this.llbb.getLowerLeftPoint().getLongitude()));
        this.ncfile.updateAttribute(null, new Attribute("geospatial_lon_max", this.llbb.getUpperRightPoint().getLongitude()));
        if (this.minDate == null) {
            this.minDate = new Date();
        }
        if (this.maxDate == null) {
            this.maxDate = new Date();
        }
        this.ncfile.updateAttribute(null, new Attribute("time_coverage_start", CalendarDateFormatter.toDateTimeString(this.minDate)));
        this.ncfile.updateAttribute(null, new Attribute("time_coverage_end", CalendarDateFormatter.toDateTimeString(this.maxDate)));
        this.ncfile.close();
    }

    private void trackBB(EarthLocation loc) {
        if (this.llbb == null) {
            this.llbb = new LatLonRect(loc.getLatLon(), 0.001, 0.001);
            return;
        }
        this.llbb.extend(loc.getLatLon());
    }
}

