/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import java.util.Date;
import net.jcip.annotations.ThreadSafe;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateFormatter;

@ThreadSafe
public class CalendarDateFormatter {
    private static DateTimeFormatter isof = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZoneUTC();
    private static DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss'Z'").withZoneUTC();
    private static DateTimeFormatter df = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZoneUTC();

    public static String toDateTimeStringISO(CalendarDate cd) {
        return isof.print((ReadableInstant)cd.getDateTime());
    }

    public static String toDateTimeStringISO(Date d) {
        return isof.print((ReadableInstant)new DateTime((Object)d, DateTimeZone.UTC));
    }

    public static String toDateTimeString(CalendarDate cd) {
        return dtf.print((ReadableInstant)cd.getDateTime());
    }

    public static String toDateTimeStringPresent() {
        return dtf.print((ReadableInstant)new DateTime());
    }

    public static String toDateString(CalendarDate cd) {
        return df.print((ReadableInstant)cd.getDateTime());
    }

    public static String toDateStringPresent() {
        return df.print((ReadableInstant)new DateTime());
    }

    public static String toDateTimeString(Date date) {
        return CalendarDateFormatter.toDateTimeString(CalendarDate.of(date));
    }

    public static Date parseISODate(String iso) {
        DateFormatter df = new DateFormatter();
        return df.getISODate(iso);
    }

    public static void main(String[] arg) {
        CalendarDate cd = CalendarDate.present();
        System.out.printf("%s%n", cd);
        System.out.printf("%s%n", CalendarDateFormatter.toDateTimeStringISO(cd));
        System.out.printf("%s%n", CalendarDateFormatter.toDateTimeString(cd));
        System.out.printf("%s%n", CalendarDateFormatter.toDateString(cd));
        Date d = new Date();
        System.out.printf("%s%n", CalendarDateFormatter.toDateTimeString(d));
        DateFormatter df = new DateFormatter();
        System.out.printf("%s%n", df.toDateTimeString(d));
        System.out.printf("%s%n", df.toDateOnlyString(d));
    }
}

