/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.units.DateFormatter;

public class DateFromString {
    private static final Logger logger = LoggerFactory.getLogger(DateFromString.class);

    public static Date getDateUsingSimpleDateFormat(String dateString, String dateFormatString) {
        int smallestIndex = dateString.length();
        if (smallestIndex == 0) {
            return null;
        }
        for (int i = 0; i < 10; ++i) {
            int curIndex = dateString.indexOf(String.valueOf(i));
            if (curIndex == -1 || smallestIndex <= curIndex) continue;
            smallestIndex = curIndex;
        }
        return DateFromString.getDateUsingCompleteDateFormatWithOffset(dateString, dateFormatString, smallestIndex);
    }

    public static Date getDateUsingDemarkatedCount(String dateString, String dateFormatString, char demark) {
        int pos1 = dateFormatString.indexOf(demark);
        dateFormatString = dateFormatString.substring(pos1 + 1);
        return DateFromString.getDateUsingCompleteDateFormatWithOffset(dateString, dateFormatString, pos1);
    }

    public static Date getDateUsingDemarkatedMatch(String dateString, String dateFormatString, char demark) {
        int pos1 = dateFormatString.indexOf(demark);
        int pos2 = dateFormatString.indexOf(demark, pos1 + 1);
        if (pos1 < 0 || pos2 < 0) {
            logger.error("Must delineate Date between 2 '#' chars, dateFormatString = " + dateFormatString);
            return null;
        }
        String match = dateFormatString.substring(pos1 + 1, pos2);
        int pos3 = dateString.indexOf(match);
        if (pos3 < 0) {
            return null;
        }
        if (pos1 > 0) {
            dateFormatString = dateFormatString.substring(0, pos1);
            dateString = dateString.substring(pos3 - dateFormatString.length(), pos3);
        } else {
            dateFormatString = dateFormatString.substring(pos2 + 1);
            dateString = dateString.substring(pos3 + match.length());
        }
        return DateFromString.getDateUsingCompleteDateFormatWithOffset(dateString, dateFormatString, 0);
    }

    public static Double getHourUsingDemarkatedMatch(String hourString, String formatString, char demark) {
        int pos1 = formatString.indexOf(demark);
        int pos2 = formatString.indexOf(demark, pos1 + 1);
        if (pos1 < 0 || pos2 < 0) {
            return null;
        }
        String match = formatString.substring(pos1 + 1, pos2);
        int pos3 = hourString.indexOf(match);
        if (pos3 < 0) {
            return null;
        }
        if (pos1 > 0) {
            hourString = hourString.substring(pos3 - pos1, pos3);
        } else {
            int len = formatString.length() - pos2 - 1;
            int start = pos3 + match.length();
            hourString = hourString.substring(start, start + len);
        }
        return Double.valueOf(hourString);
    }

    public static Date getDateUsingCompleteDateFormat(String dateString, String dateFormatString) {
        return DateFromString.getDateUsingCompleteDateFormatWithOffset(dateString, dateFormatString, 0);
    }

    public static Date getDateUsingCompleteDateFormatWithOffset(String dateString, String dateFormatString, int startIndex) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            String s = dateString.substring(startIndex, startIndex + dateFormatString.length());
            Date result = dateFormat.parse(s);
            if (result == null) {
                throw new RuntimeException("SimpleDateFormat bad =" + dateFormatString + " working on =" + s);
            }
            return result;
        }
        catch (ParseException e) {
            throw new RuntimeException("SimpleDateFormat = " + dateFormatString + " fails on " + dateString + " ParseException:" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("SimpleDateFormat = " + dateFormatString + " fails on " + dateString + " IllegalArgumentException:" + e.getMessage());
        }
    }

    public static Date getDateUsingRegExp(String dateString, String matchPattern, String substitutionPattern) {
        String dateFormatString = "yyyy-MM-dd'T'HH:mm";
        return DateFromString.getDateUsingRegExpAndDateFormat(dateString, matchPattern, substitutionPattern, dateFormatString);
    }

    public static Date getDateUsingRegExpAndDateFormat(String dateString, String matchPattern, String substitutionPattern, String dateFormatString) {
        Pattern pattern = Pattern.compile(matchPattern);
        Matcher matcher = pattern.matcher(dateString);
        if (!matcher.matches()) {
            return null;
        }
        StringBuffer dateStringFormatted = new StringBuffer();
        matcher.appendReplacement(dateStringFormatted, substitutionPattern);
        if (dateStringFormatted.length() == 0) {
            return null;
        }
        return DateFromString.getDateUsingCompleteDateFormat(dateStringFormatted.toString(), dateFormatString);
    }

    public static void main(String[] args) throws ParseException {
        DateFormatter formatter = new DateFormatter();
        Date result = DateFromString.getDateUsingDemarkatedMatch("/data/anything/2006070611/wrfout_d01_2006-07-06_080000.nc", "#wrfout_d01_#yyyy-MM-dd_HHmm", '#');
        System.out.println(" 2006-07-06_080000 -> " + formatter.toDateTimeStringISO(result));
        result = DateFromString.getDateUsingDemarkatedMatch("C:\\data\\nomads\\gfs-hi\\gfs_3_20061129_0600", "#gfs_3_#yyyyMMdd_HH", '#');
        System.out.println(" 20061129_06 -> " + formatter.toDateTimeStringISO(result));
        System.out.println(new SimpleDateFormat("yyyyMMdd_HH").parse("20061129_06"));
        System.out.println(new SimpleDateFormat("yyyyMMdd_HH").parse("20061129_0600"));
    }
}

