/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import ucar.nc2.util.log.LogStream;

public class EasyX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    public static Logger logger = LogStream.getLog();

    public EasyX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        if (logger == null) {
            logger = LogStream.getLog();
        }
        TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null && logger.isDebugEnabled()) {
            logger.debug("Server certificate chain:");
            for (int i = 0; i < certificates.length; ++i) {
                logger.debug("X509Certificate[" + i + "]=" + certificates[i]);
            }
        }
        if (certificates != null && certificates.length == 1) {
            X509Certificate x509Certificate = certificates[0];
        } else {
            this.standardTrustManager.checkServerTrusted(certificates, authType);
        }
    }
}

