/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import ucar.nc2.util.log.LogStream;
import ucar.nc2.util.net.HTTPAuthScheme;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPSSLProvider;

class HTTPAuthStore
implements Serializable {
    public static final boolean SCHEME = true;
    public static final String ANY_URL = "";
    public static final HTTPAuthScheme ANY_SCHEME = HTTPAuthScheme.ANY;
    public static final Entry ANY_ENTRY = new Entry(ANY_SCHEME, "", null);
    private static List<Entry> rows = new ArrayList<Entry>();
    static int nwriters;
    static int nreaders;
    static boolean stop;

    HTTPAuthStore() {
    }

    protected static boolean compatibleURL(String u1, String u2) {
        URI uu2;
        URI uu1;
        if (u1 == u2) {
            return true;
        }
        if (u1 == null) {
            return false;
        }
        if (u2 == null) {
            return false;
        }
        if (u1.equals(u2) || u1.startsWith(u2) || u2.startsWith(u1)) {
            return true;
        }
        try {
            uu1 = new URI(u1);
        }
        catch (URISyntaxException use) {
            return false;
        }
        try {
            uu2 = new URI(u2);
        }
        catch (URISyntaxException use) {
            return false;
        }
        String s1 = uu1.getSchemeSpecificPart();
        String s2 = uu2.getSchemeSpecificPart();
        if (s1 == null || s2 == null || !s1.equals(s2)) {
            return false;
        }
        s1 = uu1.getUserInfo();
        s2 = uu2.getUserInfo();
        if (!(s1 == null || s1 != null && s2 != null && s1.equals(s2))) {
            return false;
        }
        s1 = uu1.getHost();
        s2 = uu2.getHost();
        if (s1 == null || s2 == null || !s1.equals(s2)) {
            return false;
        }
        if (uu1.getPort() != uu2.getPort()) {
            return false;
        }
        s1 = uu1.getRawPath();
        s2 = uu2.getPath();
        return s1 == null || s2 == null || s1.startsWith(s2) || s2.startsWith(s1);
    }

    public static synchronized boolean insert(Entry entry) throws HTTPException {
        boolean rval = false;
        Entry found = null;
        if (entry == null || !entry.valid()) {
            throw new HTTPException("HTTPAuthStore.insert: invalid entry: " + entry);
        }
        for (Entry e : rows) {
            if (!Entry.identical(e, entry)) continue;
            found = e;
            break;
        }
        if (found != null) {
            found.creds = entry.creds;
            rval = true;
        } else {
            Entry newentry = new Entry(entry);
            rows.add(newentry);
        }
        return rval;
    }

    public static synchronized boolean remove(Entry entry) throws HTTPException {
        Entry found = null;
        if (entry == null || !entry.valid()) {
            throw new HTTPException("HTTPAuthStore.remove: invalid entry: " + entry);
        }
        for (Entry e : rows) {
            if (!Entry.identical(e, entry)) continue;
            found = e;
            break;
        }
        if (found != null) {
            rows.remove(found);
        }
        return found != null;
    }

    public static synchronized void clear() throws HTTPException {
        rows.clear();
    }

    public static List<Entry> getAllRows() {
        return rows;
    }

    public static synchronized Entry[] search(Entry entry) {
        if (entry == null || !entry.valid() || rows.size() == 0) {
            return new Entry[0];
        }
        ArrayList<Entry> matches = new ArrayList<Entry>();
        for (Entry e : rows) {
            Entry e1 = e;
            if (!Entry.matches(entry, e1)) continue;
            matches.add(e);
        }
        Object[] matchvec = matches.toArray(new Entry[matches.size()]);
        Arrays.sort(matchvec);
        return matchvec;
    }

    public static AuthScope getAuthScope(Entry entry) {
        String scheme;
        URI uri;
        if (entry == null) {
            return null;
        }
        try {
            uri = new URI(entry.url);
        }
        catch (URISyntaxException use) {
            return null;
        }
        String host = uri.getHost();
        int port = uri.getPort();
        String realm = uri.getRawPath();
        String string = scheme = entry.scheme == null ? null : entry.scheme.getSchemeName();
        if (host == null) {
            host = AuthScope.ANY_HOST;
        }
        if (port <= 0) {
            port = -1;
        }
        if (realm == null) {
            realm = AuthScope.ANY_REALM;
        }
        AuthScope as = new AuthScope(host, port, realm);
        return as;
    }

    private void acquirewriteaccess() throws HTTPException {
        ++nwriters;
        while (nwriters > 1) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (!stop) continue;
                throw new HTTPException("interrupted");
            }
        }
        while (nreaders > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (!stop) continue;
                throw new HTTPException("interrupted");
            }
        }
    }

    private void releasewriteaccess() {
        --nwriters;
        this.notify();
    }

    private void acquirereadaccess() throws HTTPException {
        ++nreaders;
        while (nwriters > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (!stop) continue;
                throw new HTTPException("interrupted");
            }
        }
    }

    private void releasereadaccess() {
        if (--nreaders == 0) {
            this.notify();
        }
    }

    public static void print(PrintStream p) throws IOException {
        HTTPAuthStore.print(new PrintWriter(p, true));
    }

    public static void print(PrintWriter p) throws IOException {
        List<Entry> elist = HTTPAuthStore.getAllRows();
        for (int i = 0; i < elist.size(); ++i) {
            Entry e = elist.get(i);
            p.printf("[%02d] %s\n", e.toString());
        }
    }

    public static void serialize(OutputStream ostream, String password) throws HTTPException {
        try {
            byte[] key = password.getBytes();
            DESKeySpec desKeySpec = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            Cipher desCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            desCipher.init(1, secretKey);
            BufferedOutputStream bos = new BufferedOutputStream(ostream);
            CipherOutputStream cos = new CipherOutputStream(bos, desCipher);
            ObjectOutputStream oos = new ObjectOutputStream(cos);
            oos.writeInt(HTTPAuthStore.getAllRows().size());
            for (Entry e : rows) {
                oos.writeObject(e);
            }
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            throw new HTTPException(e);
        }
    }

    public static void deserialize(InputStream istream, String password) throws HTTPException {
        List<Entry> entries = HTTPAuthStore.getDeserializedEntries(istream, password);
        for (Entry e : entries) {
            HTTPAuthStore.insert(e);
        }
    }

    public static List<Entry> getDeserializedEntries(InputStream istream, String password) throws HTTPException {
        try {
            byte[] key = password.getBytes();
            DESKeySpec desKeySpec = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            Cipher desCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            desCipher.init(2, secretKey);
            BufferedInputStream bis = new BufferedInputStream(istream);
            CipherInputStream cis = new CipherInputStream(bis, desCipher);
            ObjectInputStream ois = new ObjectInputStream(cis);
            ArrayList<Entry> entries = new ArrayList<Entry>();
            int count = ois.readInt();
            for (int i = 0; i < count; ++i) {
                Entry e = (Entry)ois.readObject();
                entries.add(e);
            }
            return entries;
        }
        catch (Exception e) {
            throw new HTTPException(e);
        }
    }

    static {
        String kpath = System.getProperty("keystore");
        if (kpath != null) {
            String tpath = System.getProperty("truststore");
            String kpwd = System.getProperty("keystorepassword");
            String tpwd = System.getProperty("truststorepassword");
            kpath = kpath.trim();
            if (tpath != null) {
                tpath = tpath.trim();
            }
            if (kpwd != null) {
                kpwd = kpwd.trim();
            }
            if (tpwd != null) {
                tpwd = tpwd.trim();
            }
            if (kpath.length() == 0) {
                kpath = null;
            }
            if (tpath.length() == 0) {
                tpath = null;
            }
            if (kpwd.length() == 0) {
                kpwd = null;
            }
            if (tpwd.length() == 0) {
                tpwd = null;
            }
            HTTPSSLProvider creds = new HTTPSSLProvider(kpath, kpwd, tpath, tpwd);
            try {
                HTTPAuthStore.insert(new Entry(HTTPAuthScheme.SSL, ANY_URL, creds));
            }
            catch (HTTPException he) {
                LogStream.err.println("HTTPAuthStore: could not insert default SSL data");
            }
        }
        nwriters = 0;
        nreaders = 0;
        stop = false;
    }

    public static class Entry
    implements Serializable,
    Comparable {
        public HTTPAuthScheme scheme;
        public String url;
        public CredentialsProvider creds;

        public Entry() {
            this(ANY_ENTRY);
        }

        public Entry(Entry entry) {
            if (entry == null) {
                entry = ANY_ENTRY;
            }
            this.constructor(entry.scheme, entry.url, entry.creds);
        }

        public Entry(HTTPAuthScheme scheme, String uri, CredentialsProvider creds) {
            this.constructor(scheme, uri, creds);
        }

        protected void constructor(HTTPAuthScheme scheme, String uri, CredentialsProvider creds) {
            if (uri == null) {
                uri = HTTPAuthStore.ANY_URL;
            }
            if (scheme == null) {
                scheme = ANY_SCHEME;
            }
            this.scheme = scheme;
            this.url = uri;
            this.creds = creds;
        }

        public boolean valid() {
            return this.scheme != null && this.url != null;
        }

        public String toString() {
            String creds = this.creds == null ? "null" : this.creds.toString();
            return String.format("%s:%s{%s}", new Object[]{this.scheme, this.url, creds});
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject((Object)this.scheme);
            oos.writeObject(this.url);
            boolean isser = this.creds instanceof Serializable;
            oos.writeObject(isser);
            if (isser) {
                oos.writeObject(this.creds);
            } else {
                oos.writeObject(this.creds.getClass());
            }
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.scheme = (HTTPAuthScheme)((Object)ois.readObject());
            this.url = (String)ois.readObject();
            boolean isser = (Boolean)ois.readObject();
            Object o = ois.readObject();
            if (isser) {
                this.creds = (CredentialsProvider)o;
            } else {
                try {
                    this.creds = (CredentialsProvider)((Class)o).newInstance();
                }
                catch (Exception e) {
                    throw new ClassNotFoundException("Cannot create CredentialsProvider instance", e);
                }
            }
        }

        public int compareTo(Object o1) {
            if (!(o1 instanceof Entry)) {
                return 1;
            }
            Entry e1 = this;
            Entry e2 = (Entry)o1;
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 != null && e2 == null) {
                return 1;
            }
            if (e1 == null && e2 != null) {
                return -1;
            }
            int cmp = e1.scheme.compareTo(e2.scheme);
            if (cmp != 0) {
                return cmp;
            }
            if (HTTPAuthStore.compatibleURL(e1.url, e2.url)) {
                return e2.url.compareTo(e1.url);
            }
            return e1.url.compareTo(e2.url);
        }

        public boolean equals(Entry e) {
            return this.compareTo(e) == 0;
        }

        protected static boolean matches(Entry e1, Entry e2) {
            if (e1 == null && e2 == null) {
                return true;
            }
            if (e1 != null && e2 == null) {
                return false;
            }
            if (e1 == null && e2 != null) {
                return false;
            }
            if (e1.scheme != ANY_SCHEME && e2.scheme != ANY_SCHEME && e1.scheme != e2.scheme) {
                return false;
            }
            return HTTPAuthStore.compatibleURL(e1.url, e2.url);
        }

        public static boolean identical(Entry e1, Entry e2) {
            return e1.scheme == e2.scheme && e1.url.equals(e2.url);
        }
    }
}

