/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.dt.TypedDatasetFactory;

public class RuntimeConfigParser {
    public static void read(InputStream is, StringBuilder errlog) throws IOException {
        Document doc;
        SAXBuilder saxBuilder = new SAXBuilder();
        try {
            doc = saxBuilder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        RuntimeConfigParser.read(doc.getRootElement(), errlog);
    }

    public static void read(Element root, StringBuilder errlog) {
        List children = root.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Method m;
            Class<?> c;
            Element elem = (Element)children.get(i);
            if (elem.getName().equals("ioServiceProvider")) {
                String className = elem.getAttributeValue("class");
                try {
                    NetcdfFile.registerIOProvider(className);
                }
                catch (ClassNotFoundException e) {
                    errlog.append("CoordSysBuilder class not found= " + className + "; check your classpath\n");
                }
                catch (Exception e) {
                    errlog.append("IOServiceProvider " + className + " failed= " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("coordSysBuilder")) {
                String conventionName = elem.getAttributeValue("convention");
                String className = elem.getAttributeValue("class");
                try {
                    CoordSysBuilder.registerConvention(conventionName, className);
                }
                catch (ClassNotFoundException e) {
                    errlog.append("CoordSysBuilder class not found= " + className + "; check your classpath\n");
                }
                catch (Exception e) {
                    errlog.append("CoordSysBuilder " + className + " failed= " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("coordTransBuilder")) {
                String transformName = elem.getAttributeValue("name");
                String className = elem.getAttributeValue("class");
                try {
                    CoordTransBuilder.registerTransform(transformName, className);
                }
                catch (ClassNotFoundException e) {
                    errlog.append("CoordSysBuilder class not found= " + className + "; check your classpath\n");
                }
                catch (Exception e) {
                    errlog.append("CoordTransBuilder " + className + " failed= " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("typedDatasetFactory")) {
                String typeName = elem.getAttributeValue("datatype");
                String className = elem.getAttributeValue("class");
                FeatureType datatype = FeatureType.valueOf(typeName.toUpperCase());
                if (null == datatype) {
                    errlog.append("TypedDatasetFactory " + className + " unknown datatype= " + typeName + "\n");
                    continue;
                }
                try {
                    TypedDatasetFactory.registerFactory(datatype, className);
                }
                catch (ClassNotFoundException e) {
                    errlog.append("CoordSysBuilder class not found= " + className + "; check your classpath\n");
                }
                catch (Exception e) {
                    errlog.append("TypedDatasetFactory " + className + " failed= " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("grib1Table")) {
                String strictS = elem.getAttributeValue("strict");
                if (strictS != null) {
                    boolean notStrict = strictS.equalsIgnoreCase("false");
                    try {
                        c = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.grib.grib1.GribPDSParamTable");
                        m = c.getMethod("setStrict", Boolean.TYPE);
                        m.invoke(null, !notStrict);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                String centerS = elem.getAttributeValue("center");
                String subcenterS = elem.getAttributeValue("subcenter");
                String versionS = elem.getAttributeValue("version");
                String filename = elem.getAttributeValue("filename");
                if (centerS == null || versionS == null || filename == null) {
                    errlog.append("table element must center, version and filename attributes\n");
                    continue;
                }
                try {
                    int center = Integer.parseInt(centerS);
                    int subcenter = subcenterS == null ? -1 : Integer.parseInt(subcenterS);
                    int version = Integer.parseInt(versionS);
                    Class<?> c2 = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.grib.grib1.GribPDSParamTable");
                    Method m2 = c2.getMethod("addParameterTable", Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class);
                    m2.invoke(null, center, subcenter, version, filename);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (elem.getName().equals("table")) {
                String type = elem.getAttributeValue("type");
                String filename = elem.getAttributeValue("filename");
                if (type == null || filename == null) {
                    errlog.append("table element must have both type and filename attributes\n");
                    continue;
                }
                try {
                    if (type.equalsIgnoreCase("GRIB1")) {
                        try {
                            c = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.grib.grib1.GribPDSParamTable");
                            m = c.getMethod("addParameterUserLookup", String.class);
                            m.invoke(null, filename);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (type.equalsIgnoreCase("GRIB2")) {
                        try {
                            c = RuntimeConfigParser.class.getClassLoader().loadClass(" ucar.grib.grib2.ParameterTable");
                            m = c.getMethod("addParametersUser", String.class);
                            m.invoke(null, filename);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    errlog.append("Unknown table type " + type + "\n");
                }
                catch (Exception e) {
                    errlog.append("table read failed on  " + filename + " = " + e.getMessage() + "\n");
                }
                continue;
            }
            if (!elem.getName().equals("bufrtable")) continue;
            String filename = elem.getAttributeValue("filename");
            if (filename == null) {
                errlog.append("bufrtable must have filename attribute\n");
                continue;
            }
            try {
                Class<?> bufrTablesClass = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.nc2.iosp.bufr.tables.BufrTables");
                Class[] params = new Class[]{String.class};
                Method method = bufrTablesClass.getMethod("addLookupFile", params);
                Object[] args = new Object[]{filename};
                method.invoke(null, args);
                continue;
            }
            catch (Throwable e) {
                if (e instanceof FileNotFoundException) {
                    errlog.append("bufrtable read failed on  " + filename + " = " + e.getMessage() + "\n");
                    continue;
                }
                errlog.append("bufr.jar is not on classpath\n");
            }
        }
    }
}

