/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.util.SpecialMathFunction;

public class Mercator
extends ProjectionImpl {
    private final double earthRadius;
    private final double lon0;
    private final double par;
    private final double falseEasting;
    private final double falseNorthing;
    private double par_r;
    private double A;

    public static double convertScaleToStandardParallel(double scale) {
        double par = Math.acos(1.0 / scale);
        return Math.toRadians(par);
    }

    @Override
    public ProjectionImpl constructCopy() {
        return new Mercator(this.getOriginLon(), this.getParallel(), this.getFalseEasting(), this.getFalseNorthing(), this.getEarthRadius());
    }

    public Mercator() {
        this(-105.0, 20.0, 0.0, 0.0, EARTH_RADIUS);
    }

    public Mercator(double lon0, double par) {
        this(lon0, par, 0.0, 0.0, EARTH_RADIUS);
    }

    public Mercator(double lon0, double par, double false_easting, double false_northing) {
        this(lon0, par, false_easting, false_northing, EARTH_RADIUS);
    }

    public Mercator(double lon0, double par, double false_easting, double false_northing, double radius) {
        super("Mercator", false);
        this.lon0 = lon0;
        this.par = par;
        this.falseEasting = false_easting;
        this.falseNorthing = false_northing;
        this.earthRadius = radius;
        this.par_r = Math.toRadians(par);
        this.precalculate();
        this.addParameter("grid_mapping_name", "mercator");
        this.addParameter("longitude_of_projection_origin", lon0);
        this.addParameter("standard_parallel", par);
        this.addParameter("earth_radius", this.earthRadius * 1000.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
    }

    private void precalculate() {
        this.A = this.earthRadius * Math.cos(this.par_r);
    }

    public double getParallel() {
        return this.par;
    }

    public double getOriginLon() {
        return this.lon0;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public double getEarthRadius() {
        return this.earthRadius;
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "Mercator{earthRadius=" + this.earthRadius + ", lon0=" + this.lon0 + ", par=" + this.par + ", falseEasting=" + this.falseEasting + ", falseNorthing=" + this.falseNorthing + '}';
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mercator mercator = (Mercator)o;
        if (Double.compare(mercator.earthRadius, this.earthRadius) != 0) {
            return false;
        }
        if (Double.compare(mercator.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        if (Double.compare(mercator.falseNorthing, this.falseNorthing) != 0) {
            return false;
        }
        if (Double.compare(mercator.lon0, this.lon0) != 0) {
            return false;
        }
        return Double.compare(mercator.par, this.par) == 0;
    }

    public int hashCode() {
        long temp = this.earthRadius != 0.0 ? Double.doubleToLongBits(this.earthRadius) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon0 != 0.0 ? Double.doubleToLongBits(this.lon0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.par != 0.0 ? Double.doubleToLongBits(this.par) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseEasting != 0.0 ? Double.doubleToLongBits(this.falseEasting) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseNorthing != 0.0 ? Double.doubleToLongBits(this.falseNorthing) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double toY;
        double toX;
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        double fromLat_r = Math.toRadians(fromLat);
        if (Math.abs(90.0 - Math.abs(fromLat)) < 1.0E-6) {
            toX = Double.POSITIVE_INFINITY;
            toY = Double.POSITIVE_INFINITY;
        } else {
            toX = this.A * Math.toRadians(LatLonPointImpl.range180(fromLon - this.lon0));
            toY = this.A * SpecialMathFunction.atanh(Math.sin(fromLat_r));
        }
        result.setLocation(toX + this.falseEasting, toY + this.falseNorthing);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = world.getX() - this.falseEasting;
        double fromY = world.getY() - this.falseNorthing;
        double toLon = Math.toDegrees(fromX / this.A) + this.lon0;
        double e = Math.exp(-fromY / this.A);
        double toLat = Math.toDegrees(1.5707963267948966 - 2.0 * Math.atan(e));
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }
}

