/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.EventObject;
import thredds.inventory.MFile;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.TimeDuration;

public interface CollectionManager {
    public String getCollectionName();

    public String getRoot();

    public long getLastScanned();

    public TimeDuration getRecheck();

    public boolean isScanNeeded();

    public boolean scanIfNeeded() throws IOException;

    public boolean scan() throws IOException;

    public Iterable<MFile> getFiles();

    public CalendarDate extractRunDate(MFile var1);

    public boolean hasDateExtractor();

    public CalendarDate getStartCollection();

    public void close();

    public int getProtoIndex(int var1);

    public double getOlderThanFilterInSecs();

    public void setChangeChecker(ChangeChecker var1);

    public Object getAuxInfo(String var1);

    public void putAuxInfo(String var1, Object var2);

    public void resetProto();

    public void addEventListener(TriggerListener var1);

    public void removeEventListener(TriggerListener var1);

    public static class TriggerEvent
    extends EventObject {
        private final TriggerType type;

        TriggerEvent(Object source, TriggerType type) {
            super(source);
            this.type = type;
        }

        public TriggerType getType() {
            return this.type;
        }

        @Override
        public String toString() {
            return "TriggerEvent{type='" + (Object)((Object)this.type) + '\'' + '}';
        }
    }

    public static enum TriggerType {
        update,
        proto;

    }

    public static interface TriggerListener {
        public void handleCollectionEvent(TriggerEvent var1);
    }

    public static interface ChangeChecker {
        public boolean hasChangedSince(MFile var1, long var2);
    }

    public static enum Force {
        always,
        test,
        nocheck;

    }
}

