/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.text.ParseException;
import java.util.Date;
import net.jcip.annotations.ThreadSafe;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionManager;
import thredds.inventory.FeatureCollectionConfig;

@ThreadSafe
public enum CollectionUpdater {
    INSTANCE;

    private static final Logger logger;
    private static final String FC_NAME = "fc";
    private static final long startupWait = 30000L;
    private static boolean disabled;
    private Scheduler scheduler = null;
    private boolean failed = false;

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTasks(FROM from, FeatureCollectionConfig config, CollectionManager manager) {
        if (disabled || this.failed) {
            return;
        }
        FeatureCollectionConfig.UpdateConfig useConfig = null;
        if (from == FROM.tds) {
            useConfig = config.updateConfig;
            if (!useConfig.startup && useConfig.rescan == null && config.protoConfig.change == null) {
                return;
            }
        } else if (from == FROM.tdm) {
            useConfig = config.tdmConfig;
            if (!useConfig.startup && useConfig.rescan == null && config.protoConfig.change == null) {
                return;
            }
        }
        CollectionUpdater collectionUpdater = this;
        synchronized (collectionUpdater) {
            if (!this.failed && this.scheduler == null) {
                StdSchedulerFactory schedFact = new StdSchedulerFactory();
                try {
                    this.scheduler = schedFact.getScheduler();
                    this.scheduler.start();
                }
                catch (SchedulerException e) {
                    this.failed = true;
                    throw new RuntimeException("quartz scheduler failed to initialize", e);
                }
            }
        }
        JobDetail updateJob = new JobDetail(config.name, "UpdateCollection", UpdateCollectionJob.class);
        JobDataMap map = new JobDataMap();
        map.put((Object)FC_NAME, (Object)manager);
        updateJob.setJobDataMap(map);
        if (useConfig.startup) {
            Date runTime = new Date(new Date().getTime() + 30000L);
            SimpleTrigger trigger0 = new SimpleTrigger(config.name, "startup", runTime);
            try {
                this.scheduler.scheduleJob(updateJob, (Trigger)trigger0);
                logger.info("Schedule startup scan for {} at {}\n", (Object)config, (Object)runTime);
            }
            catch (SchedulerException e) {
                logger.error("cronExecutor failed to schedule startup Job for " + config, (Throwable)e);
                return;
            }
        }
        if (useConfig.rescan != null) {
            try {
                CronTrigger trigger1 = new CronTrigger(config.spec, "rescan", useConfig.rescan);
                if (useConfig.startup) {
                    trigger1.setJobName(updateJob.getName());
                    trigger1.setJobGroup(updateJob.getGroup());
                    this.scheduler.scheduleJob((Trigger)trigger1);
                } else {
                    this.scheduler.scheduleJob(updateJob, (Trigger)trigger1);
                }
                logger.info("Schedule recurring scan for {} cronExpr={}", (Object)config.spec, (Object)useConfig.rescan);
            }
            catch (ParseException e) {
                logger.error("cronExecutor failed: bad cron expression= " + useConfig.rescan, (Throwable)e);
            }
            catch (SchedulerException e) {
                logger.error("cronExecutor failed to schedule cron Job", (Throwable)e);
            }
        }
        FeatureCollectionConfig.ProtoConfig pconfig = config.protoConfig;
        if (pconfig.change != null) {
            JobDetail protoJob = new JobDetail(config.name, "UpdateProto", ChangeProtoJob.class);
            JobDataMap pmap = new JobDataMap();
            pmap.put((Object)FC_NAME, (Object)manager);
            protoJob.setJobDataMap(pmap);
            try {
                CronTrigger trigger2 = new CronTrigger(config.name, "rereadProto", pconfig.change);
                this.scheduler.scheduleJob(protoJob, (Trigger)trigger2);
                logger.info("Schedule Reread Proto for {}", (Object)config.name);
            }
            catch (ParseException e) {
                logger.error("cronExecutor failed: RereadProto has bad cron expression= " + pconfig.change, (Throwable)e);
            }
            catch (SchedulerException e) {
                logger.error("cronExecutor failed to schedule RereadProtoJob", (Throwable)e);
            }
        }
    }

    public void shutdown() {
        if (this.scheduler == null) {
            return;
        }
        try {
            this.scheduler.shutdown(true);
            Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
            logServerStartup.info("Scheduler shutdown");
        }
        catch (SchedulerException e) {
            logger.error("Scheduler failed to shutdown", (Throwable)e);
            this.scheduler = null;
        }
    }

    static {
        logger = LoggerFactory.getLogger(CollectionUpdater.class);
        disabled = false;
    }

    public static class ChangeProtoJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            try {
                CollectionManager manager = (CollectionManager)context.getJobDetail().getJobDataMap().get((Object)CollectionUpdater.FC_NAME);
                logger.info("Update resetProto for {}", (Object)manager.getCollectionName());
                manager.resetProto();
            }
            catch (Throwable e) {
                logger.error("RereadProtoJob failed", e);
            }
        }
    }

    public static class UpdateCollectionJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            try {
                CollectionManager manager = (CollectionManager)context.getJobDetail().getJobDataMap().get((Object)CollectionUpdater.FC_NAME);
                logger.info("Update rescan for {}", (Object)manager.getCollectionName());
                manager.scan();
            }
            catch (Throwable e) {
                logger.error("InitFmrcJob failed", e);
            }
        }
    }

    public static enum FROM {
        tds,
        tdm;

    }
}

