/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.ControllerOS;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionManagerAbstract;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.DatasetCollectionFromCatalog;
import thredds.inventory.DateExtractor;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.DateExtractorNone;
import thredds.inventory.FeatureCollectionConfig;
import thredds.inventory.MCollection;
import thredds.inventory.MController;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;
import thredds.inventory.filter.Composite;
import thredds.inventory.filter.LastModifiedLimit;
import thredds.inventory.filter.RegExpMatchOnName;
import thredds.inventory.filter.WildcardMatchOnName;
import thredds.inventory.filter.WildcardMatchOnPath;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.TimeDuration;

@ThreadSafe
public class DatasetCollectionMFiles
extends CollectionManagerAbstract {
    public static final String CATALOG = "catalog:";
    private static final Logger logger = LoggerFactory.getLogger(DatasetCollectionMFiles.class);
    private static MController controller;
    protected DateExtractor dateExtractor;
    protected CalendarDate startPartition;
    private final List<MCollection> scanList = new ArrayList<MCollection>();
    private final double olderThanFilterInSecs;
    private final String rootDir;
    protected FeatureCollectionConfig config;
    private Map<String, MFile> map;
    private long lastScanned;
    private AtomicLong lastChanged = new AtomicLong();

    public static void setController(MController _controller) {
        controller = _controller;
    }

    public static MController getController() {
        if (null == controller) {
            controller = new ControllerOS();
        }
        return controller;
    }

    public static DatasetCollectionMFiles open(String collection, String olderThan, Formatter errlog) throws IOException {
        if (collection.startsWith(CATALOG)) {
            return new DatasetCollectionFromCatalog(collection);
        }
        return new DatasetCollectionMFiles(collection, olderThan, errlog, null);
    }

    public static DatasetCollectionMFiles openWithRecheck(String recheckS) {
        return new DatasetCollectionMFiles(recheckS, null);
    }

    private DatasetCollectionMFiles(String collectionSpec, String olderThan, Formatter errlog, Object fake) {
        super(collectionSpec);
        CollectionSpecParser sp = new CollectionSpecParser(collectionSpec, errlog);
        this.recheck = null;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.rootDir = sp.getRootDir();
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(2);
        if (null != sp.getFilter()) {
            filters.add(new WildcardMatchOnName(sp.getFilter()));
        }
        this.olderThanFilterInSecs = this.getOlderThanFilter(filters, olderThan);
        this.dateExtractor = sp.getDateFormatMark() == null ? new DateExtractorNone() : new DateExtractorFromName(sp.getDateFormatMark(), sp.useName());
        this.scanList.add(new MCollection(sp.getRootDir(), sp.getRootDir(), sp.wantSubdirs(), filters, null));
    }

    public DatasetCollectionMFiles(FeatureCollectionConfig config, Formatter errlog) {
        super(config.name != null ? config.name : config.spec);
        this.config = config;
        CollectionSpecParser sp = new CollectionSpecParser(config.spec, errlog);
        this.rootDir = sp.getRootDir();
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != sp.getFilter()) {
            filters.add(new WildcardMatchOnName(sp.getFilter()));
        }
        this.olderThanFilterInSecs = this.getOlderThanFilter(filters, config.olderThan);
        this.dateExtractor = sp.getDateFormatMark() == null ? new DateExtractorNone() : new DateExtractorFromName(sp.getDateFormatMark(), sp.useName());
        this.scanList.add(new MCollection(sp.getRootDir(), sp.getRootDir(), sp.wantSubdirs(), filters, null));
        this.recheck = this.makeRecheck(config.recheckAfter);
        this.protoChoice = config.protoConfig.choice;
    }

    public DatasetCollectionMFiles(String name, String spec, Formatter errlog) {
        super(name);
        CollectionSpecParser sp = new CollectionSpecParser(spec, errlog);
        this.rootDir = sp.getRootDir();
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != sp.getFilter()) {
            filters.add(new WildcardMatchOnName(sp.getFilter()));
        }
        this.dateExtractor = sp.getDateFormatMark() == null ? new DateExtractorNone() : new DateExtractorFromName(sp.getDateFormatMark(), sp.useName());
        this.scanList.add(new MCollection(sp.getRootDir(), sp.getRootDir(), sp.wantSubdirs(), filters, null));
        this.recheck = null;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.olderThanFilterInSecs = -1.0;
    }

    public DatasetCollectionMFiles(String name, MCollection mc, CalendarDate startPartition) {
        super(name);
        this.startPartition = startPartition;
        this.scanList.add(mc);
        this.rootDir = mc.getDirectoryName();
        this.recheck = null;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.olderThanFilterInSecs = -1.0;
    }

    @Override
    public CalendarDate getStartCollection() {
        return this.startPartition;
    }

    private double getOlderThanFilter(List<MFileFilter> filters, String olderThan) {
        if (olderThan != null) {
            try {
                TimeDuration tu = new TimeDuration(olderThan);
                double olderThanV = tu.getValueInSeconds();
                filters.add(new LastModifiedLimit((long)(1000.0 * olderThanV)));
                return olderThanV;
            }
            catch (Exception e) {
                logger.error(this.collectionName + ": Invalid time unit for olderThan = {}", (Object)olderThan);
            }
        }
        return -1.0;
    }

    private TimeDuration makeRecheck(String recheckS) {
        if (recheckS != null) {
            try {
                return new TimeDuration(recheckS);
            }
            catch (Exception e) {
                logger.error(this.collectionName + ": Invalid time unit for recheckEvery = {}", (Object)recheckS);
            }
        }
        return null;
    }

    protected DatasetCollectionMFiles(String name) {
        super(name);
        this.recheck = null;
        this.olderThanFilterInSecs = -1.0;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.rootDir = null;
    }

    private DatasetCollectionMFiles(String recheckS, Object fake) {
        super(null);
        this.recheck = this.makeRecheck(recheckS);
        this.olderThanFilterInSecs = -1.0;
        this.protoChoice = FeatureCollectionConfig.ProtoChoice.Penultimate;
        this.rootDir = null;
    }

    public void setDateExtractor(DateExtractor dateExtractor) {
        this.dateExtractor = dateExtractor;
    }

    public void addDirectoryScan(String dirName, String suffix, String regexpPatternString, String subdirsS, String olderS, Object auxInfo) {
        ArrayList<MFileFilter> filters = new ArrayList<MFileFilter>(3);
        if (null != regexpPatternString) {
            filters.add(new RegExpMatchOnName(regexpPatternString));
        } else if (suffix != null) {
            filters.add(new WildcardMatchOnPath("*" + suffix + "$"));
        }
        if (olderS != null) {
            try {
                TimeDuration tu = new TimeDuration(olderS);
                filters.add(new LastModifiedLimit((long)(1000.0 * tu.getValueInSeconds())));
            }
            catch (Exception e) {
                logger.error(this.collectionName + ": Invalid time unit for olderThan = {}", (Object)olderS);
            }
        }
        boolean wantSubdirs = true;
        if (subdirsS != null && subdirsS.equalsIgnoreCase("false")) {
            wantSubdirs = false;
        }
        Composite filter = filters.size() == 0 ? null : (filters.size() == 1 ? (MFileFilter)filters.get(0) : new Composite(filters));
        MCollection mc = new MCollection(dirName, dirName, wantSubdirs, filter, auxInfo);
        StringBuilder sb = new StringBuilder(dirName);
        if (wantSubdirs) {
            sb.append("**/");
        }
        if (null != regexpPatternString) {
            sb.append(regexpPatternString);
        } else if (suffix != null) {
            sb.append(suffix);
        } else {
            sb.append("noFilter");
        }
        this.collectionName = sb.toString();
        this.scanList.add(mc);
    }

    @Override
    public String getRoot() {
        return this.rootDir;
    }

    @Override
    public double getOlderThanFilterInSecs() {
        return this.olderThanFilterInSecs;
    }

    @Override
    public long getLastScanned() {
        return this.lastScanned;
    }

    @Override
    public boolean scanIfNeeded() throws IOException {
        return this.isScanNeeded() && this.scan();
    }

    protected boolean hasScans() {
        return !this.scanList.isEmpty();
    }

    @Override
    public boolean isScanNeeded() {
        if (!this.hasScans()) {
            logger.debug("{}: scan not needed, no scanners", (Object)this.collectionName);
            return false;
        }
        if (this.map == null) {
            logger.debug("{}: scan needed, never scanned", (Object)this.collectionName);
            return true;
        }
        if (this.recheck == null) {
            logger.debug("{}: scan not needed, recheck null", (Object)this.collectionName);
            return false;
        }
        Date now = new Date();
        Date lastCheckedDate = new Date(this.lastScanned);
        Date need = this.recheck.add(lastCheckedDate);
        if (now.before(need)) {
            logger.debug("{}: scan not needed, last scanned={}, now={}", new Object[]{this.collectionName, lastCheckedDate, now});
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scan() throws IOException {
        DatasetCollectionMFiles datasetCollectionMFiles;
        boolean changed;
        if (this.map == null) {
            boolean changed2 = this.scanFirstTime();
            if (changed2) {
                this.sendEvent(new CollectionManager.TriggerEvent(this, CollectionManager.TriggerType.update));
            }
            return changed2;
        }
        Map<String, MFile> oldMap = this.map;
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        this.scan(newMap);
        int nnew = 0;
        int nchange = 0;
        for (MFile newFile : newMap.values()) {
            String path = newFile.getPath();
            MFile oldFile = oldMap.get(path);
            if (oldFile != null) {
                if (newFile.getLastModified() > oldFile.getLastModified()) {
                    ++nchange;
                    logger.debug("{}: scan found Dataset changed= {}", (Object)this.collectionName, (Object)path);
                    continue;
                }
                if (this.changeChecker == null || !this.changeChecker.hasChangedSince(newFile, -1L)) continue;
                ++nchange;
                logger.debug("{}: scan changeChecker found Dataset changed= {}", (Object)this.collectionName, (Object)path);
                continue;
            }
            ++nnew;
            logger.debug("{}: scan found new Dataset= {} ", (Object)this.collectionName, (Object)path);
        }
        int ndelete = 0;
        for (MFile oldDataset : oldMap.values()) {
            String path = oldDataset.getPath();
            MFile newDataset = (MFile)newMap.get(path);
            if (newDataset != null) continue;
            ++ndelete;
            logger.debug("{}: scan found deleted Dataset={}", (Object)this.collectionName, (Object)path);
        }
        boolean bl = changed = nnew > 0 || ndelete > 0 || nchange > 0;
        if (changed) {
            datasetCollectionMFiles = this;
            synchronized (datasetCollectionMFiles) {
                this.map = newMap;
                this.lastScanned = System.currentTimeMillis();
                this.lastChanged.set(this.lastScanned);
            }
        }
        datasetCollectionMFiles = this;
        synchronized (datasetCollectionMFiles) {
            this.lastScanned = System.currentTimeMillis();
        }
        if (changed) {
            this.sendEvent(new CollectionManager.TriggerEvent(this, CollectionManager.TriggerType.update));
        }
        logger.info("{}: scan at {} nnew={}, ndelete={}", new Object[]{this.collectionName, new Date(), nnew, ndelete});
        return changed;
    }

    @Override
    public Iterable<MFile> getFiles() {
        if (this.map == null) {
            return Collections.emptyList();
        }
        ArrayList<MFile> result = new ArrayList<MFile>(this.map.values());
        if (this.hasDateExtractor()) {
            Collections.sort(result, new DateSorter());
        } else {
            Collections.sort(result);
        }
        return result;
    }

    @Override
    public CalendarDate extractRunDate(MFile mfile) {
        return this.dateExtractor == null ? null : this.dateExtractor.getCalendarDate(mfile);
    }

    @Override
    public boolean hasDateExtractor() {
        return this.dateExtractor != null && !(this.dateExtractor instanceof DateExtractorNone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanFirstTime() throws IOException {
        HashMap<String, MFile> newMap = new HashMap<String, MFile>();
        if (!this.hasScans()) {
            this.map = newMap;
            return false;
        }
        this.scan(newMap);
        DatasetCollectionMFiles datasetCollectionMFiles = this;
        synchronized (datasetCollectionMFiles) {
            this.map = newMap;
            this.lastScanned = System.currentTimeMillis();
            this.lastChanged.set(this.lastScanned);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.collectionName + ": initial scan found n datasets = " + this.map.keySet().size());
        }
        return this.map.keySet().size() > 0;
    }

    protected void scan(Map<String, MFile> map) throws IOException {
        DatasetCollectionMFiles.getController();
        for (MCollection mc : this.scanList) {
            Iterator<MFile> iter;
            Iterator<MFile> iterator = iter = mc.wantSubdirs() ? controller.getInventoryAll(mc, true) : controller.getInventoryTop(mc, true);
            if (iter == null) {
                logger.error(this.collectionName + ": DatasetCollectionManager Invalid collection= " + mc);
                continue;
            }
            while (iter.hasNext()) {
                MFile mfile = iter.next();
                mfile.setAuxInfo(mc.getAuxInfo());
                map.put(mfile.getPath(), mfile);
            }
        }
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("DatasetCollectionManager{ collectionName='%s' recheck=%s ", this.collectionName, this.recheck);
        for (MCollection mc : this.scanList) {
            f.format("%n dir=%s filter=%s", mc.getDirectoryName(), mc.getFileFilter());
        }
        return f.toString();
    }

    private class DateSorter
    implements Comparator<MFile> {
        private DateSorter() {
        }

        @Override
        public int compare(MFile m1, MFile m2) {
            return DatasetCollectionMFiles.this.extractRunDate(m1).compareTo(DatasetCollectionMFiles.this.extractRunDate(m2));
        }
    }
}

