/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.constants;

import ucar.nc2.NetcdfFile;

public interface CF {
    public static final String POSITIVE_UP = "up";
    public static final String POSITIVE_DOWN = "down";
    public static final String featureTypeAtt = "featureType";
    public static final String featureTypeAtt2 = "CF:featureType";
    public static final String featureTypeAtt3 = "CF:feature_type";
    public static final String ADD_OFFSET = "add_offset";
    public static final String BOUNDS = "bounds";
    public static final String CF_ROLE = "cf_role";
    public static final String COORDINATES = "coordinates";
    public static final String LONG_NAME = "long_name";
    public static final String MISSING_VALUE = "missing_value";
    public static final String SCALE_FACTOR = "scale_factor";
    public static final String STANDARD_NAME = "standard_name";
    public static final String UNITS = "units";
    public static final String ALBERS_CONICAL_EQUAL_AREA = "albers_conical_equal_area";
    public static final String AZIMUTHAL_EQUIDISTANT = "azimuthal_equidistant";
    public static final String LAMBERT_AZIMUTHAL_EQUAL_AREA = "lambert_azimuthal_equal_area";
    public static final String LAMBERT_CONFORMAL_CONIC = "lambert_conformal_conic";
    public static final String LAMBERT_CYLINDRICAL_EQUAL_AREA = "lambert_cylindrical_equal_area";
    public static final String LATITUDE_LONGITUDE = "latitude_longitude";
    public static final String MERCATOR = "mercator";
    public static final String ORTHOGRAPHIC = "orthographic";
    public static final String POLAR_STEREOGRAPHIC = "polar_stereographic";
    public static final String ROTATED_LATITUDE_LONGITUDE = "rotated_latitude_longitude";
    public static final String STEREOGRAPHIC = "stereographic";
    public static final String TRANSVERSE_MERCATOR = "transverse_mercator";
    public static final String VERTICAL_PERSPECTIVE = "vertical_perspective";
    public static final String EARTH_RADIUS = "earth_radius";
    public static final String FALSE_EASTING = "false_easting";
    public static final String FALSE_NORTHING = "false_northing";
    public static final String GRID_MAPPING = "grid_mapping";
    public static final String GRID_MAPPING_NAME = "grid_mapping_name";
    public static final String GRID_NORTH_POLE_LATITUDE = "grid_north_pole_latitude";
    public static final String GRID_NORTH_POLE_LONGITUDE = "grid_north_pole_longitude";
    public static final String INVERSE_FLATTENING = "inverse_flattening";
    public static final String LATITUDE_OF_PROJECTION_ORIGIN = "latitude_of_projection_origin";
    public static final String LONGITUDE_OF_PROJECTION_ORIGIN = "longitude_of_projection_origin";
    public static final String LATITUDE_OF_PRIME_MERIDIAN = "latitude_of_prime_meridian";
    public static final String LONGITUDE_OF_PRIME_MERIDIAN = "longitude_of_prime_meridian";
    public static final String LONGITUDE_OF_CENTRAL_MERIDIAN = "longitude_of_central_meridian";
    public static final String NORTH_POLE_GRID_LONGITUDE = "north_pole_grid_longitude";
    public static final String PERSPECTIVE_POINT_HEIGHT = "perspective_point_height";
    public static final String SCALE_FACTOR_AT_CENTRAL_MERIDIAN = "scale_factor_at_central_meridian";
    public static final String SCALE_FACTOR_AT_PROJECTION_ORIGIN = "scale_factor_at_projection_origin";
    public static final String SEMI_MAJOR_AXIS = "semi_major_axis";
    public static final String SEMI_MINOR_AXIS = "semi_minor_axis";
    public static final String STANDARD_PARALLEL = "standard_parallel";
    public static final String STRAIGHT_VERTICAL_LONGITUDE_FROM_POLE = "straight_vertical_longitude_from_pole";
    public static final String RAGGED_ROWSIZE = "CF:ragged_row_count";
    public static final String RAGGED_PARENTINDEX = "CF:ragged_parent_index";
    public static final String PROJECTION_X_COORDINATE = "projection_x_coordinate";
    public static final String PROJECTION_Y_COORDINATE = "projection_y_coordinate";
    public static final String STATION_ID = "station_id";
    public static final String STATION_DESC = "station_description";
    public static final String STATION_ALTITUDE = "surface_altitude";
    public static final String STATION_WMOID = "station_WMO_id";
    public static final String TRAJ_ID = "trajectory_id";
    public static final String PROFILE_ID = "profile_id";

    public static enum CellMethods {
        point,
        sum,
        mean,
        maximum,
        minimum,
        mid_range,
        standard_deviation,
        variance,
        mode,
        median;


        public static CellMethods convertGribCodeTable4_10(int code) {
            switch (code) {
                case 0: {
                    return mean;
                }
                case 1: {
                    return sum;
                }
                case 2: {
                    return maximum;
                }
                case 3: {
                    return minimum;
                }
                case 6: {
                    return standard_deviation;
                }
                case 7: {
                    return variance;
                }
            }
            return null;
        }

        public static CellMethods convertGrib1code(int code) {
            switch (code) {
                case 3: 
                case 6: 
                case 7: 
                case 51: 
                case 113: 
                case 115: 
                case 117: 
                case 123: {
                    return mean;
                }
                case 4: 
                case 114: 
                case 116: 
                case 124: {
                    return sum;
                }
                case 118: {
                    return variance;
                }
                case 119: 
                case 125: {
                    return standard_deviation;
                }
            }
            return null;
        }
    }

    public static enum FeatureType {
        point,
        timeSeries,
        profile,
        trajectory,
        timeSeriesProfile,
        trajectoryProfile;


        public static FeatureType convert(ucar.nc2.constants.FeatureType ft) {
            switch (ft) {
                case POINT: {
                    return point;
                }
                case STATION: {
                    return timeSeries;
                }
                case PROFILE: {
                    return profile;
                }
                case TRAJECTORY: {
                    return trajectory;
                }
                case STATION_PROFILE: {
                    return timeSeriesProfile;
                }
                case SECTION: {
                    return trajectoryProfile;
                }
            }
            return null;
        }

        public static FeatureType getFeatureType(String s) {
            if (s.equalsIgnoreCase("point")) {
                return point;
            }
            if (s.equalsIgnoreCase("timeSeries")) {
                return timeSeries;
            }
            if (s.equalsIgnoreCase("stationTimeSeries")) {
                return timeSeries;
            }
            if (s.equalsIgnoreCase("station")) {
                return timeSeries;
            }
            if (s.equalsIgnoreCase("profile")) {
                return profile;
            }
            if (s.equalsIgnoreCase("trajectory")) {
                return trajectory;
            }
            if (s.equalsIgnoreCase("timeSeriesProfile")) {
                return timeSeriesProfile;
            }
            if (s.equalsIgnoreCase("stationProfile")) {
                return timeSeriesProfile;
            }
            if (s.equalsIgnoreCase("stationProfileTimeSeries")) {
                return timeSeriesProfile;
            }
            if (s.equalsIgnoreCase("trajectoryProfile")) {
                return trajectoryProfile;
            }
            if (s.equalsIgnoreCase("section")) {
                return trajectoryProfile;
            }
            return null;
        }

        public static FeatureType getFeatureTypeFromGlobalAttribute(NetcdfFile ds) {
            String ftypeS = ds.findAttValueIgnoreCase(null, CF.featureTypeAtt, null);
            if (ftypeS == null) {
                ftypeS = ds.findAttValueIgnoreCase(null, CF.featureTypeAtt2, null);
            }
            if (ftypeS == null) {
                return null;
            }
            return FeatureType.getFeatureType(ftypeS);
        }
    }
}

