/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import ucar.unidata.util.StringUtil2;

public class GridParameter {
    protected int number;
    protected String name;
    protected String description;
    protected String unit;
    protected String cf_name;

    public static String cleanupUnits(String unit) {
        if (unit == null) {
            return null;
        }
        if (unit.equalsIgnoreCase("-")) {
            unit = "";
        } else {
            if (unit.startsWith("/")) {
                unit = "1" + unit;
            }
            unit = unit.trim();
            unit = StringUtil2.remove(unit, "**");
            StringBuilder sb = new StringBuilder(unit);
            StringUtil2.remove(sb, "^[]");
            StringUtil2.replace(sb, ' ', ".");
            StringUtil2.replace(sb, '*', ".");
            unit = sb.toString();
        }
        return unit;
    }

    public static String cleanupDescription(String desc) {
        if (desc == null) {
            return null;
        }
        int pos = desc.indexOf("(see");
        if (pos > 0) {
            desc = desc.substring(0, pos);
        }
        StringBuilder sb = new StringBuilder(desc.trim());
        StringUtil2.remove(sb, ".;,=[]()/");
        return sb.toString().trim();
    }

    public GridParameter() {
        this.number = -1;
        this.name = "undefined";
        this.description = "undefined";
        this.unit = "undefined";
    }

    public GridParameter(int number, String name, String description, String unit) {
        this.number = number;
        this.name = name;
        this.setDescription(description);
        this.setUnit(unit);
    }

    public GridParameter(int center, int subcenter, int version, int number) {
        this.number = number;
        this.name = "undefined";
        this.description = "Unknown-C" + center + "-S" + subcenter + "-V" + version + ":" + number;
        this.unit = "undefined";
    }

    public GridParameter(int number, String name, String description, String unit, String cf_name) {
        this.number = number;
        this.name = name;
        this.setDescription(description);
        this.setUnit(unit);
        this.cf_name = cf_name;
    }

    public final int getNumber() {
        return this.number;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getUnit() {
        return this.unit;
    }

    public String getCFname() {
        return this.cf_name;
    }

    public final void setNumber(int number) {
        this.number = number;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setDescription(String description) {
        this.description = GridParameter.cleanupDescription(description);
    }

    public final void setUnit(String unit) {
        this.unit = GridParameter.cleanupUnits(unit);
    }

    public String toString() {
        return "GridParameter{number=" + this.number + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", unit='" + this.unit + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridParameter that = (GridParameter)o;
        if (this.number != that.number) {
            return false;
        }
        if (this.cf_name != null ? !this.cf_name.equals(that.cf_name) : that.cf_name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.unit != null ? !this.unit.equals(that.unit) : that.unit != null);
    }

    public int hashCode() {
        int result = this.number;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        result = 31 * result + (this.cf_name != null ? this.cf_name.hashCode() : 0);
        return result;
    }
}

