/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.time.CalendarDate;

@Immutable
public class CalendarPeriod {
    private static final Logger log = LoggerFactory.getLogger(CalendarPeriod.class);
    private final int value;
    private final Field field;

    public static Field fromUnitString(String udunit) {
        udunit = udunit.trim();
        if ((udunit = udunit.toLowerCase()).equals("s")) {
            return Field.Second;
        }
        if (udunit.equals("ms")) {
            return Field.Millisec;
        }
        if (udunit.endsWith("s")) {
            udunit = udunit.substring(0, udunit.length() - 1);
        }
        if (udunit.equals("second") || udunit.equals("sec")) {
            return Field.Second;
        }
        if (udunit.equals("millisec") || udunit.equals("msec")) {
            return Field.Millisec;
        }
        if (udunit.equals("minute") || udunit.equals("min")) {
            return Field.Minute;
        }
        if (udunit.equals("hour") || udunit.equals("hr") || udunit.equals("h")) {
            return Field.Hour;
        }
        if (udunit.equals("day") || udunit.equals("d")) {
            return Field.Day;
        }
        if (udunit.equals("month") || udunit.equals("mon")) {
            return Field.Month;
        }
        if (udunit.equals("year") || udunit.equals("yr")) {
            return Field.Year;
        }
        throw new IllegalArgumentException("cant convert " + udunit + " to CalendarPeriod");
    }

    public static CalendarPeriod of(int value, Field field) {
        return new CalendarPeriod(value, field);
    }

    private CalendarPeriod(int value, Field field) {
        this.value = value;
        this.field = field;
    }

    public CalendarPeriod multiply(int value) {
        return new CalendarPeriod(this.value * value, this.field);
    }

    public int getValue() {
        return this.value;
    }

    public Field getField() {
        return this.field;
    }

    public int subtract(CalendarDate start, CalendarDate end) {
        if (this.field == Field.Month || this.field == Field.Year) {
            log.warn(" using Month or Year");
            long diff = end.getDifferenceInMsecs(start);
            return (int)((double)diff / this.getValueInMillisecs());
        }
        long diff = end.getDifferenceInMsecs(start);
        return (int)(diff / (long)this.millisecs());
    }

    public double getValueInMillisecs() {
        if (this.field == Field.Month) {
            return 2.592E9 * (double)this.value;
        }
        if (this.field == Field.Year) {
            return 3.1536E10 * (double)this.value;
        }
        return this.millisecs();
    }

    private int millisecs() {
        if (this.field == Field.Millisec) {
            return this.value;
        }
        if (this.field == Field.Second) {
            return 1000 * this.value;
        }
        if (this.field == Field.Minute) {
            return 60000 * this.value;
        }
        if (this.field == Field.Hour) {
            return 3600000 * this.value;
        }
        if (this.field == Field.Day) {
            return 86400000 * this.value;
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return this.value + " " + (Object)((Object)this.field);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarPeriod that = (CalendarPeriod)o;
        if (this.value != that.value) {
            return false;
        }
        return this.field == that.field;
    }

    public int hashCode() {
        int result = this.value;
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        return result;
    }

    public static enum Field {
        Millisec,
        Second,
        Minute,
        Hour,
        Day,
        Month,
        Year;

    }
}

