/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Properties;

public class Misc {
    private static boolean show = false;
    private static double maxReletiveError = 1.0E-6;
    private static final String threddsPropFileName = "thredds.properties";
    private static final String testdataDirPropName = "unidata.testdata.path";
    private static String testdataDirPath = null;

    public static boolean closeEnough(double v1, double v2, double tol) {
        if (show) {
            double d1 = Math.abs(v1 - v2);
            double d3 = Math.abs(v1 / v2);
            double d2 = Math.abs(v1 / v2 - 1.0);
            System.out.println("v1= " + v1 + " v2=" + v2 + " diff=" + d1 + " abs(v1/v2)=" + d3 + " abs(v1/v2-1)=" + d2);
        }
        double diff = v2 == 0.0 ? Math.abs(v1 - v2) : Math.abs(v1 / v2 - 1.0);
        return diff < tol;
    }

    public static boolean closeEnough(double v1, double v2) {
        if (v1 == v2) {
            return true;
        }
        double diff = v2 == 0.0 ? Math.abs(v1 - v2) : Math.abs(v1 / v2 - 1.0);
        return diff < maxReletiveError;
    }

    public static boolean closeEnough(float v1, float v2) {
        if (v1 == v2) {
            return true;
        }
        double diff = (double)v2 == 0.0 ? (double)Math.abs(v1 - v2) : (double)Math.abs(v1 / v2 - 1.0f);
        return diff < maxReletiveError;
    }

    public static void main(String[] args) {
        long val1 = -1L;
        long val2 = 0xDFFDDF5L;
        int val3 = 2348;
        int val4 = 32;
        Formatter f = new Formatter(System.out);
        f.format("  address            dataPos            offset size\n", new Object[0]);
        f.format("  %#-18x %#-18x %5d  %4d%n", val1, val2, val3, val4);
    }

    public static String showBytes(byte[] buff) {
        StringBuilder sbuff = new StringBuilder();
        for (int i = 0; i < buff.length; ++i) {
            int ub;
            int b = buff[i];
            int n = ub = b < 0 ? b + 256 : b;
            if (i > 0) {
                sbuff.append(" ");
            }
            sbuff.append(ub);
        }
        return sbuff.toString();
    }

    public static void showBytes(byte[] buff, Formatter f) {
        for (int i = 0; i < buff.length; ++i) {
            int b = buff[i];
            int ub = b < 0 ? b + 256 : b;
            f.format("%3d ", ub);
        }
    }

    public static int getSize(Iterable ii) {
        if (ii instanceof Collection) {
            return ((Collection)ii).size();
        }
        int count = 0;
        for (Object i : ii) {
            ++count;
        }
        return count;
    }

    public static List getList(Iterable ii) {
        if (ii instanceof List) {
            return (List)ii;
        }
        ArrayList result = new ArrayList();
        for (Object i : ii) {
            result.add(i);
        }
        return result;
    }

    public static String getTestdataDirPath() {
        File userHomeDirFile;
        File userThreddsPropsFile;
        if (testdataDirPath == null) {
            testdataDirPath = System.getProperty(testdataDirPropName);
        }
        if (testdataDirPath == null && (userThreddsPropsFile = new File(userHomeDirFile = new File(System.getProperty("user.home")), threddsPropFileName)).exists() && userThreddsPropsFile.canRead()) {
            Properties userThreddsProps = new Properties();
            try {
                userThreddsProps.load(new FileInputStream(userThreddsPropsFile));
            }
            catch (IOException e) {
                System.out.println("**Failed loading user THREDDS property file: " + e.getMessage());
            }
            if (!userThreddsProps.isEmpty()) {
                testdataDirPath = userThreddsProps.getProperty(testdataDirPropName);
            }
        }
        return testdataDirPath;
    }
}

