/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.slf4j.Logger;
import ucar.nc2.util.log.LogStream;
import ucar.nc2.util.net.EscapeStrings;
import ucar.nc2.util.net.HTTPAuthProvider;
import ucar.nc2.util.net.HTTPAuthStore;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPSession;

@NotThreadSafe
public class HTTPMethod {
    private static Logger LOG = null;
    static HashMap<String, Object> globalparams = new HashMap();
    HTTPSession session = null;
    HttpMethodBase method = null;
    String legalurl = null;
    List<Header> headers = new ArrayList<Header>();
    HashMap<String, Object> params = new HashMap();
    HttpState context = null;
    boolean executed = false;
    protected boolean closed = false;
    InputStream strm = null;
    RequestEntity content = null;
    HTTPSession.Methods methodclass = null;
    Part[] multiparts = null;

    public static HTTPMethod Get(HTTPSession session) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Get, session, null);
    }

    public static HTTPMethod Head(HTTPSession session) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Head, session, null);
    }

    public static HTTPMethod Put(HTTPSession session) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Put, session, null);
    }

    public static HTTPMethod Post(HTTPSession session) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Post, session, null);
    }

    public static HTTPMethod Options(HTTPSession session) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Options, session, null);
    }

    public static HTTPMethod Get(HTTPSession session, String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Get, session, legalurl);
    }

    public static HTTPMethod Head(HTTPSession session, String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Head, session, legalurl);
    }

    public static HTTPMethod Put(HTTPSession session, String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Put, session, legalurl);
    }

    public static HTTPMethod Post(HTTPSession session, String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Post, session, legalurl);
    }

    public static HTTPMethod Options(HTTPSession session, String legalurl) throws HTTPException {
        return new HTTPMethod(HTTPSession.Methods.Options, session, legalurl);
    }

    public static synchronized void setGlobalParameter(String name, Object value) {
        globalparams.put(name, value);
    }

    public HTTPMethod(HTTPSession.Methods m, HTTPSession session, String url) throws HTTPException {
        if (session == null) {
            throw new HTTPException("HTTPMethod: no session object specified");
        }
        this.session = session;
        if (url == null) {
            url = session.getURL();
        }
        if (url == null) {
            throw new HTTPException("HTTPMethod: no url specified");
        }
        this.legalurl = url = HTTPSession.removeprincipal(url);
        if (!this.sessionCompatible(url)) {
            throw new HTTPException("HTTPMethod: session incompatible url");
        }
        this.session.addMethod(this);
        String urlencoded = EscapeStrings.escapeURL(this.legalurl);
        this.methodclass = m;
        switch (this.methodclass) {
            case Put: {
                this.method = new PutMethod(urlencoded);
                break;
            }
            case Post: {
                this.method = new PostMethod(urlencoded);
                break;
            }
            case Get: {
                this.method = new GetMethod(urlencoded);
                break;
            }
            case Head: {
                this.method = new HeadMethod(urlencoded);
                break;
            }
            case Options: {
                this.method = new OptionsMethod(urlencoded);
                break;
            }
            default: {
                this.method = null;
            }
        }
        if (this.method != null) {
            this.method.setFollowRedirects(true);
            this.method.setDoAuthentication(true);
        }
    }

    void setcontent() {
        switch (this.methodclass) {
            case Put: {
                if (this.content == null) break;
                ((PutMethod)this.method).setRequestEntity(this.content);
                break;
            }
            case Post: {
                if (this.multiparts != null && this.multiparts.length > 0) {
                    MultipartRequestEntity mre = new MultipartRequestEntity(this.multiparts, this.method.getParams());
                    ((PostMethod)this.method).setRequestEntity((RequestEntity)mre);
                    break;
                }
                if (this.content == null) break;
                ((PostMethod)this.method).setRequestEntity(this.content);
                break;
            }
        }
        this.content = null;
        this.multiparts = null;
    }

    public int execute() throws HTTPException {
        if (this.executed) {
            throw new HTTPException("Method instance already executed");
        }
        if (this.legalurl == null) {
            throw new HTTPException("No url specified");
        }
        try {
            int code;
            HttpMethodParams hmp;
            if (this.headers.size() > 0) {
                for (Header h : this.headers) {
                    this.method.addRequestHeader(h);
                }
            }
            if (globalparams != null) {
                hmp = this.method.getParams();
                for (String key : globalparams.keySet()) {
                    hmp.setParameter(key, globalparams.get(key));
                }
            }
            if (this.params != null) {
                hmp = this.method.getParams();
                for (String key : this.params.keySet()) {
                    hmp.setParameter(key, this.params.get(key));
                }
            }
            this.method.getParams().setParameter("http.method.retry-handler", (Object)new RetryHandler());
            this.setcontent();
            HTTPMethod.setAuthentication(this.session, this);
            try {
                this.session.sessionClient.executeMethod((HttpMethod)this.method);
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
                throw iae;
            }
            int n = code = this.getStatusCode();
            return n;
        }
        catch (Exception ie) {
            ie.printStackTrace();
            throw new HTTPException(ie);
        }
        finally {
            this.executed = true;
        }
    }

    public void close() {
        if (this.closed) {
            LogStream.err.println("HTTPMethod: attempt to close already closed method.");
            return;
        }
        if (this.executed) {
            this.consumeContent();
        } else if (this.method != null) {
            this.method.abort();
        }
        if (this.method != null) {
            this.method.releaseConnection();
        }
        this.closed = true;
        this.session.removeMethod(this);
    }

    public void consumeContent() {
        this.method.abort();
    }

    public void setContext(HttpState cxt) {
        this.session.setContext(cxt);
    }

    public HttpState getContext() {
        return this.session.getContext();
    }

    public int getStatusCode() {
        return this.method == null ? 0 : this.method.getStatusCode();
    }

    public String getStatusLine() {
        return this.method == null ? null : this.method.getStatusLine().toString();
    }

    public String getRequestLine() {
        return "getrequestline not implemented";
    }

    public String getPath() {
        try {
            return this.method == null ? null : this.method.getURI().toString();
        }
        catch (URIException e) {
            return null;
        }
    }

    public boolean canHoldContent() {
        if (this.method == null) {
            return false;
        }
        return !(this.method instanceof HeadMethod);
    }

    public InputStream getResponseBodyAsStream() {
        return this.getResponseAsStream();
    }

    public InputStream getResponseAsStream() {
        if (this.closed) {
            return null;
        }
        if (this.strm != null) {
            try {
                new Exception("Getting MethodStream").printStackTrace();
            }
            catch (Exception e) {
                // empty catch block
            }
            assert (this.strm != null) : "attempt to get method stream twice";
        }
        try {
            if (this.method == null) {
                return null;
            }
            this.strm = this.method.getResponseBodyAsStream();
            return this.strm;
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] getResponseAsBytes(int maxsize) {
        if (this.closed) {
            return null;
        }
        byte[] content = this.getResponseAsBytes();
        if (content.length > maxsize) {
            byte[] limited = new byte[maxsize];
            System.arraycopy(content, 0, limited, 0, maxsize);
            content = limited;
        }
        return content;
    }

    public byte[] getResponseAsBytes() {
        if (this.closed || this.method == null) {
            return null;
        }
        try {
            return this.method.getResponseBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getResponseAsString(String charset) {
        if (this.closed || this.method == null) {
            return null;
        }
        try {
            return this.method.getResponseBodyAsString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getResponseAsString() {
        return this.getResponseAsString("UTF-8");
    }

    public void setMethodHeaders(List<Header> headers) throws HTTPException {
        try {
            for (Header h : headers) {
                this.headers.add(h);
            }
        }
        catch (Exception e) {
            throw new HTTPException(e);
        }
    }

    public void setRequestHeader(String name, String value) throws HTTPException {
        this.setRequestHeader(new Header(name, value));
    }

    public void setRequestHeader(Header h) throws HTTPException {
        try {
            this.headers.add(h);
        }
        catch (Exception e) {
            throw new HTTPException("cause", e);
        }
    }

    public Header getRequestHeader(String name) {
        if (this.method == null) {
            return null;
        }
        try {
            return this.method.getRequestHeader(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header[] getRequestHeaders() {
        if (this.method == null) {
            return null;
        }
        try {
            Header[] hs = this.method.getRequestHeaders();
            return hs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header getResponseHeader(String name) {
        try {
            return this.method.getResponseHeader(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header getResponseHeaderdmh(String name) {
        try {
            Header[] headers;
            for (Header h : headers = this.getResponseHeaders()) {
                if (!h.getName().equals(name)) continue;
                return h;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header[] getResponseHeaders() {
        try {
            Header[] hs = this.method.getResponseHeaders();
            return hs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header[] getResponseFooters() {
        try {
            Header[] hs = this.method.getResponseFooters();
            return hs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setRequestParameter(String name, Object value) {
        this.params.put(name, value);
    }

    public Object getMethodParameter(String key) {
        if (this.method == null) {
            return null;
        }
        return this.method.getParams().getParameter(key);
    }

    public HttpMethodParams getMethodParameters() {
        if (this.method == null) {
            return null;
        }
        return this.method.getParams();
    }

    public Object getResponseParameter(String name) {
        if (this.method == null) {
            return null;
        }
        return this.method.getParams().getParameter(name);
    }

    public void setRequestContentAsString(String content) throws HTTPException {
        try {
            this.content = new StringRequestEntity(content, "application/text", "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setMultipartRequest(Part[] parts) throws HTTPException {
        this.multiparts = new Part[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            this.multiparts[i] = parts[i];
        }
    }

    public String getCharSet() {
        return "UTF-8";
    }

    public String getName() {
        return this.method == null ? null : this.method.getName();
    }

    public String getURL() {
        return this.method == null ? null : this.method.getPath().toString();
    }

    public String getEffectiveVersion() {
        String ver = null;
        if (this.method != null) {
            ver = this.method.getEffectiveVersion().toString();
        }
        return ver;
    }

    public String getProtocolVersion() {
        return this.getEffectiveVersion();
    }

    public String getSoTimeout() {
        return this.method == null ? null : "" + this.method.getParams().getSoTimeout();
    }

    public String getVirtualHost() {
        return this.method == null ? null : this.method.getParams().getVirtualHost();
    }

    public String getStatusText() {
        return this.getStatusLine();
    }

    public static Enumeration getAllowedMethods() {
        Enumeration e = new OptionsMethod().getAllowedMethods();
        return e;
    }

    public void setFollowRedirects(boolean tf) {
    }

    public String getResponseCharSet() {
        return "UTF-8";
    }

    public HTTPSession getSession() {
        return this.session;
    }

    public HttpMethodBase getMethod() {
        return this.method;
    }

    boolean sessionCompatible(String other) {
        String sessionurl = HTTPSession.getCanonicalURL(this.session.getURL());
        if (sessionurl == null) {
            return true;
        }
        other = HTTPSession.getCanonicalURL(other);
        return HTTPAuthStore.compatibleURL(sessionurl, other);
    }

    private static synchronized void setAuthentication(HTTPSession session, HTTPMethod method) {
        String url = session.getURL();
        if (url == null) {
            url = "";
        }
        HTTPAuthProvider cp = new HTTPAuthProvider(url);
        session.sessionClient.getParams().setParameter("http.authentication.credential-provider", (Object)cp);
        HttpConnectionManagerParams hcp = session.sessionClient.getHttpConnectionManager().getParams();
        hcp.setParameter("http.authentication.credential-provider", (Object)cp);
    }

    public static class RetryHandler
    extends DefaultHttpMethodRetryHandler {
        static final int MAXRETRIES = 10;
        static final boolean verbose = false;

        public RetryHandler() {
            super(10, false);
        }

        public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
            return super.retryMethod(method, exception, executionCount);
        }
    }
}

