/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.util.Formatter;
import net.jcip.annotations.Immutable;

@Immutable
public class Earth {
    private static final double earthRadius = 6371229.0;
    protected final double eccentricity;
    protected final double eccentricitySquared;
    protected final double equatorRadius;
    protected final double poleRadius;
    protected final double flattening;
    protected final String name;

    public static double getRadius() {
        return 6371229.0;
    }

    public Earth() {
        this(6371229.0);
    }

    public Earth(double radius) {
        this.equatorRadius = radius;
        this.poleRadius = radius;
        this.flattening = 0.0;
        this.eccentricity = 1.0;
        this.eccentricitySquared = 1.0;
        this.name = "spherical_earth";
    }

    public Earth(double equatorRadius, double poleRadius, double reciprocalFlattening) {
        this(equatorRadius, poleRadius, reciprocalFlattening, "ellipsoidal_earth");
    }

    public Earth(double equatorRadius, double poleRadius, double reciprocalFlattening, String name) {
        this.equatorRadius = equatorRadius;
        this.name = name;
        if (reciprocalFlattening != 0.0) {
            this.flattening = 1.0 / reciprocalFlattening;
            this.eccentricitySquared = 2.0 * this.flattening - this.flattening * this.flattening;
            this.poleRadius = equatorRadius * Math.sqrt(1.0 - this.eccentricitySquared);
        } else {
            this.poleRadius = poleRadius;
            this.eccentricitySquared = 1.0 - poleRadius * poleRadius / (equatorRadius * equatorRadius);
            this.flattening = 1.0 - poleRadius / equatorRadius;
        }
        this.eccentricity = Math.sqrt(this.eccentricitySquared);
    }

    public boolean isSpherical() {
        return this.flattening == 0.0;
    }

    public double getMajor() {
        return this.equatorRadius;
    }

    public double getMinor() {
        return this.poleRadius;
    }

    public String getName() {
        return this.name;
    }

    public double getEccentricity() {
        return this.eccentricity;
    }

    public double getEccentricitySquared() {
        return this.eccentricitySquared;
    }

    public double getEquatorRadius() {
        return this.equatorRadius;
    }

    public double getPoleRadius() {
        return this.poleRadius;
    }

    public double getFlattening() {
        return this.flattening;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Earth earth = (Earth)o;
        if (Double.compare(earth.equatorRadius, this.equatorRadius) != 0) {
            return false;
        }
        if (Double.compare(earth.poleRadius, this.poleRadius) != 0) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(earth.name) : earth.name != null);
    }

    public int hashCode() {
        long temp = this.equatorRadius != 0.0 ? Double.doubleToLongBits(this.equatorRadius) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.poleRadius != 0.0 ? Double.doubleToLongBits(this.poleRadius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        Formatter ff = new Formatter();
        ff.format("equatorRadius=%f inverseFlattening=%f", this.equatorRadius, 1.0 / this.flattening);
        return ff.toString();
    }
}

