/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.Date;
import java.util.Formatter;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.crawl.CatalogCrawler;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.ft.fmrc.Fmrc;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.units.DateType;

@ThreadSafe
public class CatalogCollectionManager
extends MFileCollectionManager
implements CatalogCrawler.Listener {
    private static final Logger log = LoggerFactory.getLogger(CatalogCollectionManager.class);
    private final String catalogUrl;
    private boolean debug = false;

    public CatalogCollectionManager(String collection) {
        super(collection);
        int pos;
        if (collection.startsWith("catalog:")) {
            collection = collection.substring("catalog:".length());
        }
        if ((pos = collection.indexOf(63)) > 0) {
            this.dateExtractor = new DateExtractorFromName(collection.substring(pos + 1), true);
            collection = collection.substring(0, pos);
        }
        this.catalogUrl = collection;
    }

    @Override
    protected boolean hasScans() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reallyScan(Map<String, MFile> map) throws IOException {
        StringBuilder buff;
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
        InvCatalogImpl cat = catFactory.readXML(this.catalogUrl);
        boolean isValid = cat.check(buff = new StringBuilder(), false);
        if (!isValid) {
            log.warn("Catalog invalid= " + this.catalogUrl + " validation output= " + buff);
            return;
        }
        CatalogCrawler crawler = new CatalogCrawler(1, false, this);
        long start = System.currentTimeMillis();
        try {
            crawler.crawl(cat, null, null, map);
        }
        finally {
            long took = System.currentTimeMillis() - start;
            if (this.debug) {
                System.out.format("***Done " + this.catalogUrl + " took = " + took + " msecs\n", new Object[0]);
            }
        }
    }

    @Override
    public void getDataset(InvDataset ds, Object context) {
        if (ds.hasAccess()) {
            ThreddsDataFactory tdataFactory = new ThreddsDataFactory();
            InvAccess access = tdataFactory.chooseDatasetAccess(ds.getAccess());
            MFileRemote mfile = new MFileRemote(access);
            if (mfile.getPath().endsWith(".xml")) {
                return;
            }
            Map map = (Map)context;
            map.put(mfile.getPath(), mfile);
            if (this.debug) {
                System.out.format("add %s %n", mfile.getPath());
            }
        }
    }

    @Override
    public boolean getCatalogRef(InvCatalogRef dd, Object context) {
        return true;
    }

    public static void main(String[] arg) throws IOException {
        String catUrl = "http://motherlode.ucar.edu:8080/thredds/catalog/fmrc/NCEP/NDFD/CONUS_5km/files/catalog.xml";
        CatalogCollectionManager man = new CatalogCollectionManager(catUrl);
        man.debug = true;
        man.scan(true);
        Formatter errlog = new Formatter();
        Fmrc fmrc = Fmrc.open("catalog:" + catUrl, errlog);
        System.out.printf("errlog = %s %n", errlog);
    }

    private class MFileRemote
    implements MFile {
        private Object info;
        private final InvAccess access;
        private Date lastModified;

        MFileRemote(InvAccess access) {
            this.access = access;
            for (DateType dateType : access.getDataset().getDates()) {
                if (!dateType.getType().equals("modified")) continue;
                this.lastModified = dateType.getDate();
            }
        }

        @Override
        public long getLastModified() {
            return this.lastModified == null ? -1L : this.lastModified.getTime();
        }

        @Override
        public long getLength() {
            return (long)this.access.getDataSize();
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public String getPath() {
            return this.access.getWrappedUrlName();
        }

        @Override
        public String getName() {
            return this.access.getDataset().getName();
        }

        @Override
        public int compareTo(MFile o) {
            return this.getPath().compareTo(o.getPath());
        }

        @Override
        public Object getAuxInfo() {
            return this.info;
        }

        @Override
        public void setAuxInfo(Object info) {
            this.info = info;
        }
    }
}

