/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.proj4.LambertConformalConicEllipse;

public class LambertConformalConic
extends AbstractCoordTransBuilder {
    @Override
    public String getTransformName() {
        return "lambert_conformal_conic";
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    @Override
    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        ProjectionImpl proj;
        double[] pars = this.readAttributeDouble2(ctv.findAttribute("standard_parallel"));
        if (pars == null) {
            return null;
        }
        double lon0 = this.readAttributeDouble(ctv, "longitude_of_central_meridian", Double.NaN);
        double lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin", Double.NaN);
        double false_easting = this.readAttributeDouble(ctv, "false_easting", 0.0);
        double false_northing = this.readAttributeDouble(ctv, "false_northing", 0.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            double scalef = LambertConformalConic.getFalseEastingScaleFactor(ds, ctv);
            false_easting *= scalef;
            false_northing *= scalef;
        }
        double earth_radius = this.getEarthRadius(ctv);
        double semi_major_axis = this.readAttributeDouble(ctv, "semi_major_axis", Double.NaN);
        double semi_minor_axis = this.readAttributeDouble(ctv, "semi_minor_axis", Double.NaN);
        double inverse_flattening = this.readAttributeDouble(ctv, "inverse_flattening", 0.0);
        if (!(Double.isNaN(semi_major_axis) || Double.isNaN(semi_minor_axis) && inverse_flattening == 0.0)) {
            Earth earth = new Earth(semi_major_axis, semi_minor_axis, inverse_flattening);
            proj = new LambertConformalConicEllipse(lat0, lon0, pars[0], pars[1], false_easting, false_northing, earth);
        } else {
            proj = new LambertConformal(lat0, lon0, pars[0], pars[1], false_easting, false_northing, earth_radius);
        }
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

