/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.noaa;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.noaa.GhcnmProto;
import ucar.nc2.iosp.noaa.StructureDataAscii;
import ucar.nc2.stream.NcStream;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.TableParser;
import ucar.unidata.io.RandomAccessFile;

public class Ghcnm
extends AbstractIOServiceProvider {
    private static final String p = "(\\d{11})(\\d{4})TAVG([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)?.*";
    private static final Pattern dataPattern = Pattern.compile("(\\d{11})(\\d{4})TAVG([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)([ \\-\\d]{5})(...)?.*");
    private static final String RECORD = "all_data";
    private static final String DIM_NAME = "month";
    private static final String STNID = "stnid";
    private static final String TIME = "time";
    private static final String YEAR = "year";
    private static final String VALUE = "value";
    private static final String DMFLAG = "dm";
    private static final String QCFLAG = "qc";
    private static final String DSFLAG = "ds";
    private static final String STNS = "station";
    private static final String LAT = "lat";
    private static final String LON = "lon";
    private static final String STELEV = "elevation";
    private static final String NAME = "name";
    private static final String GRELEV = "grelev";
    private static final String POPCLS = "popClass";
    private static final String POPSIZ = "popSize";
    private static final String TOPO = "topoType";
    private static final String STVEG = "vegType";
    private static final String STLOC = "ocean";
    private static final String OCNDIS = "oceanDist";
    private static final String AIRSTN = "airportId";
    private static final String TOWNDIS = "townDist";
    private static final String GRVEG = "vegType";
    private static final String POPCSS = "popClassFromLights";
    private static final String WMO = "wmoId";
    private static final String STN_DATA = "stn_data";
    private NetcdfFile ncfile;
    private RandomAccessFile stnRaf;
    private static final String STN_EXT = ".inv";
    private static final String DAT_EXT = ".dat";
    private static final String IDX_EXT = ".ncsx";
    private static final String MAGIC_START = "GhncmIndex";
    private static final int version = 1;
    private HashMap<Long, StationIndex> map = new HashMap(10000);
    private TableParser.Field stnIdFromData;
    private StructureMembers stnDataMembers;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        String dataFile = raf.getLocation();
        int pos = dataFile.lastIndexOf(".");
        if (pos <= 0) {
            return false;
        }
        String base = dataFile.substring(0, pos);
        String ext = dataFile.substring(pos);
        if (!ext.equals(DAT_EXT) && !ext.equals(IDX_EXT)) {
            return false;
        }
        if (ext.equals(IDX_EXT)) {
            File datFile = new File(base + DAT_EXT);
            if (!datFile.exists()) {
                return false;
            }
            File stnFile = new File(base + STN_EXT);
            if (!stnFile.exists()) {
                return false;
            }
            raf.seek(0L);
            byte[] b = new byte[MAGIC_START.length()];
            raf.read(b);
            String test = new String(b, "UTF-8");
            return test.equals(MAGIC_START);
        }
        File stnFile = new File(base + STN_EXT);
        return stnFile.exists();
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.stnRaf != null) {
            this.stnRaf.close();
        }
        this.raf = null;
        this.stnRaf = null;
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.ncfile = ncfile;
        String dataFile = raf.getLocation();
        int pos = dataFile.lastIndexOf(".");
        String base = dataFile.substring(0, pos);
        String ext = dataFile.substring(pos);
        if (ext.equals(IDX_EXT)) {
            File datFile = new File(base + DAT_EXT);
            if (!datFile.exists()) {
                throw new FileNotFoundException(datFile.getPath() + " must exist");
            }
            File stnFile = new File(base + STN_EXT);
            if (!stnFile.exists()) {
                throw new FileNotFoundException(stnFile.getPath() + " must exist");
            }
            this.raf = new RandomAccessFile(base + DAT_EXT, "r");
            this.stnRaf = new RandomAccessFile(base + STN_EXT, "r");
            this.readIndex(raf.getLocation());
            raf.close();
        } else {
            this.raf = raf;
            if (!ext.equals(DAT_EXT)) {
                throw new FileNotFoundException("Ghcnm: file must end with .dat");
            }
            File stnFile = new File(base + STN_EXT);
            if (!stnFile.exists()) {
                throw new FileNotFoundException(stnFile.getPath() + " must exist");
            }
            this.stnRaf = new RandomAccessFile(base + STN_EXT, "r");
        }
        TableParser dataParser = new TableParser("11L,15i,19,24i,25,26,27");
        Sequence dataSeq = new Sequence(ncfile, null, null, RECORD);
        ncfile.addVariable(null, dataSeq);
        ncfile.addDimension(null, new Dimension(DIM_NAME, 12));
        this.makeMember(dataSeq, STNID, DataType.LONG, null, "station stnId", null, null, null);
        this.makeMember(dataSeq, YEAR, DataType.INT, null, "year of the station record", null, null, null);
        Variable v = this.makeMember(dataSeq, VALUE, DataType.FLOAT, DIM_NAME, "monthly mean temperature", "Celsius", null, null);
        v.addAttribute(new Attribute("missing_value", -9999));
        dataParser.getField(3).setScale(0.01f);
        this.makeMember(dataSeq, DMFLAG, DataType.CHAR, DIM_NAME, "data management flag", null, null, null);
        this.makeMember(dataSeq, QCFLAG, DataType.CHAR, DIM_NAME, "quality control flag", null, null, null);
        this.makeMember(dataSeq, DSFLAG, DataType.CHAR, DIM_NAME, "data source flag", null, null, null);
        v = this.makeMember(dataSeq, TIME, DataType.STRING, null, "starting time of the record", null, null, AxisType.Time);
        v.addAttribute(new Attribute("missing_value", "missing"));
        StructureMembers dataSm = dataSeq.makeStructureMembers();
        dataSm.findMember(STNID).setDataObject(dataParser.getField(0));
        dataSm.findMember(YEAR).setDataObject(dataParser.getField(1));
        dataSm.findMember(VALUE).setDataObject(dataParser.getField(3));
        dataSm.findMember(DMFLAG).setDataObject(dataParser.getField(4));
        dataSm.findMember(QCFLAG).setDataObject(dataParser.getField(5));
        dataSm.findMember(DSFLAG).setDataObject(dataParser.getField(6));
        dataSeq.setSPobject(new Vinfo(this.raf, dataSm));
        this.stnIdFromData = dataParser.getField(0);
        TableParser.Field org = dataParser.getField(1);
        TableParser.DerivedField derived = dataParser.addDerivedField(org, new TableParser.Transform(){

            @Override
            public Object derive(Object org) {
                int year = (Integer)org;
                return year + "-01-01T00:00:00Z";
            }
        }, String.class);
        dataSm.findMember(TIME).setDataObject(derived);
        TableParser stnParser = new TableParser("11L,20d,30d,37d,68,73i,74,79i,81,83,85,87i,88,90i,106,107");
        Sequence stnSeq = new Sequence(ncfile, null, null, STNS);
        ncfile.addVariable(null, stnSeq);
        v = this.makeMember(stnSeq, STNID, DataType.LONG, null, "station id", null, null, null);
        v.addAttribute(new Attribute("cf_role", "timeseries_id"));
        this.makeMember(stnSeq, LAT, DataType.FLOAT, null, "latitude", "degrees_north", null, null);
        this.makeMember(stnSeq, LON, DataType.FLOAT, null, "longitude", "degrees_east", null, null);
        this.makeMember(stnSeq, STELEV, DataType.FLOAT, null, STELEV, "m", null, null);
        v = this.makeMember(stnSeq, NAME, DataType.STRING, null, "station name", null, null, null);
        v.addAttribute(new Attribute("standard_name", "station_description"));
        this.makeMember(stnSeq, GRELEV, DataType.INT, null, "elevation estimated from gridded digital terrain data", "m", null, null);
        this.makeMember(stnSeq, POPCLS, DataType.CHAR, null, "population class", null, null, null);
        v = this.makeMember(stnSeq, POPSIZ, DataType.INT, null, "population of the city or town the station is located in", "thousands of persons", null, null);
        v.addAttribute(new Attribute("missing_value", -9));
        this.makeMember(stnSeq, TOPO, DataType.STRING, null, "type of topography in the environment surrounding the station", null, null, null);
        this.makeMember(stnSeq, "vegType", DataType.STRING, null, "type of vegetation in environment of station", null, null, null);
        this.makeMember(stnSeq, STLOC, DataType.STRING, null, "station is near lake or ocean", null, null, null);
        v = this.makeMember(stnSeq, OCNDIS, DataType.INT, null, "distance to nearest ocean/lake", "km", null, null);
        v.addAttribute(new Attribute("missing_value", -9));
        this.makeMember(stnSeq, AIRSTN, DataType.CHAR, null, "airport station indicator", null, null, null);
        v = this.makeMember(stnSeq, TOWNDIS, DataType.INT, null, "distance from airport to center of associated city or town", "km", null, null);
        v.addAttribute(new Attribute("missing_value", -9));
        this.makeMember(stnSeq, "vegType", DataType.STRING, null, "vegetation type at nearest 0.5 deg x 0.5 deg gridded data point of vegetation dataset", null, null, null);
        this.makeMember(stnSeq, POPCSS, DataType.CHAR, null, "population class as determined by satellite night lights", null, null, null);
        Sequence nestedSeq = new Sequence(ncfile, null, stnSeq, STN_DATA);
        stnSeq.addMemberVariable(nestedSeq);
        v = this.makeMember(nestedSeq, YEAR, DataType.INT, null, YEAR, null, null, null);
        v.addAttribute(new Attribute("units", "years since 0000-01-01T00:00"));
        v = this.makeMember(nestedSeq, VALUE, DataType.FLOAT, DIM_NAME, "monthly mean temperature", "Celsius", null, null);
        v.addAttribute(new Attribute("missing_value", -9999));
        dataParser.getField(3).setScale(0.01f);
        this.makeMember(nestedSeq, DMFLAG, DataType.CHAR, DIM_NAME, "data management flag", null, null, null);
        this.makeMember(nestedSeq, QCFLAG, DataType.CHAR, DIM_NAME, "quality control flag", null, null, null);
        this.makeMember(nestedSeq, DSFLAG, DataType.CHAR, DIM_NAME, "data source flag", null, null, null);
        v = this.makeMember(nestedSeq, TIME, DataType.STRING, null, "starting time of the record", null, null, AxisType.Time);
        v.addAttribute(new Attribute("missing_value", "missing"));
        StructureMembers nestedSm = nestedSeq.makeStructureMembers();
        nestedSm.findMember(YEAR).setDataObject(dataParser.getField(1));
        nestedSm.findMember(VALUE).setDataObject(dataParser.getField(3));
        nestedSm.findMember(DMFLAG).setDataObject(dataParser.getField(4));
        nestedSm.findMember(QCFLAG).setDataObject(dataParser.getField(5));
        nestedSm.findMember(DSFLAG).setDataObject(dataParser.getField(6));
        nestedSeq.setSPobject(new Vinfo(this.raf, nestedSm));
        this.stnDataMembers = nestedSm;
        TableParser.Field org2 = dataParser.getField(1);
        TableParser.DerivedField derived2 = dataParser.addDerivedField(org2, new TableParser.Transform(){

            @Override
            public Object derive(Object org) {
                int year = (Integer)org;
                return year + "-01-01T00:00:00Z";
            }
        }, String.class);
        nestedSm.findMember(TIME).setDataObject(derived2);
        v = this.makeMember(stnSeq, WMO, DataType.INT, null, "WMO station id", null, null, null);
        v.addAttribute(new Attribute("missing_value", -9999));
        v.addAttribute(new Attribute("standard_name", "station_WMO_id"));
        StructureMembers stnSm = stnSeq.makeStructureMembers();
        int count = 0;
        int n = stnParser.getNumberOfFields();
        for (StructureMembers.Member m : stnSm.getMembers()) {
            if (count >= n) continue;
            m.setDataObject(stnParser.getField(count++));
        }
        stnSeq.setSPobject(new Vinfo(this.stnRaf, stnSm));
        TableParser.Field org3 = stnParser.getField(0);
        TableParser.DerivedField derived3 = stnParser.addDerivedField(org3, new TableParser.Transform(){

            @Override
            public Object derive(Object org) {
                long stnid = (Long)org;
                return stnid % 1000L == 0L ? new Integer((int)(stnid / 1000L) % 100000) : new Integer(-9999);
            }
        }, Integer.TYPE);
        stnSm.findMember(WMO).setDataObject(derived3);
        ncfile.addAttribute(null, new Attribute("title", "Version 3 of the GHCN-Monthly dataset of land surface mean temperatures"));
        ncfile.addAttribute(null, new Attribute("Conventions", "CDM"));
        ncfile.addAttribute(null, new Attribute("CF:featureType", "timeSeries"));
        ncfile.addAttribute(null, new Attribute("see", "http://www.ncdc.noaa.gov/ghcnm, ftp://ftp.ncdc.noaa.gov/pub/data/ghcn/v3"));
        ncfile.finish();
        File idxFile = new File(base + IDX_EXT);
        if (!idxFile.exists()) {
            this.makeIndex(idxFile);
        } else {
            this.readIndex(idxFile.getPath());
        }
    }

    private Variable makeMember(Structure s, String shortName, DataType dataType, String dims, String longName, String units, String cfName, AxisType atype) {
        Variable v = new Variable(this.ncfile, null, s, shortName, dataType, dims);
        v.addAttribute(new Attribute("long_name", longName));
        if (cfName != null) {
            v.addAttribute(new Attribute("standard_name", cfName));
        }
        if (units != null) {
            v.addAttribute(new Attribute("units", units));
        }
        if (atype != null) {
            v.addAttribute(new Attribute("_CoordinateAxisType", atype.toString()));
        }
        s.addMemberVariable(v);
        return v;
    }

    private void readIndex(String indexFilename) throws IOException {
        FileInputStream fin = new FileInputStream(indexFilename);
        if (!NcStream.readAndTest(fin, MAGIC_START.getBytes("UTF-8"))) {
            throw new IllegalStateException("bad index file");
        }
        int version = fin.read();
        if (version != 1) {
            throw new IllegalStateException("Bad version = " + version);
        }
        int count = NcStream.readVInt(fin);
        for (int i = 0; i < count; ++i) {
            int size = NcStream.readVInt(fin);
            byte[] pb = new byte[size];
            NcStream.readFully(fin, pb);
            StationIndex si = this.decodeStationIndex(pb);
            this.map.put(si.stnId, si);
        }
        fin.close();
        System.out.println(" read index map size=" + this.map.values().size());
    }

    private void makeIndex(File indexFile) throws IOException {
        Sequence stnSeq = (Sequence)this.ncfile.findVariable(STNS);
        Vinfo stnInfo = (Vinfo)stnSeq.getSPobject();
        StructureMembers.Member m = stnInfo.sm.findMember(STNID);
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        int stnCount = 0;
        stnInfo.raf.seek(0L);
        while (true) {
            long stnPos = stnInfo.raf.getFilePointer();
            String line = stnInfo.raf.readLine();
            if (line == null) break;
            StationIndex s = new StationIndex();
            Long id = (Long)f.parse(line);
            this.map.put(id, s);
            s.stnId = id;
            s.stnPos = stnPos;
            ++stnCount;
        }
        Sequence dataSeq = (Sequence)this.ncfile.findVariable(RECORD);
        Vinfo dataInfo = (Vinfo)dataSeq.getSPobject();
        m = dataInfo.sm.findMember(STNID);
        f = (TableParser.Field)m.getDataObject();
        StationIndex currStn = null;
        int totalCount = 0;
        dataInfo.raf.seek(0L);
        while (true) {
            long dataPos = dataInfo.raf.getFilePointer();
            String line = dataInfo.raf.readLine();
            if (line == null) break;
            Long id = (Long)f.parse(line);
            if (currStn == null || currStn.stnId != id) {
                StationIndex s = this.map.get(id);
                if (s == null) {
                    System.out.printf("Cant find %d%n", id);
                } else if (s.dataCount != 0) {
                    System.out.printf("Not in order %d at pos %d %n", id, dataPos);
                } else {
                    s.dataPos = dataPos;
                    ++totalCount;
                }
                currStn = s;
            }
            ++currStn.dataCount;
        }
        FileOutputStream fout = new FileOutputStream(indexFile);
        long size = 0L;
        fout.write(MAGIC_START.getBytes("UTF-8"));
        fout.write(1);
        size += (long)NcStream.writeVInt(fout, stnCount);
        for (StationIndex s : this.map.values()) {
            byte[] pb = s.encodeStationProto();
            size += (long)NcStream.writeVInt(fout, pb.length);
            size += (long)pb.length;
            fout.write(pb);
        }
        fout.close();
    }

    private StationIndex decodeStationIndex(byte[] data) throws InvalidProtocolBufferException {
        GhcnmProto.StationIndex proto = GhcnmProto.StationIndex.parseFrom(data);
        return new StationIndex(proto);
    }

    @Override
    public String getFileTypeId() {
        return "GHCNM";
    }

    @Override
    public String getFileTypeDescription() {
        return "GLOBAL HISTORICAL CLIMATOLOGY NETWORK MONTHLY";
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Vinfo vinfo = (Vinfo)v2.getSPobject();
        return new ArraySequence(vinfo.sm, new SeqIter(vinfo), vinfo.nelems);
    }

    @Override
    public StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        Vinfo vinfo = (Vinfo)s.getSPobject();
        return new SeqIter(vinfo);
    }

    private static NetcdfFile open(String filename) throws IOException {
        Ghcnm iosp = new Ghcnm();
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        MyNetcdfFile ncfile = new MyNetcdfFile(iosp);
        iosp.open(raf, ncfile, null);
        return ncfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stnDuplicates(String filename, Set<Integer> stns, boolean wantDups) throws IOException {
        System.out.printf("%s%n", filename);
        int count = 0;
        int countDups = 0;
        NetcdfFile ncfile = Ghcnm.open(filename);
        Sequence seq = (Sequence)ncfile.findVariable(STNS);
        StructureDataIterator iter = seq.getStructureIterator(-1);
        try {
            while (iter.hasNext()) {
                StructureMembers.Member m;
                ++count;
                StructureData sdata = iter.next();
                int stnid = sdata.getScalarInt(m = sdata.findMember(STNID));
                if (stns.contains(stnid)) {
                    ++countDups;
                    if (wantDups) continue;
                    System.out.printf("  dup %d%n", stnid);
                    continue;
                }
                stns.add(stnid);
                if (!wantDups) continue;
                System.out.printf("  dup %d%n", stnid);
            }
        }
        finally {
            iter.finish();
        }
        System.out.printf(" counts=%d dups=%d%n", count, countDups);
    }

    public static void main2(String[] args) throws IOException {
        HashSet<Integer> stns = new HashSet<Integer>(10000);
        Ghcnm.stnDuplicates("C:/data/ghcnm/ghcnm.v3.0.0-beta1.20101207.qae.inv", stns, false);
        Ghcnm.stnDuplicates("C:/data/ghcnm/ghcnm.v3.0.0-beta1.20101207.qca.inv", stns, true);
        Ghcnm.stnDuplicates("C:/data/ghcnm/ghcnm.v3.0.0-beta1.20101207.qcu.inv", stns, true);
    }

    private static int parseLine(String line) throws IOException {
        int balony = 0;
        Matcher matcher = dataPattern.matcher(line);
        if (matcher.matches()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String r = matcher.group(i);
                if (r == null) continue;
                int value = (int)Long.parseLong(r.trim());
                balony += value;
            }
        } else {
            System.out.printf("Fail on %s%n", line);
        }
        return balony;
    }

    private static void readDataRegexp(String filename) throws IOException {
        String line;
        int balony = 0;
        long start = System.currentTimeMillis();
        System.out.printf("regexp %s%n", filename);
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        while ((line = raf.readLine()) != null) {
            if (line.startsWith("#") || line.trim().length() == 0) continue;
            balony += Ghcnm.parseLine(line);
        }
        long took = System.currentTimeMillis() - start;
        System.out.printf("DONE %d == %d msecs%n", balony, took);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readData(String filename) throws IOException {
        long start = System.currentTimeMillis();
        System.out.printf("%s%n", filename);
        int balony = 0;
        NetcdfFile ncfile = Ghcnm.open(filename);
        Sequence seq = (Sequence)ncfile.findVariable(RECORD);
        StructureDataIterator iter = seq.getStructureIterator(-1);
        try {
            while (iter.hasNext()) {
                StructureData sdata = iter.next();
                StructureMembers.Member m = sdata.findMember(YEAR);
                balony += sdata.getScalarInt(m);
            }
        }
        finally {
            iter.finish();
        }
        long took = System.currentTimeMillis() - start;
        System.out.printf("DONE %d == %d msecs%n", balony, took);
    }

    public static void main(String[] args) throws IOException {
        Ghcnm.readData("C:/data/ghcnm/ghcnm.v3.0.0-beta1.20101207.qcu.dat");
        Ghcnm.readDataRegexp("C:/data/ghcnm/ghcnm.v3.0.0-beta1.20101207.qcu.dat");
    }

    private static class MyNetcdfFile
    extends NetcdfFile {
        MyNetcdfFile(Ghcnm iosp) {
            this.spi = iosp;
        }
    }

    private class StructureDataAsciiGhcnm
    extends StructureDataAscii {
        StructureDataAsciiGhcnm(StructureMembers members, String line) {
            super(members, line);
        }

        @Override
        public ArraySequence getArraySequence(StructureMembers.Member m) {
            Long stnId = (Long)Ghcnm.this.stnIdFromData.parse(this.line);
            StationIndex si = (StationIndex)Ghcnm.this.map.get(stnId);
            return new ArraySequence(Ghcnm.this.stnDataMembers, new StnDataIter(Ghcnm.this.stnDataMembers, si), -1);
        }
    }

    private class StnDataIter
    implements StructureDataIterator {
        private StructureMembers sm;
        private int countRead;
        private StationIndex stationIndex;

        StnDataIter(StructureMembers sm, StationIndex stationIndex) {
            this.sm = sm;
            this.stationIndex = stationIndex;
            this.reset();
        }

        @Override
        public StructureDataIterator reset() {
            this.countRead = 0;
            try {
                Ghcnm.this.raf.seek(this.stationIndex.dataPos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.countRead < this.stationIndex.dataCount;
        }

        @Override
        public StructureData next() throws IOException {
            String line;
            do {
                if ((line = Ghcnm.this.raf.readLine()) != null) continue;
                return null;
            } while (line.startsWith("#") || line.trim().length() == 0);
            ++this.countRead;
            return new StructureDataAscii(this.sm, line);
        }

        @Override
        public void setBufferSize(int bytes) {
        }

        @Override
        public int getCurrentRecno() {
            return this.countRead - 1;
        }

        @Override
        public void finish() {
        }
    }

    private class SeqIter
    implements StructureDataIterator {
        private Vinfo vinfo;
        private long bytesRead;
        private long totalBytes;
        private int recno;
        private StructureData curr;

        SeqIter(Vinfo vinfo) throws IOException {
            this.vinfo = vinfo;
            this.totalBytes = (int)Ghcnm.this.raf.length();
            vinfo.raf.seek(0L);
        }

        @Override
        public StructureDataIterator reset() {
            this.bytesRead = 0L;
            this.recno = 0;
            try {
                this.vinfo.raf.seek(0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            boolean more;
            boolean bl = more = this.bytesRead < this.totalBytes;
            if (!more) {
                this.vinfo.nelems = this.recno;
                return false;
            }
            this.curr = this.reallyNext();
            boolean bl2 = more = this.curr != null;
            if (!more) {
                this.vinfo.nelems = this.recno;
                return false;
            }
            return more;
        }

        @Override
        public StructureData next() throws IOException {
            return this.curr;
        }

        private StructureData reallyNext() throws IOException {
            String line;
            do {
                if ((line = this.vinfo.raf.readLine()) != null) continue;
                return null;
            } while (line.startsWith("#") || line.trim().length() == 0);
            this.bytesRead = this.vinfo.raf.getFilePointer();
            ++this.recno;
            return new StructureDataAsciiGhcnm(this.vinfo.sm, line);
        }

        @Override
        public void setBufferSize(int bytes) {
        }

        @Override
        public int getCurrentRecno() {
            return this.recno - 1;
        }

        @Override
        public void finish() {
        }
    }

    private class StationIndex {
        long stnId;
        long stnPos;
        long dataPos;
        int dataCount;

        StationIndex() {
        }

        StationIndex(GhcnmProto.StationIndex proto) {
            this.stnId = proto.getStnid();
            this.stnPos = proto.getStnPos();
            this.dataPos = proto.getDataPos();
            this.dataCount = proto.getDataCount();
        }

        private byte[] encodeStationProto() {
            GhcnmProto.StationIndex.Builder builder = GhcnmProto.StationIndex.newBuilder();
            builder.setStnid(this.stnId);
            builder.setStnPos(this.stnPos);
            builder.setDataPos(this.dataPos);
            builder.setDataCount(this.dataCount);
            GhcnmProto.StationIndex proto = builder.build();
            return proto.toByteArray();
        }
    }

    private class Vinfo {
        RandomAccessFile raf;
        StructureMembers sm;
        int nelems = -1;

        private Vinfo(RandomAccessFile raf, StructureMembers sm) {
            this.sm = sm;
            this.raf = raf;
        }
    }
}

