/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import java.util.Date;
import java.util.Formatter;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class CalendarDateUnit {
    private static final String byCalendarString = "calendar ";
    private static final String udunitPatternString = "(\\w*)\\s*since\\s*([\\+\\-\\d]+)([ t]([\\.\\:\\d]*)([ \\+\\-]\\S*)?z?)?$";
    private static final Pattern udunitPattern = Pattern.compile("(\\w*)\\s*since\\s*([\\+\\-\\d]+)([ t]([\\.\\:\\d]*)([ \\+\\-]\\S*)?z?)?$");
    private final Calendar cal;
    private final String unitString;
    private final CalendarPeriod.Field periodField;
    private final CalendarDate baseDate;
    private final boolean isCalendarField;
    private static final String isodatePatternString = "([\\+\\-\\d]*)[ Tt]([\\.\\:\\d]*)([ \\+\\-]\\S*)?$";
    private static final Pattern isodatePattern = Pattern.compile("([\\+\\-\\d]*)[ Tt]([\\.\\:\\d]*)([ \\+\\-]\\S*)?$");

    public static CalendarDateUnit of(String calendarName, String udunitString) {
        Calendar calt = Calendar.get(calendarName);
        if (calt == null) {
            calt = Calendar.getDefault();
        }
        return new CalendarDateUnit(calt, udunitString);
    }

    public static CalendarDateUnit withCalendar(Calendar calt, String udunitString) {
        if (calt == null) {
            calt = Calendar.getDefault();
        }
        return new CalendarDateUnit(calt, udunitString);
    }

    private CalendarDateUnit(Calendar calt, String dateUnitString) {
        Matcher m;
        this.cal = calt;
        dateUnitString = dateUnitString.trim();
        dateUnitString = dateUnitString.toLowerCase();
        this.isCalendarField = dateUnitString.startsWith(byCalendarString);
        if (this.isCalendarField) {
            dateUnitString = dateUnitString.substring(byCalendarString.length()).trim();
        }
        if (!(m = udunitPattern.matcher(dateUnitString)).matches()) {
            throw new IllegalArgumentException(dateUnitString + " does not match " + udunitPatternString);
        }
        this.unitString = m.group(1);
        this.periodField = CalendarPeriod.fromUnitString(this.unitString);
        DateTime dt = this.parseUdunitsTimeString(dateUnitString, m.group(2), m.group(4), m.group(5));
        this.baseDate = CalendarDate.of(this.cal, dt);
    }

    private DateTime parseUdunitsTimeString(String dateUnitString, String dateString, String timeString, String zoneString) {
        int year = 0;
        int month = 1;
        int day = 1;
        int hour = 0;
        int minute = 0;
        double second = 0.0;
        try {
            boolean isMinus = false;
            if (dateString.startsWith("-")) {
                isMinus = true;
                dateString = dateString.substring(1);
            } else if (dateString.startsWith("+")) {
                dateString = dateString.substring(1);
            }
            StringTokenizer dateTokenizer = new StringTokenizer(dateString, "-");
            if (dateTokenizer.hasMoreTokens()) {
                year = Integer.parseInt(dateTokenizer.nextToken());
            }
            if (dateTokenizer.hasMoreTokens()) {
                month = Integer.parseInt(dateTokenizer.nextToken());
            }
            if (dateTokenizer.hasMoreTokens()) {
                day = Integer.parseInt(dateTokenizer.nextToken());
            }
            if (timeString != null && timeString.length() > 0) {
                StringTokenizer timeTokenizer = new StringTokenizer(timeString, ":");
                if (timeTokenizer.hasMoreTokens()) {
                    hour = Integer.parseInt(timeTokenizer.nextToken());
                }
                if (timeTokenizer.hasMoreTokens()) {
                    minute = Integer.parseInt(timeTokenizer.nextToken());
                }
                if (timeTokenizer.hasMoreTokens()) {
                    second = Double.parseDouble(timeTokenizer.nextToken());
                }
            }
            if (isMinus) {
                year = -year;
            }
            DateTime dt = new DateTime(year, month, day, hour, minute, 0, 0, Calendar.getChronology(this.cal));
            dt = dt.plus((long)(1000.0 * second));
            if (!(zoneString == null || (zoneString = zoneString.trim()).length() <= 0 || zoneString.equals("z") || zoneString.equals("utc") || zoneString.equals("gmt"))) {
                int minuteOffset;
                isMinus = false;
                if (zoneString.startsWith("-")) {
                    isMinus = true;
                    zoneString = zoneString.substring(1);
                } else if (zoneString.startsWith("+")) {
                    zoneString = zoneString.substring(1);
                }
                StringTokenizer zoneTokenizer = new StringTokenizer(zoneString, ":");
                int hourOffset = zoneTokenizer.hasMoreTokens() ? Integer.parseInt(zoneTokenizer.nextToken()) : 0;
                int n = minuteOffset = zoneTokenizer.hasMoreTokens() ? Integer.parseInt(zoneTokenizer.nextToken()) : 0;
                if (isMinus) {
                    hourOffset = -hourOffset;
                }
                DateTimeZone dtz = DateTimeZone.forOffsetHoursMinutes((int)hourOffset, (int)minuteOffset);
                dt = dt.withZoneRetainFields(dtz);
                dt = dt.withZone(DateTimeZone.UTC);
            }
            return dt;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal base time specification: '" + dateUnitString + "'", e);
        }
    }

    private DateTime parseIsoTimeString(Chronology chronology, String dateString, String timeString, String zoneString) {
        int year = 0;
        int month = 1;
        int day = 1;
        int hour = 0;
        int minute = 0;
        double second = 0.0;
        try {
            boolean isMinus = false;
            if (dateString.startsWith("-")) {
                isMinus = true;
                dateString = dateString.substring(1);
            } else if (dateString.startsWith("+")) {
                dateString = dateString.substring(1);
            }
            StringTokenizer dateTokenizer = new StringTokenizer(dateString, "-");
            if (dateTokenizer.hasMoreTokens()) {
                year = Integer.parseInt(dateTokenizer.nextToken());
            }
            if (dateTokenizer.hasMoreTokens()) {
                month = Integer.parseInt(dateTokenizer.nextToken());
            }
            if (dateTokenizer.hasMoreTokens()) {
                day = Integer.parseInt(dateTokenizer.nextToken());
            }
            if (timeString != null && timeString.length() > 0) {
                StringTokenizer timeTokenizer = new StringTokenizer(timeString, ":");
                if (timeTokenizer.hasMoreTokens()) {
                    hour = Integer.parseInt(timeTokenizer.nextToken());
                }
                if (timeTokenizer.hasMoreTokens()) {
                    minute = Integer.parseInt(timeTokenizer.nextToken());
                }
                if (timeTokenizer.hasMoreTokens()) {
                    second = Double.parseDouble(timeTokenizer.nextToken());
                }
            }
            if (isMinus) {
                year = -year;
            }
            DateTime dt = new DateTime(year, month, day, hour, minute, 0, 0, chronology);
            dt = dt.plus((long)(1000.0 * second));
            if (!(zoneString == null || (zoneString = zoneString.trim()).length() <= 0 || zoneString.equals("Z") || zoneString.equals("UTC") || zoneString.equals("GMT"))) {
                int minuteOffset;
                isMinus = false;
                if (zoneString.startsWith("-")) {
                    isMinus = true;
                    zoneString = zoneString.substring(1);
                } else if (zoneString.startsWith("+")) {
                    zoneString = zoneString.substring(1);
                }
                StringTokenizer zoneTokenizer = new StringTokenizer(zoneString, ":");
                int hourOffset = zoneTokenizer.hasMoreTokens() ? Integer.parseInt(zoneTokenizer.nextToken()) : 0;
                int n = minuteOffset = zoneTokenizer.hasMoreTokens() ? Integer.parseInt(zoneTokenizer.nextToken()) : 0;
                if (isMinus) {
                    hourOffset = -hourOffset;
                }
                DateTimeZone dtz = DateTimeZone.forOffsetHoursMinutes((int)hourOffset, (int)minuteOffset);
                dt = dt.withZoneRetainFields(dtz);
                dt = dt.withZone(DateTimeZone.UTC);
            }
            return dt;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal base time specification: '" + dateString + "' " + e.getMessage());
        }
    }

    public CalendarDate makeCalendarDate(double value) {
        if (this.isCalendarField) {
            return this.baseDate.add(CalendarPeriod.of((int)value, this.periodField));
        }
        return this.baseDate.add(value, this.periodField);
    }

    public CalendarDate makeCalendarDate(int value) {
        if (this.isCalendarField) {
            return this.baseDate.add(CalendarPeriod.of(value, this.periodField));
        }
        return this.baseDate.add(value, this.periodField);
    }

    public String toString() {
        Formatter f = new Formatter();
        if (this.isCalendarField) {
            f.format("%s", byCalendarString);
        }
        f.format("%s since %s", this.unitString, CalendarDateFormatter.toDateTimeString(this.baseDate));
        return f.toString();
    }

    public CalendarDate getBaseCalendarDate() {
        return this.baseDate;
    }

    public CalendarPeriod getTimeUnit() {
        return CalendarPeriod.of(1, CalendarPeriod.fromUnitString(this.unitString));
    }

    public Calendar getCalendar() {
        return this.cal;
    }

    public boolean isCalendarField() {
        return this.isCalendarField;
    }

    Date getBaseDate() {
        return this.baseDate.toDate();
    }

    public static void main(String[] args) {
        String s = "calendar Month since 2012-01-19T18:00:00.000Z";
        CalendarDateUnit cdu = CalendarDateUnit.of(null, s);
        System.out.printf("%s == %s%n", s, cdu);
    }
}

