/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthState;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.util.net.HTTPAuthScheme;
import ucar.nc2.util.net.HTTPAuthStore;
import ucar.nc2.util.net.HTTPMethod;

public class HTTPAuthProvider
implements Serializable,
CredentialsProvider {
    static final int MAX_RETRIES = 3;
    static final String PRINCIPAL = "ucar.nc2.principal";
    static final String URI = "ucar.nc2.url";
    static final String CREDENTIALSPROVIDER = "ucar.nc2.credentialsprovider";
    static final String KEYSTOREPATH = "ucar.nc2.keystore";
    static final String KEYSTOREPASSWORD = "ucar.nc2.keystorepassword";
    static final String TRUSTSTOREPATH = "ucar.nc2.truststore";
    static final String TRUSTSTOREPASSWORD = "ucar.nc2.truststorepassword";
    static final String CREDENTIALS = "ucar.nc2.credentials";
    static final String AUTHSTRING = "ucar.nc2.authstring";
    static String SCHEME = "ucar.nc2.scheme";
    static String PASSWORD = "ucar.nc2.password";
    static String USER = "ucar.nc2.user";
    public static final String WWW_AUTH_RESP = "Authorization";
    public static final String PROXY_AUTH_RESP = "Proxy-Authorization";
    private static Logger LOG = LoggerFactory.getLogger(HTTPAuthProvider.class);
    String url = null;
    HTTPMethod method = null;
    int retryCount;

    public HTTPAuthProvider(String url, HTTPMethod method) {
        this.url = url;
        this.method = method;
        this.retryCount = 3;
    }

    public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean isproxy) throws CredentialsNotAvailableException {
        AuthState authstate = this.method.getMethod().getHostAuthState();
        if (this.retryCount == 0 && authstate.isAuthAttempted() && authscheme.isComplete()) {
            return null;
        }
        --this.retryCount;
        Credentials credentials = null;
        HTTPAuthScheme scheme = isproxy ? HTTPAuthScheme.PROXY : HTTPAuthScheme.schemeForName(authscheme.getSchemeName());
        if (scheme == null) {
            LOG.error("HTTPAuthProvider: unsupported scheme: " + authscheme.getSchemeName());
            return null;
        }
        HTTPAuthStore.Entry[] matches = HTTPAuthStore.search(new HTTPAuthStore.Entry(scheme, this.url, null));
        if (matches.length == 0) {
            LOG.debug("HTTPAuthProvider: no match for (" + (Object)((Object)scheme) + "," + this.url + ")");
            return null;
        }
        HTTPAuthStore.Entry entry = matches[0];
        LOG.debug("HTTPAuthProvider: AuthStore row: " + entry.toString());
        CredentialsProvider provider = entry.creds;
        if (provider == null) {
            LOG.debug("HTTPAuthProvider: no credentials provider provided");
            return null;
        }
        credentials = provider.getCredentials(authscheme, host, port, isproxy);
        if (credentials == null) {
            LOG.debug("HTTPAuthProvider: cannot obtain credentials");
            return null;
        }
        return credentials;
    }

    public String toString() {
        return "HTTPAuthProvider(" + this.url + ")";
    }

    private void writeObject(ObjectOutputStream ostream) throws IOException {
        ostream.writeObject(this.url);
    }

    private void readObject(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        this.url = (String)istream.readObject();
    }
}

