/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.rc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ucar.nc2.util.log.LogStream;

public class RC {
    protected static boolean useGroups = true;
    protected static boolean verifyServer = false;
    protected static boolean allowSelfSigned = true;
    static final String DFALTRCFILE = ".threddsrc";
    static final char LTAG = '[';
    static final char RTAG = ']';
    static final String[] rcfilelist = new String[]{".dodsrc", ".tdsrc"};
    static RC dfaltRC = null;
    private static boolean initialized = false;
    Map<String, List<Triple>> triplestore = new HashMap<String, List<Triple>>();

    public static boolean getUseGroups() {
        if (!initialized) {
            RC.initialize();
        }
        return useGroups;
    }

    public static boolean getVerifyServer() {
        if (!initialized) {
            RC.initialize();
        }
        return verifyServer;
    }

    public static boolean getAllowSelfSigned() {
        if (!initialized) {
            RC.initialize();
        }
        return allowSelfSigned;
    }

    protected static void set(String key, String value) {
        assert (key != null && value != null);
        if ("ucar.nc2.cdm.usegroups".equals(key)) {
            useGroups = RC.booleanize(value);
        } else if ("ucar.nc2.net.verifyserver".equals(key)) {
            verifyServer = RC.booleanize(value);
        } else if ("ucar.nc2.net.allowselfsigned".equals(key)) {
            allowSelfSigned = RC.booleanize(value);
        }
    }

    static boolean booleanize(String value) {
        if (value == null || "0".equals(value) || "false".equalsIgnoreCase(value)) {
            return false;
        }
        if ("1".equals(value) || "true".equalsIgnoreCase(value)) {
            return true;
        }
        return value != null;
    }

    static int urlCompare(URL u1, URL u2) {
        String host2;
        if (u1 == null && u2 == null) {
            return 0;
        }
        if (u1 == null) {
            return -1;
        }
        if (u2 == null) {
            return 1;
        }
        String host1 = new StringBuilder(u1.getHost()).reverse().toString();
        int relation = host1.compareTo(host2 = new StringBuilder(u2.getHost()).reverse().toString());
        if (relation != 0) {
            return relation;
        }
        relation = u1.getPath().compareTo(u2.getPath());
        if (relation != 0) {
            return relation;
        }
        relation = u1.getPort() - u2.getPort();
        if (relation != 0) {
            return relation;
        }
        return 0;
    }

    static boolean urlMatch(URL pattern, URL url) {
        if (pattern == null) {
            return url == null;
        }
        if (!url.getHost().endsWith(pattern.getHost())) {
            return false;
        }
        if (!url.getPath().startsWith(pattern.getPath())) {
            return false;
        }
        return pattern.getPort() <= 0 || pattern.getPort() == url.getPort();
    }

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            RC.loadDefaults();
            RC.setWellKnown();
        }
    }

    public static synchronized void add(String key, String value, String url) {
        if (key == null) {
            return;
        }
        if (!initialized) {
            RC.initialize();
        }
        Triple t = new Triple(key, value, url);
        dfaltRC.insert(t);
        RC.setWellKnown();
    }

    public static synchronized String find(String key, String url) {
        Triple t;
        if (key == null) {
            return null;
        }
        if (!initialized) {
            RC.initialize();
        }
        return (t = dfaltRC.lookup(key, url)) == null ? null : t.value;
    }

    static void setWellKnown() {
        if (RC.dfaltRC.triplestore.size() == 0) {
            return;
        }
        for (String key : dfaltRC.keySet()) {
            Triple triple = dfaltRC.lookup(key);
            if (triple.url != null) continue;
            RC.set(key, triple.value);
        }
    }

    static void loadDefaults() {
        RC rc0 = new RC();
        String[] locations = new String[]{System.getProperty("user.home"), System.getProperty("user.dir")};
        boolean found1 = false;
        for (String loc : locations) {
            if (loc == null) continue;
            String dir = loc.replace('\\', '/');
            if (dir.endsWith("/")) {
                dir = dir.substring(0, dir.length() - 1);
            }
            for (String rcpath : rcfilelist) {
                String filepath = loc + "/" + rcpath;
                if (!rc0.load(filepath)) continue;
                found1 = true;
            }
        }
        if (!found1) {
            LogStream.getLog().info("No .rc file found");
        }
        dfaltRC = rc0;
    }

    static RC getDefault() {
        return dfaltRC;
    }

    public boolean load(String abspath) {
        File rcFile = new File(abspath = abspath.replace('\\', '/'));
        if (!rcFile.exists() || !rcFile.canRead()) {
            return false;
        }
        LogStream.getLog().info("Loading rc file: " + abspath);
        FileReader frdr = null;
        try {
            frdr = new FileReader(rcFile);
        }
        catch (FileNotFoundException fe) {
            LogStream.getLog().info("Loading rc file: " + abspath);
            return false;
        }
        BufferedReader rdr = new BufferedReader(frdr);
        try {
            int lineno = 1;
            while (true) {
                URL url = null;
                String line = rdr.readLine();
                if (line == null) break;
                if ((line = line.trim()).length() != 0 && line.charAt(0) != '#') {
                    if (line.charAt(0) == '[') {
                        int rindex = line.indexOf(93);
                        if (rindex < 0) {
                            return false;
                        }
                        LogStream.getLog().error("Malformed [url] at " + abspath + "." + lineno);
                        String surl = line.substring(1, rindex);
                        try {
                            url = new URL(surl);
                        }
                        catch (MalformedURLException mue) {
                            LogStream.getLog().error("Malformed [url] at " + abspath + "." + lineno);
                        }
                        line = line.substring(rindex + 1);
                        line = line.trim();
                    }
                    String[] pieces = line.split("\\s*=\\s*");
                    assert (pieces.length == 1 || pieces.length == 2);
                    String value = "1";
                    if (pieces.length == 2) {
                        value = pieces[1].trim();
                    }
                    Triple triple = new Triple(pieces[0].trim(), value, url);
                    List<Triple> list = this.triplestore.get(triple.key);
                    if (list == null) {
                        list = new ArrayList<Triple>();
                    }
                    Triple prev = this.addtriple(list, triple);
                    this.triplestore.put(triple.key, list);
                }
                ++lineno;
            }
            rdr.close();
            frdr.close();
        }
        catch (IOException ioe) {
            LogStream.getLog().error("File " + abspath + ": IO exception: " + ioe.getMessage());
            return false;
        }
        return true;
    }

    public Set<String> keySet() {
        return this.triplestore.keySet();
    }

    public List<Triple> getTriples(String key) {
        List<Triple> list = this.triplestore.get(key);
        if (list == null) {
            list = new ArrayList<Triple>();
        }
        return list;
    }

    public Triple lookup(String key) {
        return this.lookup(key, (URL)null);
    }

    public Triple lookup(String key, String url) {
        if (url == null || url.length() == 0) {
            return this.lookup(key);
        }
        try {
            URL u = new URL(url);
            return this.lookup(key, u);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Triple lookup(String key, URL url) {
        List<Triple> list = this.triplestore.get(key);
        if (list == null) {
            return null;
        }
        if (url == null) {
            if (list.size() == 0) {
                return null;
            }
            return list.get(0);
        }
        for (Triple t : list) {
            if (!RC.urlMatch(t.url, url)) continue;
            return t;
        }
        return null;
    }

    Triple addtriple(List<Triple> list, Triple triple) {
        Triple prev = null;
        assert (list != null);
        int i = list.indexOf(triple);
        if (i >= 0) {
            prev = list.remove(i);
        }
        list.add(triple);
        Collections.sort(list);
        return prev;
    }

    public Triple insert(Triple t) {
        if (t.key == null) {
            return null;
        }
        List<Triple> list = this.triplestore.get(t.key);
        if (list == null) {
            list = new ArrayList<Triple>();
        }
        Triple prev = this.addtriple(list, t);
        this.triplestore.put(t.key, list);
        return prev;
    }

    public String toString() {
        StringBuilder rc = new StringBuilder();
        for (String key : this.keySet()) {
            List<Triple> list = this.getTriples(key);
            for (Triple triple : list) {
                String line = triple.toString();
                rc.append(line);
                rc.append("\n");
            }
        }
        return rc.toString();
    }

    static {
        RC.initialize();
    }

    public static class Triple
    implements Comparable {
        public String key;
        public String value;
        public URL url;

        public Triple(String key, String value, String url) {
            URL u = null;
            if (url != null && url.length() > 0) {
                try {
                    u = new URL(url);
                }
                catch (MalformedURLException e) {
                    u = null;
                }
            }
            this.set(key, value, u);
        }

        public Triple(String key, String value, URL url) {
            this.set(key, value, url);
        }

        void set(String key, String value, URL url) {
            this.key = key.trim().toLowerCase();
            this.url = url;
            this.value = value;
            if (this.value == null) {
                this.value = "";
            }
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Triple)) {
                return false;
            }
            return this.compareTo((Triple)o) == 0;
        }

        public int compareTo(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            Triple t = (Triple)o;
            int relation = this.key.compareTo(t.key);
            if (relation != 0) {
                return relation;
            }
            relation = RC.urlCompare(this.url, t.url);
            return relation;
        }

        public String toString() {
            StringBuilder line = new StringBuilder();
            if (this.url != null) {
                line.append("[");
                line.append(this.url.toString());
                line.append("]");
            }
            line.append(this.key);
            line.append("=");
            line.append(this.value);
            return line.toString();
        }
    }
}

