/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.Format;
import ucar.unidata.util.Parameter;

public abstract class ProjectionImpl
implements Projection,
Serializable {
    public static final String ATTR_NAME = "grid_mapping_name";
    public static final double EARTH_RADIUS = Earth.getRadius() * 0.001;
    public static final int INDEX_LAT = 0;
    public static final int INDEX_LON = 1;
    public static final int INDEX_X = 0;
    public static final int INDEX_Y = 1;
    protected static final double TOLERANCE = 1.0E-6;
    public static final double PI = Math.PI;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double PI_OVER_4 = 0.7853981633974483;
    protected final String name;
    protected final boolean isLatLon;
    protected final List<Parameter> atts = new ArrayList<Parameter>();
    protected ProjectionRect defaultMapArea = new ProjectionRect();
    private static String header = null;

    public abstract ProjectionImpl constructCopy();

    protected ProjectionImpl(String name, boolean isLatLon) {
        this.name = name;
        this.isLatLon = isLatLon;
    }

    @Override
    public String getClassName() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(".");
        if (index >= 0) {
            className = className.substring(index + 1);
        }
        return className;
    }

    @Override
    public abstract String paramsToString();

    public String getProjectionTypeLabel() {
        return this.getClassName();
    }

    @Override
    public abstract ProjectionPoint latLonToProj(LatLonPoint var1, ProjectionPointImpl var2);

    @Override
    public abstract LatLonPoint projToLatLon(ProjectionPoint var1, LatLonPointImpl var2);

    public ProjectionPoint latLonToProj(LatLonPoint latLon) {
        return this.latLonToProj(latLon, new ProjectionPointImpl());
    }

    public LatLonPoint projToLatLon(ProjectionPoint ppt) {
        return this.projToLatLon(ppt, new LatLonPointImpl());
    }

    @Override
    public abstract boolean crossSeam(ProjectionPoint var1, ProjectionPoint var2);

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Parameter> getProjectionParameters() {
        return this.atts;
    }

    protected void addParameter(String name, String value) {
        this.atts.add(new Parameter(name, value));
    }

    protected void addParameter(String name, double value) {
        this.atts.add(new Parameter(name, value));
    }

    protected void addParameter(Parameter p) {
        this.atts.add(p);
    }

    public boolean isLatLon() {
        return this.isLatLon;
    }

    public static String getHeader() {
        if (header == null) {
            StringBuilder headerB = new StringBuilder(60);
            headerB.append("Name");
            Format.tab(headerB, 20, true);
            headerB.append("Class");
            Format.tab(headerB, 40, true);
            headerB.append("Parameters");
            header = headerB.toString();
        }
        return header;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ProjectionRect getDefaultMapArea() {
        return this.defaultMapArea;
    }

    public LatLonRect getDefaultMapAreaLL() {
        return this.projToLatLonBB(this.defaultMapArea);
    }

    public void setDefaultMapArea(ProjectionRect bb) {
        if (bb == null) {
            return;
        }
        this.defaultMapArea = (ProjectionRect)bb.clone();
    }

    public ProjectionPointImpl latLonToProj(double lat, double lon) {
        return (ProjectionPointImpl)this.latLonToProj(new LatLonPointImpl(lat, lon));
    }

    public LatLonPointImpl projToLatLon(double x, double y) {
        return (LatLonPointImpl)this.projToLatLon(new ProjectionPointImpl(x, y));
    }

    public double[][] projToLatLon(double[][] from) {
        return this.projToLatLon(from, new double[2][from[0].length]);
    }

    public double[][] projToLatLon(double[][] from, double[][] to) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:from array not same length as to array");
        }
        for (int i = 0; i < from[0].length; ++i) {
            LatLonPointImpl endL = this.projToLatLon(from[0][i], from[1][i]);
            to[0][i] = endL.getLatitude();
            to[1][i] = endL.getLongitude();
        }
        return to;
    }

    public float[][] projToLatLon(float[][] from) {
        return this.projToLatLon(from, new float[2][from[0].length]);
    }

    public float[][] projToLatLon(float[][] from, float[][] to) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:from array not same length as to array");
        }
        ProjectionPointImpl ppi = new ProjectionPointImpl();
        LatLonPointImpl llpi = new LatLonPointImpl();
        for (int i = 0; i < from[0].length; ++i) {
            ppi.setLocation(from[0][i], from[1][i]);
            this.projToLatLon(ppi, llpi);
            to[0][i] = (float)llpi.getLatitude();
            to[1][i] = (float)llpi.getLongitude();
        }
        return to;
    }

    public double[][] latLonToProj(double[][] from) {
        return this.latLonToProj(from, new double[2][from[0].length]);
    }

    public double[][] latLonToProj(double[][] from, double[][] to) {
        return this.latLonToProj(from, to, 0, 1);
    }

    public double[][] latLonToProj(double[][] from, int latIndex, int lonIndex) {
        return this.latLonToProj(from, new double[2][from[0].length], latIndex, lonIndex);
    }

    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:from array not same length as to array");
        }
        ProjectionPointImpl ppi = new ProjectionPointImpl();
        LatLonPointImpl llpi = new LatLonPointImpl();
        for (int i = 0; i < from[0].length; ++i) {
            llpi.setLatitude(from[latIndex][i]);
            llpi.setLongitude(from[lonIndex][i]);
            this.latLonToProj(llpi, ppi);
            to[0][i] = ppi.getX();
            to[1][i] = ppi.getY();
        }
        return to;
    }

    public float[][] latLonToProj(float[][] from) {
        return this.latLonToProj(from, new float[2][from[0].length]);
    }

    public float[][] latLonToProj(float[][] from, float[][] to) {
        return this.latLonToProj(from, to, 0, 1);
    }

    public float[][] latLonToProj(float[][] from, int latIndex, int lonIndex) {
        return this.latLonToProj(from, new float[2][from[0].length], latIndex, lonIndex);
    }

    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:from array not same length as to array");
        }
        ProjectionPointImpl ppi = new ProjectionPointImpl();
        LatLonPointImpl llpi = new LatLonPointImpl();
        for (int i = 0; i < from[0].length; ++i) {
            llpi.setLatitude(from[latIndex][i]);
            llpi.setLongitude(from[lonIndex][i]);
            this.latLonToProj(llpi, ppi);
            to[0][i] = (float)ppi.getX();
            to[1][i] = (float)ppi.getY();
        }
        return to;
    }

    ProjectionRect latLonToProjBB2(LatLonRect latlonRect) {
        double maxy;
        double maxx;
        double miny;
        double minx;
        LatLonPointImpl llpt = latlonRect.getLowerLeftPoint();
        LatLonPointImpl urpt = latlonRect.getUpperRightPoint();
        LatLonPointImpl lrpt = latlonRect.getLowerRightPoint();
        LatLonPointImpl ulpt = latlonRect.getUpperLeftPoint();
        if (this.isLatLon()) {
            minx = this.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
            miny = Math.min(llpt.getLatitude(), lrpt.getLatitude());
            maxx = this.getMinOrMaxLon(urpt.getLongitude(), lrpt.getLongitude(), false);
            maxy = Math.min(ulpt.getLatitude(), urpt.getLatitude());
        } else {
            ProjectionPoint ll = this.latLonToProj(llpt, new ProjectionPointImpl());
            ProjectionPoint ur = this.latLonToProj(urpt, new ProjectionPointImpl());
            ProjectionPoint lr = this.latLonToProj(lrpt, new ProjectionPointImpl());
            ProjectionPoint ul = this.latLonToProj(ulpt, new ProjectionPointImpl());
            minx = Math.min(ll.getX(), ul.getX());
            miny = Math.min(ll.getY(), lr.getY());
            maxx = Math.max(ur.getX(), lr.getX());
            maxy = Math.max(ul.getY(), ur.getY());
        }
        return new ProjectionRect(minx, miny, maxx, maxy);
    }

    private double getMinOrMaxLon(double lon1, double lon2, boolean wantMin) {
        double midpoint = (lon1 + lon2) / 2.0;
        lon1 = LatLonPointImpl.lonNormal(lon1, midpoint);
        lon2 = LatLonPointImpl.lonNormal(lon2, midpoint);
        return wantMin ? Math.min(lon1, lon2) : Math.max(lon1, lon2);
    }

    public ProjectionRect latLonToProjBB(LatLonRect latlonRect) {
        if (this.isLatLon) {
            LatLonProjection llp = (LatLonProjection)this;
            llp.setCenterLon(latlonRect.getCenterLon());
        }
        ProjectionPointImpl w1 = new ProjectionPointImpl();
        ProjectionPointImpl w2 = new ProjectionPointImpl();
        LatLonPointImpl ll = latlonRect.getLowerLeftPoint();
        LatLonPointImpl ur = latlonRect.getUpperRightPoint();
        this.latLonToProj(ll, w1);
        this.latLonToProj(ur, w2);
        ProjectionRect world = new ProjectionRect(w1.getX(), w1.getY(), w2.getX(), w2.getY());
        LatLonPointImpl la = new LatLonPointImpl();
        LatLonPointImpl lb = new LatLonPointImpl();
        la.setLatitude(ur.getLatitude());
        la.setLongitude(ll.getLongitude());
        this.latLonToProj(la, w1);
        world.add(w1);
        lb.setLatitude(ll.getLatitude());
        lb.setLongitude(ur.getLongitude());
        this.latLonToProj(lb, w2);
        world.add(w2);
        return world;
    }

    public LatLonRect projToLatLonBB(ProjectionRect world) {
        ProjectionPoint min = world.getMinPoint();
        ProjectionPoint max = world.getMaxPoint();
        LatLonPointImpl llmin = new LatLonPointImpl();
        LatLonPointImpl llmax = new LatLonPointImpl();
        this.projToLatLon(min, llmin);
        this.projToLatLon(max, llmax);
        LatLonRect llbb = new LatLonRect(llmin, llmax);
        ProjectionPointImpl w1 = new ProjectionPointImpl();
        ProjectionPointImpl w2 = new ProjectionPointImpl();
        w1.setLocation(min.getX(), max.getY());
        this.projToLatLon(w1, llmin);
        llbb.extend(llmin);
        w2.setLocation(max.getX(), min.getY());
        this.projToLatLon(w2, llmax);
        llbb.extend(llmax);
        return llbb;
    }

    public LatLonRect getLatLonBoundingBox(ProjectionRect bb) {
        LatLonRect llbb;
        LatLonPointImpl llpt = (LatLonPointImpl)this.projToLatLon(bb.getLowerLeftPoint(), new LatLonPointImpl());
        LatLonPointImpl lrpt = (LatLonPointImpl)this.projToLatLon(bb.getLowerRightPoint(), new LatLonPointImpl());
        LatLonPointImpl urpt = (LatLonPointImpl)this.projToLatLon(bb.getUpperRightPoint(), new LatLonPointImpl());
        LatLonPointImpl ulpt = (LatLonPointImpl)this.projToLatLon(bb.getUpperLeftPoint(), new LatLonPointImpl());
        boolean includesNorthPole = false;
        boolean includesSouthPole = false;
        if (includesNorthPole && !includesSouthPole) {
            llbb = new LatLonRect(llpt, new LatLonPointImpl(90.0, 0.0));
            llbb.extend(lrpt);
            llbb.extend(urpt);
            llbb.extend(ulpt);
        } else if (includesSouthPole && !includesNorthPole) {
            llbb = new LatLonRect(llpt, new LatLonPointImpl(-90.0, -180.0));
            llbb.extend(lrpt);
            llbb.extend(urpt);
            llbb.extend(ulpt);
        } else {
            double latMin = Math.min(llpt.getLatitude(), lrpt.getLatitude());
            double latMax = Math.max(ulpt.getLatitude(), urpt.getLatitude());
            double lonMin = this.getMinOrMaxLon(llpt.getLongitude(), ulpt.getLongitude(), true);
            double lonMax = this.getMinOrMaxLon(lrpt.getLongitude(), urpt.getLongitude(), false);
            llpt.set(latMin, lonMin);
            urpt.set(latMax, lonMax);
            llbb = new LatLonRect(llpt, urpt);
        }
        return llbb;
    }
}

