/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFcFmrc;
import thredds.catalog.InvDatasetFcPoint;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CatalogCollectionManager;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionUpdater;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.time.CalendarDateRange;

@ThreadSafe
public abstract class InvDatasetFeatureCollection
extends InvCatalogRef
implements CollectionManager.TriggerListener {
    private static final Logger logger = LoggerFactory.getLogger(InvDatasetFeatureCollection.class);
    protected static final String FILES = "files";
    protected static final String Virtual_Services = "VirtualServices";
    private static String context = "/thredds";
    private static String catalogServletName = "/catalog";
    private static String cdmrFeatureServiceUrlPath = "/cdmrFeature";
    protected InvService orgService;
    protected InvService virtualService;
    protected InvService cdmrService;
    protected final String path;
    protected final FeatureType featureType;
    protected final FeatureCollectionConfig config;
    protected final String topDirectory;
    protected CollectionManager dcm;
    @GuardedBy(value="lock")
    protected State state;
    protected final Object lock = new Object();

    public static void setContext(String c) {
        context = c;
    }

    public static void setCatalogServletName(String catServletName) {
        catalogServletName = catServletName;
    }

    private static String buildCatalogServiceHref(String path) {
        return context + (catalogServletName == null ? "" : catalogServletName) + "/" + path + "/catalog.xml";
    }

    public static void setCdmrFeatureServiceUrlPath(String urlPath) {
        cdmrFeatureServiceUrlPath = urlPath;
    }

    private InvService makeCdmrFeatureService() {
        return new InvService("cdmrFeature", "cdmrFeature", context + cdmrFeatureServiceUrlPath, null, null);
    }

    protected String getCatalogHref(String what) {
        return InvDatasetFeatureCollection.buildCatalogServiceHref(this.path + "/" + what);
    }

    public static InvDatasetFeatureCollection factory(InvDatasetImpl parent, String name, String path, FeatureType featureType, FeatureCollectionConfig config) {
        InvDatasetFeatureCollection result = null;
        if (featureType == FeatureType.FMRC) {
            result = new InvDatasetFcFmrc(parent, name, path, featureType, config);
        } else if (featureType == FeatureType.GRIB) {
            try {
                Class<?> c = InvDatasetFeatureCollection.class.getClassLoader().loadClass("thredds.catalog.InvDatasetFcGrib");
                Constructor<?> ctor = c.getConstructor(InvDatasetImpl.class, String.class, String.class, FeatureType.class, FeatureCollectionConfig.class);
                result = (InvDatasetFeatureCollection)ctor.newInstance(new Object[]{parent, name, path, featureType, config});
            }
            catch (Throwable e) {
                logger.error("Failed to open " + name + " path= " + path, e);
                return null;
            }
        } else if (featureType.isPointFeatureType()) {
            result = new InvDatasetFcPoint(parent, name, path, featureType, config);
        }
        if (result != null) {
            result.finishConstruction();
        }
        return result;
    }

    protected InvDatasetFeatureCollection(InvDatasetImpl parent, String name, String path, FeatureType featureType, FeatureCollectionConfig config) {
        super(parent, name, InvDatasetFeatureCollection.buildCatalogServiceHref(path));
        this.path = path;
        this.featureType = featureType;
        this.getLocalMetadataInheritable().setDataType(featureType);
        this.config = config;
        if (config.spec.startsWith("catalog:")) {
            this.dcm = new CatalogCollectionManager(config.spec);
        } else {
            Formatter errlog = new Formatter();
            this.dcm = new MFileCollectionManager(config, errlog);
            String errs = errlog.toString();
            if (errs.length() > 0) {
                logger.debug("DatasetCollectionManager parse error = {} ", (Object)errs);
            }
        }
        this.topDirectory = this.dcm.getRoot();
    }

    protected void finishConstruction() {
        this.dcm.addEventListener(this);
        CollectionUpdater.INSTANCE.scheduleTasks(this.config, this.dcm);
    }

    protected void firstInit() {
        this.orgService = this.getServiceDefault();
        if (this.orgService == null) {
            throw new IllegalStateException("No default service for InvDatasetFeatureCollection " + this.name);
        }
        this.virtualService = this.makeVirtualService(this.orgService);
        this.cdmrService = this.makeCdmrFeatureService();
    }

    @Override
    public void handleCollectionEvent(CollectionManager.TriggerEvent event) {
        boolean tdsUsingTdm;
        boolean bl = tdsUsingTdm = !CollectionUpdater.INSTANCE.isTdm() && this.config.tdmConfig != null;
        if (event.getType() == CollectionManager.TriggerType.updateNocheck) {
            this.update(CollectionManager.Force.nocheck);
        } else if (event.getType() == CollectionManager.TriggerType.update) {
            this.update(tdsUsingTdm ? CollectionManager.Force.nocheck : CollectionManager.Force.test);
        } else if (event.getType() == CollectionManager.TriggerType.proto) {
            this.updateProto();
        }
    }

    public abstract void update(CollectionManager.Force var1);

    public abstract void updateProto();

    protected abstract State checkState() throws IOException;

    public String getPath() {
        return this.path;
    }

    public String getTopDirectoryLocation() {
        return this.topDirectory;
    }

    public FeatureCollectionConfig getConfig() {
        return this.config;
    }

    public CollectionManager getDatasetCollectionManager() {
        return this.dcm;
    }

    public InvDatasetScan getRawFileScan() {
        try {
            this.checkState();
        }
        catch (IOException e) {
            logger.error("Error in checkState", (Throwable)e);
        }
        return this.state.scan;
    }

    @Override
    public List<InvDataset> getDatasets() {
        try {
            this.checkState();
        }
        catch (Exception e) {
            logger.error("Error in checkState", (Throwable)e);
        }
        return this.state.datasets;
    }

    protected InvService makeVirtualService(InvService org) {
        if (org.getServiceType() != ServiceType.COMPOUND) {
            return org;
        }
        InvService result = new InvService(Virtual_Services, ServiceType.COMPOUND.toString(), null, null, null);
        for (InvService service : org.getServices()) {
            if (service.getServiceType() == ServiceType.HTTPServer) continue;
            result.addService(service);
        }
        return result;
    }

    public abstract InvCatalogImpl makeCatalog(String var1, String var2, URI var3);

    protected InvCatalogImpl makeCatalogTop(URI baseURI, State localState) throws IOException, URISyntaxException {
        String id;
        InvCatalogImpl parentCatalog = (InvCatalogImpl)this.getParentCatalog();
        URI myURI = baseURI.resolve(this.getXlinkHref());
        InvCatalogImpl mainCatalog = new InvCatalogImpl(this.getName(), parentCatalog.getVersion(), myURI);
        InvDatasetImpl top = new InvDatasetImpl(this);
        top.setParent(null);
        InvDatasetImpl parent = (InvDatasetImpl)this.getParent();
        if (parent != null) {
            top.transferMetadata(parent, true);
        }
        if ((id = this.getID()) == null) {
            id = this.getPath();
        }
        top.setID(id);
        ThreddsMetadata tmi = top.getLocalMetadataInheritable();
        if (localState.vars != null) {
            tmi.addVariables(localState.vars);
        }
        if (localState.gc != null) {
            tmi.setGeospatialCoverage(localState.gc);
        }
        if (localState.dateRange != null) {
            tmi.setTimeCoverage(localState.dateRange);
        }
        mainCatalog.addDataset(top);
        for (InvDataset ds : this.getDatasets()) {
            top.addDataset((InvDatasetImpl)ds);
        }
        mainCatalog.finish();
        return mainCatalog;
    }

    public ucar.nc2.dt.GridDataset getGridDataset(String matchPath) throws IOException {
        String name;
        int pos = matchPath.indexOf(47);
        String type = pos > -1 ? matchPath.substring(0, pos) : matchPath;
        String string = name = pos > -1 ? matchPath.substring(pos + 1) : "";
        if (type.equals(FILES)) {
            if (this.topDirectory == null) {
                return null;
            }
            String filename = this.topDirectory + (this.topDirectory.endsWith("/") ? "" : "/") + name;
            NetcdfDataset ncd = NetcdfDataset.acquireDataset(null, filename, null, -1, null, null);
            return new GridDataset(ncd);
        }
        return null;
    }

    public FeatureDatasetPoint getFeatureDatasetPoint() {
        return null;
    }

    public NetcdfDataset getNetcdfDataset(String matchPath) throws IOException {
        String name;
        int pos = matchPath.indexOf(47);
        String type = pos > -1 ? matchPath.substring(0, pos) : matchPath;
        String string = name = pos > -1 ? matchPath.substring(pos + 1) : "";
        if (type.equals(FILES)) {
            if (this.topDirectory == null) {
                return null;
            }
            String filename = this.topDirectory + (this.topDirectory.endsWith("/") ? "" : "/") + name;
            return NetcdfDataset.acquireDataset(null, filename, null, -1, null, null);
        }
        ucar.nc2.dt.GridDataset gds = this.getGridDataset(matchPath);
        return gds == null ? null : (NetcdfDataset)gds.getNetcdfFile();
    }

    public File getFile(String remaining) {
        if (null == this.topDirectory) {
            return null;
        }
        int pos = remaining.indexOf(FILES);
        StringBuilder fname = new StringBuilder(this.topDirectory);
        if (!this.topDirectory.endsWith("/")) {
            fname.append("/");
        }
        fname.append(pos > -1 ? remaining.substring(pos + FILES.length() + 1) : remaining);
        return new File(fname.toString());
    }

    static class ScanFilter
    implements CrawlableDatasetFilter {
        private final Pattern p;
        private final long olderThan;

        public ScanFilter(Pattern p, long olderThan) {
            this.p = p;
            this.olderThan = olderThan;
        }

        @Override
        public boolean accept(CrawlableDataset dataset) {
            long now;
            Date lastModDate;
            Matcher matcher;
            if (dataset.isCollection()) {
                return true;
            }
            if (this.p != null && !(matcher = this.p.matcher(dataset.getName())).matches()) {
                return false;
            }
            return this.olderThan <= 0L || (lastModDate = dataset.lastModified()) == null || (now = System.currentTimeMillis()) - lastModDate.getTime() > this.olderThan;
        }

        @Override
        public Object getConfigObject() {
            return null;
        }
    }

    protected class State {
        protected ThreddsMetadata.Variables vars;
        protected ThreddsMetadata.GeospatialCoverage gc;
        protected CalendarDateRange dateRange;
        protected List<InvDataset> datasets;
        protected InvDatasetScan scan;
        protected long lastInvChange;
        protected long lastProtoChange;

        protected State(State from) {
            if (from != null) {
                this.vars = from.vars;
                this.gc = from.gc;
                this.dateRange = from.dateRange;
                this.lastProtoChange = from.lastProtoChange;
                this.scan = from.scan;
                this.datasets = from.datasets;
                this.lastInvChange = from.lastInvChange;
            }
        }
    }
}

