/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt;

import java.util.List;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.vertical.VerticalTransform;

public interface GridCoordSystem {
    public String getName();

    public List<Dimension> getDomain();

    public List<CoordinateAxis> getCoordinateAxes();

    public boolean isProductSet();

    public CoordinateAxis getXHorizAxis();

    public CoordinateAxis getYHorizAxis();

    public CoordinateAxis1D getVerticalAxis();

    public CoordinateAxis getTimeAxis();

    public CoordinateAxis1D getEnsembleAxis();

    public CoordinateAxis1DTime getRunTimeAxis();

    public List<CoordinateTransform> getCoordinateTransforms();

    public ProjectionCT getProjectionCT();

    public ProjectionImpl getProjection();

    public void setProjectionBoundingBox();

    public VerticalCT getVerticalCT();

    public VerticalTransform getVerticalTransform();

    public boolean isLatLon();

    public LatLonRect getLatLonBoundingBox();

    public ProjectionRect getBoundingBox();

    public boolean isRegularSpatial();

    public List<Range> getRangesFromLatLonRect(LatLonRect var1) throws InvalidRangeException;

    public int[] findXYindexFromCoord(double var1, double var3, int[] var5);

    public int[] findXYindexFromCoordBounded(double var1, double var3, int[] var5);

    public int[] findXYindexFromLatLon(double var1, double var3, int[] var5);

    public int[] findXYindexFromLatLonBounded(double var1, double var3, int[] var5);

    public LatLonPoint getLatLon(int var1, int var2);

    public boolean isZPositive();

    public DateRange getDateRange();

    public boolean hasTimeAxis();

    public boolean hasTimeAxis1D();

    public CoordinateAxis1DTime getTimeAxis1D();

    public CoordinateAxis1DTime getTimeAxisForRun(int var1);

    public List<CalendarDate> getCalendarDates();

    public CalendarDateRange getCalendarDateRange();

    public String getHorizStaggerType();
}

