/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.writer.WriterCFPointCollection;
import ucar.nc2.ft.point.writer.WriterCFProfileCollection;
import ucar.nc2.ft.point.writer.WriterCFStationCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonRect;

public class CFPointWriter {
    private static boolean debug = false;
    private static final String[] reservedAtts = new String[]{"Conventions", "geospatial_lat_min", "geospatial_lat_max", "geospatial_lon_min", "geospatial_lon_max", "time_coverage_start", "time_coverage_end", "_CoordSysBuilder"};
    private static final List<String> reservedAttsList = Arrays.asList(reservedAtts);
    protected static final String recordDimName = "record";
    protected static final String latName = "latitude";
    protected static final String lonName = "longitude";
    protected static final String altName = "altitude";
    protected static final String timeName = "time";
    protected NetcdfFileWriteable ncfile;
    protected String altUnits;
    protected LatLonRect llbb = null;
    protected Set<Dimension> dimSet = new HashSet<Dimension>(20);
    protected CalendarDate minDate = null;
    protected CalendarDate maxDate = null;

    public static int writeFeatureCollection(FeatureDatasetPoint fdpoint, String fileOut) throws IOException {
        boolean count = false;
        for (FeatureCollection fc : fdpoint.getPointFeatureCollectionList()) {
            assert (fc instanceof PointFeatureCollection || fc instanceof NestedPointFeatureCollection) : fc.getClass().getName();
            if (fc instanceof PointFeatureCollection) {
                return CFPointWriter.writePointFeatureCollection(fdpoint, (PointFeatureCollection)fc, fileOut);
            }
            if (fc instanceof StationTimeSeriesFeatureCollection) {
                return CFPointWriter.writeStationFeatureCollection(fdpoint, (StationTimeSeriesFeatureCollection)fc, fileOut);
            }
            if (!(fc instanceof ProfileFeatureCollection)) continue;
            return CFPointWriter.writeProfileFeatureCollection(fdpoint, (ProfileFeatureCollection)fc, fileOut);
        }
        return 0;
    }

    private static int writePointFeatureCollection(FeatureDatasetPoint fdpoint, PointFeatureCollection pfc, String fileOut) throws IOException {
        if (debug) {
            System.out.printf("write to file %s%n ", fileOut);
        }
        WriterCFPointCollection writer = new WriterCFPointCollection(fileOut, fdpoint.getGlobalAttributes());
        int count = 0;
        while (pfc.hasNext()) {
            PointFeature pf = pfc.next();
            if (count == 0) {
                writer.writeHeader(fdpoint.getDataVariables(), pf.getTimeUnit(), null);
            }
            writer.writeRecord(pf, pf.getData());
            if (debug && ++count % 100 == 0) {
                System.out.printf("%d ", count);
            }
            if (!debug || count % 1000 != 0) continue;
            System.out.printf("%n ", new Object[0]);
        }
        writer.finish();
        return count;
    }

    private static int writeStationFeatureCollection(FeatureDatasetPoint fdpoint, StationTimeSeriesFeatureCollection fds, String fileOut) throws IOException {
        if (debug) {
            System.out.printf("write to file %s%n ", fileOut);
        }
        WriterCFStationCollection writer = new WriterCFStationCollection(fileOut, fdpoint.getGlobalAttributes());
        PointFeatureCollection pfc = fds.flatten(null, (CalendarDateRange)null);
        int count = 0;
        while (pfc.hasNext()) {
            PointFeature pf = pfc.next();
            if (count == 0) {
                writer.writeHeader(fds.getStations(), fdpoint.getDataVariables(), pf.getTimeUnit(), "");
            }
            StationPointFeature spf = (StationPointFeature)pf;
            writer.writeRecord(spf.getStation(), pf, pf.getData());
            if (debug && ++count % 100 == 0) {
                System.out.printf("%d ", count);
            }
            if (!debug || count % 1000 != 0) continue;
            System.out.printf("%n ", new Object[0]);
        }
        writer.finish();
        return count;
    }

    private static int writeProfileFeatureCollection(FeatureDatasetPoint fdpoint, ProfileFeatureCollection pds, String fileOut) throws IOException {
        if (debug) {
            System.out.printf("write to file %s%n ", fileOut);
        }
        WriterCFProfileCollection writer = new WriterCFProfileCollection(fileOut, fdpoint.getGlobalAttributes());
        int count = 0;
        ArrayList<String> profiles = new ArrayList<String>();
        pds.resetIteration();
        while (pds.hasNext()) {
            profiles.add(pds.next().getName());
        }
        pds.resetIteration();
        while (pds.hasNext()) {
            ProfileFeature profile = pds.next();
            profile.resetIteration();
            while (profile.hasNext()) {
                PointFeature pf = profile.next();
                if (count == 0) {
                    writer.writeHeader(profiles, fdpoint.getDataVariables(), pf.getTimeUnit(), "m");
                }
                writer.writeRecord(profile.getName(), pf, pf.getData());
                if (debug && ++count % 100 == 0) {
                    System.out.printf("%d ", count);
                }
                if (!debug || count % 1000 != 0) continue;
                System.out.printf("%n ", new Object[0]);
            }
        }
        writer.finish();
        return count;
    }

    protected CFPointWriter(String fileOut, List<Attribute> atts) throws IOException {
        this.ncfile = NetcdfFileWriteable.createNew(fileOut, false);
        this.ncfile.setFill(false);
        this.ncfile.addGlobalAttribute("Conventions", "CF-1.6");
        this.ncfile.addGlobalAttribute("history", "Written by CFPointWriter");
        for (Attribute att : atts) {
            if (reservedAttsList.contains(att.getName())) continue;
            this.ncfile.addGlobalAttribute(att);
        }
        this.ncfile.addGlobalAttribute("time_coverage_start", CalendarDateFormatter.toDateStringPresent());
        this.ncfile.addGlobalAttribute("time_coverage_end", CalendarDateFormatter.toDateStringPresent());
        this.ncfile.addGlobalAttribute("geospatial_lat_min", 0.0);
        this.ncfile.addGlobalAttribute("geospatial_lat_max", 0.0);
        this.ncfile.addGlobalAttribute("geospatial_lon_min", 0.0);
        this.ncfile.addGlobalAttribute("geospatial_lon_max", 0.0);
    }

    public void setLength(long size) {
        this.ncfile.setLength(size);
    }

    protected void trackBB(EarthLocation loc, CalendarDate obsDate) {
        if (loc != null) {
            if (this.llbb == null) {
                this.llbb = new LatLonRect(loc.getLatLon(), 0.001, 0.001);
                return;
            }
            this.llbb.extend(loc.getLatLon());
        }
        if (this.minDate == null || this.minDate.isAfter(obsDate)) {
            this.minDate = obsDate;
        }
        if (this.maxDate == null || this.maxDate.isBefore(obsDate)) {
            this.maxDate = obsDate;
        }
    }

    public void finish() throws IOException {
        this.ncfile.updateAttribute(null, new Attribute("geospatial_lat_min", this.llbb.getLowerLeftPoint().getLatitude()));
        this.ncfile.updateAttribute(null, new Attribute("geospatial_lat_max", this.llbb.getUpperRightPoint().getLatitude()));
        this.ncfile.updateAttribute(null, new Attribute("geospatial_lon_min", this.llbb.getLowerLeftPoint().getLongitude()));
        this.ncfile.updateAttribute(null, new Attribute("geospatial_lon_max", this.llbb.getUpperRightPoint().getLongitude()));
        if (this.minDate == null) {
            this.minDate = CalendarDate.present();
        }
        if (this.maxDate == null) {
            this.maxDate = CalendarDate.present();
        }
        this.ncfile.updateAttribute(null, new Attribute("time_coverage_start", CalendarDateFormatter.toDateTimeString(this.minDate)));
        this.ncfile.updateAttribute(null, new Attribute("time_coverage_end", CalendarDateFormatter.toDateTimeString(this.maxDate)));
        this.ncfile.close();
    }
}

