/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.scan;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;

public class FeatureScan {
    private String top;
    private boolean subdirs;
    private boolean debug = false;

    public FeatureScan(String top, boolean subdirs) {
        this.top = top;
        this.subdirs = subdirs;
    }

    public List<Bean> scan(Formatter errlog) {
        ArrayList<Bean> result = new ArrayList<Bean>();
        File topFile = new File(this.top);
        if (!topFile.exists()) {
            errlog.format("File %s does not exist", this.top);
            return result;
        }
        if (topFile.isDirectory()) {
            this.scanDirectory(topFile, result, errlog);
        } else {
            Bean fdb = new Bean(topFile);
            result.add(fdb);
        }
        return result;
    }

    private void scanDirectory(File dir, List<Bean> result, Formatter errlog) {
        if (dir.getName().equals("exclude") || dir.getName().equals("problem")) {
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) continue;
            files.add(f);
        }
        if (files.size() > 0) {
            Collections.sort(files);
            ArrayList files2 = new ArrayList(files);
            File prev = null;
            for (File f : files) {
                String name = f.getName();
                String stem = this.stem(name);
                if (name.endsWith(".gbx") || name.endsWith(".gbx8") || name.endsWith(".pdf") || name.endsWith(".xml") || name.endsWith(".gbx9") || name.endsWith(".ncx") || name.endsWith(".txt")) {
                    files2.remove(f);
                } else if (prev != null) {
                    if (name.endsWith(".ncml") && prev.getName().equals(stem + ".nc")) {
                        files2.remove(prev);
                    } else if (name.endsWith(".bz2")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".gz")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".gzip")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".zip")) {
                        if (prev.getName().equals(stem)) {
                            files2.remove(f);
                        }
                    } else if (name.endsWith(".Z") && prev.getName().equals(stem)) {
                        files2.remove(f);
                    }
                }
                prev = f;
            }
            for (File f : files2) {
                result.add(new Bean(f));
            }
        }
        if (this.subdirs) {
            for (File f : dir.listFiles()) {
                if (!f.isDirectory() || f.getName().equals("exclude")) continue;
                this.scanDirectory(f, result, errlog);
            }
        }
    }

    private String stem(String name) {
        int pos = name.lastIndexOf(46);
        return pos > 0 ? name.substring(0, pos) : name;
    }

    public static void main(String[] arg) {
        FeatureScan scanner = new FeatureScan(arg[0], true);
        System.out.printf(" %-60s %-20s %-10s %-10s%n", "name", "fileType", "featureType", "featureImpl");
        List<Bean> beans = scanner.scan(new Formatter());
        for (Bean b : beans) {
            System.out.printf(" %-60s %-20s %-10s %-10s%n", b.getName(), b.getFileType(), b.getFeatureType(), b.getFeatureImpl());
        }
    }

    public class Bean {
        public File f;
        String fileType;
        String coordMap;
        FeatureType featureType;
        String ftype;
        String info;
        String coordSysBuilder;
        String ftImpl;
        Throwable problem;

        public Bean() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Bean(File f) {
            block17: {
                this.f = f;
                NetcdfDataset ds = null;
                try {
                    if (FeatureScan.this.debug) {
                        System.out.printf(" featureScan=%s%n", f.getPath());
                    }
                    ds = NetcdfDataset.openDataset(f.getPath());
                    this.fileType = ds.getFileTypeId();
                    this.setCoordMap(ds.getCoordinateSystems());
                    this.coordSysBuilder = ds.findAttValueIgnoreCase(null, "_CoordSysBuilder", "none");
                    Formatter errlog = new Formatter();
                    try {
                        FeatureDataset featureDataset = FeatureDatasetFactoryManager.wrap(null, ds, null, errlog);
                        if (featureDataset != null) {
                            this.featureType = featureDataset.getFeatureType();
                            if (this.featureType != null) {
                                this.ftype = this.featureType.toString();
                            }
                            this.ftImpl = featureDataset.getImplementationName();
                            Formatter infof = new Formatter();
                            featureDataset.getDetailInfo(infof);
                            this.info = infof.toString();
                            break block17;
                        }
                        this.ftype = " FAIL: " + errlog.toString();
                    }
                    catch (Throwable t) {
                        this.ftype = " ERR: " + t.getMessage();
                        this.info = errlog.toString();
                        this.problem = t;
                    }
                }
                catch (Throwable t) {
                    this.fileType = " ERR: " + t.getMessage();
                    this.problem = t;
                }
                finally {
                    if (ds != null) {
                        try {
                            ds.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }

        public String getName() {
            return this.f.getPath();
        }

        public String getFileType() {
            return this.fileType;
        }

        public String getCoordMap() {
            return this.coordMap;
        }

        public String getCoordSysBuilder() {
            return this.coordSysBuilder;
        }

        public void setCoordMap(List<CoordinateSystem> csysList) {
            CoordinateSystem use = null;
            for (CoordinateSystem csys : csysList) {
                if (use == null) {
                    use = csys;
                    continue;
                }
                if (csys.getCoordinateAxes().size() <= use.getCoordinateAxes().size()) continue;
                use = csys;
            }
            this.coordMap = use == null ? "" : "f:D(" + use.getRankDomain() + ")->R(" + use.getRankRange() + ")";
        }

        public String getFeatureType() {
            return this.ftype;
        }

        public String getFeatureImpl() {
            return this.ftImpl;
        }

        public void toString(Formatter f, boolean showInfo) {
            f.format("%s%n %s%n map = '%s'%n %s%n %s%n", this.getName(), this.getFileType(), this.getCoordMap(), this.getFeatureType(), this.getFeatureImpl());
            if (showInfo && this.info != null) {
                f.format("\n%s", this.info);
            }
            if (this.problem != null) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
                this.problem.printStackTrace(new PrintStream(bout));
                f.format("\n%s", bout.toString());
            }
        }

        public String toString() {
            Formatter f = new Formatter();
            this.toString(f, true);
            return f.toString();
        }
    }
}

