/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.cinrad;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SimpleTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.cinrad.Cinrad2Record;
import ucar.nc2.iosp.cinrad.Cinrad2VolumeScan;
import ucar.nc2.iosp.nexrad2.NexradStationDB;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.io.RandomAccessFile;

public class Cinrad2IOServiceProvider
extends AbstractIOServiceProvider {
    private static Logger logger = LoggerFactory.getLogger(Cinrad2IOServiceProvider.class);
    private static final int MISSING_INT = -9999;
    private static final float MISSING_FLOAT = Float.NaN;
    private Cinrad2VolumeScan volScan;
    private Dimension radialDim;
    private double radarRadius;
    private DateFormatter formatter = new DateFormatter();

    public boolean isValidFileOld(RandomAccessFile raf) {
        try {
            String loc = raf.getLocation();
            int posFirst = loc.lastIndexOf(47) + 1;
            if (posFirst < 0) {
                posFirst = 0;
            }
            String stationId = loc.substring(posFirst, posFirst + 4);
            NexradStationDB.init();
            NexradStationDB.Station station = NexradStationDB.get("K" + stationId);
            return station != null;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        int data_msecs = 0;
        short data_julian_date = 0;
        try {
            raf.order(1);
            raf.seek(0L);
            raf.skipBytes(14);
            short message_type = raf.readShort();
            if (message_type != 1) {
                return false;
            }
            raf.skipBytes(12);
            byte[] b4 = raf.readBytes(4);
            data_msecs = Cinrad2IOServiceProvider.bytesToInt(b4, true);
            byte[] b2 = raf.readBytes(2);
            data_julian_date = (short)Cinrad2IOServiceProvider.bytesToShort(b2, true);
            Date dd = Cinrad2Record.getDate(data_julian_date, data_msecs);
            GregorianCalendar cal = new GregorianCalendar(new SimpleTimeZone(0, "GMT"));
            cal.clear();
            cal.setTime(dd);
            int year = cal.get(1);
            cal.setTime(new Date());
            int cyear = cal.get(1);
            return year >= 1990 && year <= cyear;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static int bytesToInt(byte[] bytes, boolean swapBytes) {
        byte a = bytes[0];
        byte b = bytes[1];
        byte c = bytes[2];
        byte d = bytes[3];
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8) + ((c & 0xFF) << 16) + ((d & 0xFF) << 24);
        }
        return ((a & 0xFF) << 24) + ((b & 0xFF) << 16) + ((c & 0xFF) << 8) + (d & 0xFF);
    }

    public static int bytesToShort(byte[] bytes, boolean swapBytes) {
        byte a = bytes[0];
        byte b = bytes[1];
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8);
        }
        return ((a & 0xFF) << 24) + ((b & 0xFF) << 16);
    }

    @Override
    public String getFileTypeId() {
        return "CINRAD";
    }

    @Override
    public String getFileTypeDescription() {
        return "Chinese Level-II Base Data";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        NexradStationDB.init();
        this.volScan = new Cinrad2VolumeScan(raf, cancelTask);
        if (this.volScan.hasDifferentDopplarResolutions()) {
            throw new IllegalStateException("volScan.hasDifferentDopplarResolutions");
        }
        this.radialDim = new Dimension("radial", this.volScan.getMaxRadials());
        ncfile.addDimension(null, this.radialDim);
        this.makeVariable(ncfile, 1, "Reflectivity", "Reflectivity", "R", this.volScan.getReflectivityGroups());
        int velocity_type = this.volScan.getDopplarResolution() == 2 ? 2 : 4;
        Variable v = this.makeVariable(ncfile, velocity_type, "RadialVelocity", "Radial Velocity", "V", this.volScan.getVelocityGroups());
        this.makeVariableNoCoords(ncfile, 3, "SpectrumWidth", "Spectrum Width", v);
        if (this.volScan.getStationId() != null) {
            ncfile.addAttribute(null, new Attribute("Station", this.volScan.getStationId()));
            ncfile.addAttribute(null, new Attribute("StationName", this.volScan.getStationName()));
            ncfile.addAttribute(null, new Attribute("StationLatitude", new Double(this.volScan.getStationLatitude())));
            ncfile.addAttribute(null, new Attribute("StationLongitude", new Double(this.volScan.getStationLongitude())));
            ncfile.addAttribute(null, new Attribute("StationElevationInMeters", new Double(this.volScan.getStationElevation())));
            double latRadiusDegrees = Math.toDegrees(this.radarRadius / Earth.getRadius());
            ncfile.addAttribute(null, new Attribute("geospatial_lat_min", new Double(this.volScan.getStationLatitude() - latRadiusDegrees)));
            ncfile.addAttribute(null, new Attribute("geospatial_lat_max", new Double(this.volScan.getStationLatitude() + latRadiusDegrees)));
            double cosLat = Math.cos(Math.toRadians(this.volScan.getStationLatitude()));
            double lonRadiusDegrees = Math.toDegrees(this.radarRadius / cosLat / Earth.getRadius());
            ncfile.addAttribute(null, new Attribute("geospatial_lon_min", new Double(this.volScan.getStationLongitude() - lonRadiusDegrees)));
            ncfile.addAttribute(null, new Attribute("geospatial_lon_max", new Double(this.volScan.getStationLongitude() + lonRadiusDegrees)));
            Variable ct = new Variable(ncfile, null, null, "radialCoordinateTransform");
            ct.setDataType(DataType.CHAR);
            ct.setDimensions("");
            ct.addAttribute(new Attribute("transform_name", "Radial"));
            ct.addAttribute(new Attribute("center_latitude", new Double(this.volScan.getStationLatitude())));
            ct.addAttribute(new Attribute("center_longitude", new Double(this.volScan.getStationLongitude())));
            ct.addAttribute(new Attribute("center_elevation", new Double(this.volScan.getStationElevation())));
            ct.addAttribute(new Attribute("_CoordinateTransformType", "Radial"));
            ct.addAttribute(new Attribute("_CoordinateAxisTypes", "RadialElevation RadialAzimuth RadialDistance"));
            Array data = Array.factory(DataType.CHAR.getPrimitiveClassType(), new int[0], (Object)new char[]{' '});
            ct.setCachedData(data, true);
            ncfile.addVariable(null, ct);
        }
        DateFormatter formatter = new DateFormatter();
        ncfile.addAttribute(null, new Attribute("Conventions", "_Coordinates"));
        ncfile.addAttribute(null, new Attribute("format", this.volScan.getDataFormat()));
        ncfile.addAttribute(null, new Attribute("featureType", FeatureType.RADIAL.toString()));
        ncfile.addAttribute(null, new Attribute("time_coverage_start", formatter.toDateTimeStringISO(this.volScan.getStartDate())));
        ncfile.addAttribute(null, new Attribute("time_coverage_end", formatter.toDateTimeStringISO(this.volScan.getEndDate())));
        ncfile.addAttribute(null, new Attribute("history", "Direct read of Nexrad Level 2 file into NetCDF-Java 2.2 API"));
        ncfile.addAttribute(null, new Attribute("DataType", "Radial"));
        ncfile.addAttribute(null, new Attribute("Title", "Nexrad Level 2 Station " + this.volScan.getStationId() + " from " + formatter.toDateTimeStringISO(this.volScan.getStartDate()) + " to " + formatter.toDateTimeStringISO(this.volScan.getEndDate())));
        ncfile.addAttribute(null, new Attribute("Summary", "Weather Surveillance Radar-1988 Doppler (WSR-88D) Level II data are the three meteorological base data quantities: reflectivity, mean radial velocity, and spectrum width."));
        ncfile.addAttribute(null, new Attribute("keywords", "WSR-88D; NEXRAD; Radar Level II; reflectivity; mean radial velocity; spectrum width"));
        ncfile.addAttribute(null, new Attribute("VolumeCoveragePatternName", Cinrad2Record.getVolumeCoveragePatternName(this.volScan.getVCP())));
        ncfile.addAttribute(null, new Attribute("VolumeCoveragePattern", new Integer(this.volScan.getVCP())));
        ncfile.addAttribute(null, new Attribute("HorizonatalBeamWidthInDegrees", new Double(1.5)));
        ncfile.finish();
    }

    public Variable makeVariable(NetcdfFile ncfile, int datatype, String shortName, String longName, String abbrev, List groups) throws IOException {
        int nscans = groups.size();
        if (nscans == 0) {
            throw new IllegalStateException("No data for " + shortName);
        }
        List firstGroup = (List)groups.get(0);
        Cinrad2Record firstRecord = (Cinrad2Record)firstGroup.get(0);
        int ngates = firstRecord.getGateCount(datatype);
        String scanDimName = "scan" + abbrev;
        String gateDimName = "gate" + abbrev;
        Dimension scanDim = new Dimension(scanDimName, nscans);
        Dimension gateDim = new Dimension(gateDimName, ngates);
        ncfile.addDimension(null, scanDim);
        ncfile.addDimension(null, gateDim);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(scanDim);
        dims.add(this.radialDim);
        dims.add(gateDim);
        Variable v = new Variable(ncfile, null, null, shortName);
        v.setDataType(DataType.BYTE);
        v.setDimensions(dims);
        ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("units", Cinrad2Record.getDatatypeUnits(datatype)));
        v.addAttribute(new Attribute("long_name", longName));
        byte[] b = new byte[]{1, 0};
        Array missingArray = Array.factory(DataType.BYTE.getPrimitiveClassType(), new int[]{2}, (Object)b);
        v.addAttribute(new Attribute("missing_value", missingArray));
        v.addAttribute(new Attribute("signal_below_threshold", new Byte(0)));
        v.addAttribute(new Attribute("scale_factor", new Float(Cinrad2Record.getDatatypeScaleFactor(datatype))));
        v.addAttribute(new Attribute("add_offset", new Float(Cinrad2Record.getDatatypeAddOffset(datatype))));
        v.addAttribute(new Attribute("_Unsigned", "true"));
        ArrayList<Dimension> dim2 = new ArrayList<Dimension>();
        dim2.add(scanDim);
        dim2.add(this.radialDim);
        String timeCoordName = "time" + abbrev;
        Variable timeVar = new Variable(ncfile, null, null, timeCoordName);
        timeVar.setDataType(DataType.INT);
        timeVar.setDimensions(dim2);
        ncfile.addVariable(null, timeVar);
        Date d = this.volScan.getStartDate();
        String units = "msecs since " + this.formatter.toDateTimeStringISO(d);
        timeVar.addAttribute(new Attribute("long_name", "time since base date"));
        timeVar.addAttribute(new Attribute("units", units));
        timeVar.addAttribute(new Attribute("missing_value", new Integer(-9999)));
        timeVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        String elevCoordName = "elevation" + abbrev;
        Variable elevVar = new Variable(ncfile, null, null, elevCoordName);
        elevVar.setDataType(DataType.FLOAT);
        elevVar.setDimensions(dim2);
        ncfile.addVariable(null, elevVar);
        elevVar.addAttribute(new Attribute("units", "degrees"));
        elevVar.addAttribute(new Attribute("long_name", "elevation angle in degres: 0 = parallel to pedestal base, 90 = perpendicular"));
        elevVar.addAttribute(new Attribute("missing_value", new Float(Float.NaN)));
        elevVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialElevation.toString()));
        String aziCoordName = "azimuth" + abbrev;
        Variable aziVar = new Variable(ncfile, null, null, aziCoordName);
        aziVar.setDataType(DataType.FLOAT);
        aziVar.setDimensions(dim2);
        ncfile.addVariable(null, aziVar);
        aziVar.addAttribute(new Attribute("units", "degrees"));
        aziVar.addAttribute(new Attribute("long_name", "azimuth angle in degrees: 0 = true north, 90 = east"));
        aziVar.addAttribute(new Attribute("missing_value", new Float(Float.NaN)));
        aziVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialAzimuth.toString()));
        String gateCoordName = "distance" + abbrev;
        Variable gateVar = new Variable(ncfile, null, null, gateCoordName);
        gateVar.setDataType(DataType.FLOAT);
        gateVar.setDimensions(gateDimName);
        Array data = Array.makeArray(DataType.FLOAT, ngates, firstRecord.getGateStart(datatype), firstRecord.getGateSize(datatype));
        gateVar.setCachedData(data, false);
        ncfile.addVariable(null, gateVar);
        this.radarRadius = firstRecord.getGateStart(datatype) + ngates * firstRecord.getGateSize(datatype);
        gateVar.addAttribute(new Attribute("units", "m"));
        gateVar.addAttribute(new Attribute("long_name", "radial distance to start of gate"));
        gateVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialDistance.toString()));
        String nradialsName = "numRadials" + abbrev;
        Variable nradialsVar = new Variable(ncfile, null, null, nradialsName);
        nradialsVar.setDataType(DataType.INT);
        nradialsVar.setDimensions(scanDim.getName());
        nradialsVar.addAttribute(new Attribute("long_name", "number of valid radials in this scan"));
        ncfile.addVariable(null, nradialsVar);
        String ngateName = "numGates" + abbrev;
        Variable ngateVar = new Variable(ncfile, null, null, ngateName);
        ngateVar.setDataType(DataType.INT);
        ngateVar.setDimensions(scanDim.getName());
        ngateVar.addAttribute(new Attribute("long_name", "number of valid gates in this scan"));
        ncfile.addVariable(null, ngateVar);
        this.makeCoordinateDataWithMissing(datatype, timeVar, elevVar, aziVar, nradialsVar, ngateVar, groups);
        String coordinates = timeCoordName + " " + elevCoordName + " " + aziCoordName + " " + gateCoordName;
        v.addAttribute(new Attribute("_CoordinateAxes", coordinates));
        int nradials = this.radialDim.getLength();
        Cinrad2Record[][] map = new Cinrad2Record[nscans][nradials];
        for (int i = 0; i < groups.size(); ++i) {
            Cinrad2Record[] mapScan = map[i];
            List group = (List)groups.get(i);
            for (int j = 0; j < group.size(); ++j) {
                Cinrad2Record r = (Cinrad2Record)group.get(j);
                int radial = r.radial_num - 1;
                mapScan[radial] = r;
            }
        }
        Vgroup vg = new Vgroup(datatype, map);
        v.setSPobject(vg);
        return v;
    }

    private void makeVariableNoCoords(NetcdfFile ncfile, int datatype, String shortName, String longName, Variable from) {
        Variable v = new Variable(ncfile, null, null, shortName);
        v.setDataType(DataType.BYTE);
        v.setDimensions(from.getDimensions());
        ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("units", Cinrad2Record.getDatatypeUnits(datatype)));
        v.addAttribute(new Attribute("long_name", longName));
        byte[] b = new byte[]{1, 0};
        Array missingArray = Array.factory(DataType.BYTE.getPrimitiveClassType(), new int[]{2}, (Object)b);
        v.addAttribute(new Attribute("missing_value", missingArray));
        v.addAttribute(new Attribute("signal_below_threshold", new Byte(0)));
        v.addAttribute(new Attribute("scale_factor", new Float(Cinrad2Record.getDatatypeScaleFactor(datatype))));
        v.addAttribute(new Attribute("add_offset", new Float(Cinrad2Record.getDatatypeAddOffset(datatype))));
        v.addAttribute(new Attribute("_Unsigned", "true"));
        Attribute fromAtt = from.findAttribute("_CoordinateAxes");
        v.addAttribute(new Attribute("_CoordinateAxes", fromAtt));
        Vgroup vgFrom = (Vgroup)from.getSPobject();
        Vgroup vg = new Vgroup(datatype, vgFrom.map);
        v.setSPobject(vg);
    }

    private void makeCoordinateData(int datatype, Variable time, Variable elev, Variable azi, Variable nradialsVar, Variable ngatesVar, List groups) {
        Array timeData = Array.factory(time.getDataType().getPrimitiveClassType(), time.getShape());
        IndexIterator timeDataIter = timeData.getIndexIterator();
        Array elevData = Array.factory(elev.getDataType().getPrimitiveClassType(), elev.getShape());
        IndexIterator elevDataIter = elevData.getIndexIterator();
        Array aziData = Array.factory(azi.getDataType().getPrimitiveClassType(), azi.getShape());
        IndexIterator aziDataIter = aziData.getIndexIterator();
        Array nradialsData = Array.factory(nradialsVar.getDataType().getPrimitiveClassType(), nradialsVar.getShape());
        IndexIterator nradialsIter = nradialsData.getIndexIterator();
        Array ngatesData = Array.factory(ngatesVar.getDataType().getPrimitiveClassType(), ngatesVar.getShape());
        IndexIterator ngatesIter = ngatesData.getIndexIterator();
        int last_msecs = Integer.MIN_VALUE;
        int nscans = groups.size();
        int maxRadials = this.volScan.getMaxRadials();
        for (int i = 0; i < nscans; ++i) {
            int j;
            List scanGroup = (List)groups.get(i);
            int nradials = scanGroup.size();
            Cinrad2Record first = null;
            for (j = 0; j < nradials; ++j) {
                Cinrad2Record r = (Cinrad2Record)scanGroup.get(j);
                if (first == null) {
                    first = r;
                }
                timeDataIter.setIntNext(r.data_msecs);
                elevDataIter.setFloatNext(r.getElevation());
                aziDataIter.setFloatNext(r.getAzimuth());
                if (r.data_msecs < last_msecs) {
                    logger.warn("makeCoordinateData time out of order " + r.data_msecs);
                }
                last_msecs = r.data_msecs;
            }
            for (j = nradials; j < maxRadials; ++j) {
                timeDataIter.setIntNext(-9999);
                elevDataIter.setFloatNext(Float.NaN);
                aziDataIter.setFloatNext(Float.NaN);
            }
            nradialsIter.setIntNext(nradials);
            ngatesIter.setIntNext(first.getGateCount(datatype));
        }
        time.setCachedData(timeData, false);
        elev.setCachedData(elevData, false);
        azi.setCachedData(aziData, false);
        nradialsVar.setCachedData(nradialsData, false);
        ngatesVar.setCachedData(ngatesData, false);
    }

    private void makeCoordinateDataWithMissing(int datatype, Variable time, Variable elev, Variable azi, Variable nradialsVar, Variable ngatesVar, List groups) {
        Array timeData = Array.factory(time.getDataType().getPrimitiveClassType(), time.getShape());
        Index timeIndex = timeData.getIndex();
        Array elevData = Array.factory(elev.getDataType().getPrimitiveClassType(), elev.getShape());
        Index elevIndex = elevData.getIndex();
        Array aziData = Array.factory(azi.getDataType().getPrimitiveClassType(), azi.getShape());
        Index aziIndex = aziData.getIndex();
        Array nradialsData = Array.factory(nradialsVar.getDataType().getPrimitiveClassType(), nradialsVar.getShape());
        IndexIterator nradialsIter = nradialsData.getIndexIterator();
        Array ngatesData = Array.factory(ngatesVar.getDataType().getPrimitiveClassType(), ngatesVar.getShape());
        IndexIterator ngatesIter = ngatesData.getIndexIterator();
        IndexIterator ii = timeData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setIntNext(-9999);
        }
        ii = elevData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setFloatNext(Float.NaN);
        }
        ii = aziData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setFloatNext(Float.NaN);
        }
        int last_msecs = Integer.MIN_VALUE;
        int nscans = groups.size();
        try {
            for (int scan = 0; scan < nscans; ++scan) {
                List scanGroup = (List)groups.get(scan);
                int nradials = scanGroup.size();
                Cinrad2Record first = null;
                for (int j = 0; j < nradials; ++j) {
                    Cinrad2Record r = (Cinrad2Record)scanGroup.get(j);
                    if (first == null) {
                        first = r;
                    }
                    int radial = r.radial_num - 1;
                    timeData.setInt(timeIndex.set(scan, radial), r.data_msecs);
                    elevData.setFloat(elevIndex.set(scan, radial), r.getElevation());
                    aziData.setFloat(aziIndex.set(scan, radial), r.getAzimuth());
                    if (r.data_msecs < last_msecs) {
                        logger.warn("makeCoordinateData time out of order " + r.data_msecs);
                    }
                    last_msecs = r.data_msecs;
                }
                nradialsIter.setIntNext(nradials);
                ngatesIter.setIntNext(first.getGateCount(datatype));
            }
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            logger.debug("Cinrad2IOSP.uncompress ", (Throwable)ae);
        }
        time.setCachedData(timeData, false);
        elev.setCachedData(elevData, false);
        azi.setCachedData(aziData, false);
        nradialsVar.setCachedData(nradialsData, false);
        ngatesVar.setCachedData(ngatesData, false);
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Vgroup vgroup = (Vgroup)v2.getSPobject();
        Range scanRange = section.getRange(0);
        Range radialRange = section.getRange(1);
        Range gateRange = section.getRange(2);
        Array data = Array.factory(v2.getDataType().getPrimitiveClassType(), section.getShape());
        IndexIterator ii = data.getIndexIterator();
        for (int i = scanRange.first(); i <= scanRange.last(); i += scanRange.stride()) {
            Cinrad2Record[] mapScan = vgroup.map[i];
            this.readOneScan(mapScan, radialRange, gateRange, vgroup.datatype, ii);
        }
        return data;
    }

    private void readOneScan(Cinrad2Record[] mapScan, Range radialRange, Range gateRange, int datatype, IndexIterator ii) throws IOException {
        for (int i = radialRange.first(); i <= radialRange.last(); i += radialRange.stride()) {
            Cinrad2Record r = mapScan[i];
            this.readOneRadial(r, datatype, gateRange, ii);
        }
    }

    private void readOneRadial(Cinrad2Record r, int datatype, Range gateRange, IndexIterator ii) throws IOException {
        if (r == null) {
            for (int i = gateRange.first(); i <= gateRange.last(); i += gateRange.stride()) {
                ii.setByteNext((byte)1);
            }
            return;
        }
        r.readData(this.volScan.raf, datatype, gateRange, ii);
    }

    @Override
    public void close() throws IOException {
        this.volScan.raf.close();
    }

    private class Vgroup {
        Cinrad2Record[][] map;
        int datatype;

        Vgroup(int datatype, Cinrad2Record[][] map) {
            this.datatype = datatype;
            this.map = map;
        }
    }
}

