/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;

public abstract class GridEnsembleCoord {
    private static Logger log = LoggerFactory.getLogger(GridEnsembleCoord.class);
    protected List<EnsCoord> ensCoords;
    protected int seq = 0;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridEnsembleCoord that = (GridEnsembleCoord)o;
        return ((Object)this.ensCoords).equals(that.ensCoords);
    }

    public int hashCode() {
        return ((Object)this.ensCoords).hashCode();
    }

    public void setSequence(int seq) {
        this.seq = seq;
    }

    public String getName() {
        return this.seq == 0 ? "ens" : "ens" + this.seq;
    }

    public void addDimensionsToNetcdfFile(NetcdfFile ncfile, Group g) {
        ncfile.addDimension(g, new Dimension(this.getName(), this.getNEnsembles(), true));
    }

    protected void addToNetcdfFile(NetcdfFile ncfile, Group g) {
    }

    public int getNEnsembles() {
        return this.ensCoords.size();
    }

    protected class EnsCoord
    implements Comparable<EnsCoord> {
        public int number;
        public int type;

        public EnsCoord(int number, int type) {
            this.number = number;
            this.type = type;
        }

        @Override
        public int compareTo(EnsCoord o) {
            int r = this.number - o.number;
            return r == 0 ? this.type - o.type : r;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnsCoord ensCoord = (EnsCoord)o;
            if (this.number != ensCoord.number) {
                return false;
            }
            return this.type == ensCoord.type;
        }

        public int hashCode() {
            return 1000 * this.number + this.type;
        }

        public String toString() {
            return "number=" + this.number + ", type=" + this.type;
        }
    }
}

