/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

public enum HTTPAuthScheme {
    BASIC("BASIC"),
    DIGEST("DIGEST"),
    SSL("SSL"),
    PROXY("PROXY"),
    ANY("ANY");

    private final String name;

    private HTTPAuthScheme(String name) {
        this.name = name;
    }

    public String getSchemeName() {
        return this.name;
    }

    public static HTTPAuthScheme schemeForName(String name) {
        if (name != null) {
            for (HTTPAuthScheme s : HTTPAuthScheme.values()) {
                if (!name.equalsIgnoreCase(s.name())) continue;
                return s;
            }
        }
        return null;
    }

    public static HTTPAuthScheme fromAuthScope(String scheme) {
        if (scheme == null) {
            return null;
        }
        if (scheme.equals("Basic")) {
            return BASIC;
        }
        if (scheme.equals("Digest")) {
            return DIGEST;
        }
        return null;
    }
}

